/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class WMSLayerExtent
extends AbstractXMLEventParser {
    protected String extent;
    protected String name;
    protected String defaultValue;
    protected Boolean nearestValue;

    public WMSLayerExtent(String string) {
        super(string);
    }

    @Override
    protected void doParseEventAttributes(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) {
        Iterator<Attribute> iterator = xMLEvent.asStartElement().getAttributes();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            Boolean bl;
            Attribute attribute = iterator.next();
            if (attribute.getName().getLocalPart().equals("name") && attribute.getValue() != null) {
                this.setName(attribute.getValue());
                continue;
            }
            if (attribute.getName().getLocalPart().equals("default") && attribute.getValue() != null) {
                this.setDefaultValue(attribute.getValue());
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("nearestValue") || attribute.getValue() == null || (bl = WWUtil.convertStringToBoolean(attribute.getValue())) == null) continue;
            this.setNearestValue(bl);
        }
    }

    public String getExtent() {
        return this.getCharacters();
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        this.name = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public Boolean isNearestValue() {
        return this.nearestValue;
    }

    protected void setNearestValue(Boolean bl) {
        this.nearestValue = bl;
    }
}

