/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wms;

import gov.nasa.worldwind.ogc.OGCCapabilityInformation;
import gov.nasa.worldwind.ogc.OGCRequestDescription;
import gov.nasa.worldwind.ogc.wms.WMSLayerCapabilities;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WMSCapabilityInformation
extends OGCCapabilityInformation {
    private static final String[] rNames = new String[]{"GetCapabilities", "GetMap", "GetFeatureInfo", "DescribeLayer", "GetLegendGraphic"};
    protected QName LAYER;
    protected List<QName> requestNames;
    protected List<WMSLayerCapabilities> layerCapabilities;

    public WMSCapabilityInformation(String string) {
        super(string);
        this.initialize();
    }

    private void initialize() {
        this.LAYER = new QName(this.getNamespaceURI(), "Layer");
        this.requestNames = new ArrayList<QName>(rNames.length);
        for (String string : rNames) {
            this.requestNames.add(new QName(this.getNamespaceURI(), string));
        }
        this.setLayerCapabilities(new ArrayList<WMSLayerCapabilities>());
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LAYER)) {
            return xMLEventParserContext.allocate(xMLEvent, new WMSLayerCapabilities(this.getNamespaceURI()));
        }
        return super.allocate(xMLEventParserContext, xMLEvent);
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LAYER)) {
            Object object;
            XMLEventParser xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent);
            if (xMLEventParser != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof WMSLayerCapabilities) {
                WMSLayerCapabilities wMSLayerCapabilities = (WMSLayerCapabilities)object;
                wMSLayerCapabilities.setEnclosingCapabilityInformation(this);
                wMSLayerCapabilities.resolveAttributes(null);
                this.getLayerCapabilities().add(wMSLayerCapabilities);
            }
        } else {
            super.doParseEventContent(xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    @Override
    protected boolean isRequestName(XMLEventParserContext xMLEventParserContext, QName qName) {
        for (QName qName2 : this.requestNames) {
            if (!xMLEventParserContext.isSameName(qName2, qName)) continue;
            return true;
        }
        return false;
    }

    public List<WMSLayerCapabilities> getLayerCapabilities() {
        return this.layerCapabilities;
    }

    protected void setLayerCapabilities(List<WMSLayerCapabilities> list) {
        this.layerCapabilities = list;
    }

    public Set<String> getImageFormats() {
        Set<OGCRequestDescription> set = this.getRequestDescriptions();
        for (OGCRequestDescription oGCRequestDescription : set) {
            if (!oGCRequestDescription.getRequestName().equals("GetMap")) continue;
            return oGCRequestDescription.getFormats();
        }
        return null;
    }
}

