/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSTelephone
extends AbstractXMLEventParser {
    protected QName VOICE;
    protected QName FACSIMILE;
    protected List<String> voiceNumbers = new ArrayList<String>();
    protected List<String> facsimileNumbers = new ArrayList<String>();

    public OWSTelephone(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.VOICE = new QName(this.getNamespaceURI(), "Voice");
        this.FACSIMILE = new QName(this.getNamespaceURI(), "Facsimile");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.VOICE)) {
            this.addVoiceNumber((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.FACSIMILE)) {
            this.addFacsimileNumber((String)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addVoiceNumber(String string) {
        this.voiceNumbers.add(string);
    }

    protected void addFacsimileNumber(String string) {
        this.facsimileNumbers.add(string);
    }

    public List<String> getVoiceNumbers() {
        return this.voiceNumbers;
    }

    public List<String> getFacsimileNumbers() {
        return this.facsimileNumbers;
    }
}

