/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLinkControl;
import gov.nasa.worldwind.ogc.kml.KMLParserContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.io.KMLDoc;
import gov.nasa.worldwind.ogc.kml.io.KMLFile;
import gov.nasa.worldwind.ogc.kml.io.KMLInputStream;
import gov.nasa.worldwind.ogc.kml.io.KMZFile;
import gov.nasa.worldwind.ogc.kml.io.KMZInputStream;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import gov.nasa.worldwind.util.xml.XMLEventParserContextFactory;
import gov.nasa.worldwind.util.xml.XMLParserNotification;
import gov.nasa.worldwind.util.xml.XMLParserNotificationListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLRoot
extends KMLAbstractObject
implements KMLRenderable {
    protected KMLDoc kmlDoc;
    protected XMLEventReader eventReader;
    protected InputStream eventStream;
    protected KMLParserContext parserContext;
    protected PropertyChangeSupport propertyChangeSupport;
    protected double detailHint;
    protected boolean featureFetched = false;
    protected KMLAbstractFeature feature;
    protected boolean linkControlFetched = false;
    protected KMLNetworkLinkControl networkLinkControl;

    public static KMLRoot create(Object object) throws IOException {
        return KMLRoot.create(object, true);
    }

    public static KMLRoot create(Object object, boolean bl) throws IOException {
        if (object == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof File) {
            return new KMLRoot((File)object, bl);
        }
        if (object instanceof URL) {
            return new KMLRoot((URL)object, null, bl);
        }
        if (object instanceof InputStream) {
            return new KMLRoot((InputStream)object, null, bl);
        }
        if (object instanceof String) {
            File file = new File((String)object);
            if (file.exists()) {
                return new KMLRoot(file, bl);
            }
            URL uRL = WWIO.makeURL(object);
            if (uRL != null) {
                return new KMLRoot(uRL, null, bl);
            }
        }
        return null;
    }

    public static KMLRoot createAndParse(Object object) throws IOException, XMLStreamException {
        KMLRoot kMLRoot = KMLRoot.create(object);
        if (kMLRoot == null) {
            String string = Logging.getMessage("generic.UnrecognizedSourceTypeOrUnavailableSource", object.toString());
            throw new IllegalArgumentException(string);
        }
        try {
            kMLRoot.parse(new Object[0]);
        }
        catch (XMLStreamException xMLStreamException) {
            kMLRoot = KMLRoot.create(object, false);
            kMLRoot.parse(new Object[0]);
        }
        return kMLRoot;
    }

    public KMLRoot(KMLDoc kMLDoc) throws IOException {
        this(kMLDoc, true);
    }

    public KMLRoot(KMLDoc kMLDoc, boolean bl) throws IOException {
        super("http://www.opengis.net/kml/2.2");
        if (kMLDoc == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.kmlDoc = kMLDoc;
        this.initialize(bl);
    }

    public KMLRoot(File file) throws IOException {
        this(file, true);
    }

    public KMLRoot(File file, boolean bl) throws IOException {
        super("http://www.opengis.net/kml/2.2");
        if (file == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (WWIO.isContentType(file, "application/vnd.google-earth.kml+xml")) {
            this.kmlDoc = new KMLFile(file);
        } else if (WWIO.isContentType(file, "application/vnd.google-earth.kmz")) {
            try {
                this.kmlDoc = new KMZFile(file);
            }
            catch (ZipException zipException) {
                this.kmlDoc = new KMZInputStream(new FileInputStream(file));
            }
        } else {
            throw new WWUnrecognizedException(Logging.getMessage("KML.UnrecognizedKMLFileType"));
        }
        this.initialize(bl);
    }

    public KMLRoot(InputStream inputStream, String string) throws IOException {
        this(inputStream, string, true);
    }

    public KMLRoot(InputStream inputStream, String string, boolean bl) throws IOException {
        super("http://www.opengis.net/kml/2.2");
        if (inputStream == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.kmlDoc = string != null && string.equals("application/vnd.google-earth.kmz") ? new KMZInputStream(inputStream) : (string == null && inputStream instanceof ZipInputStream ? new KMZInputStream(inputStream) : new KMLInputStream(inputStream, null));
        this.initialize(bl);
    }

    public KMLRoot(URL uRL, String string) throws IOException {
        this(uRL, string, true);
    }

    public KMLRoot(URL uRL, String string, boolean bl) throws IOException {
        super("http://www.opengis.net/kml/2.2");
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        URLConnection uRLConnection = uRL.openConnection();
        if (string == null) {
            string = uRLConnection.getContentType();
        }
        if (!"application/vnd.google-earth.kmz".equals(string) && !"application/vnd.google-earth.kml+xml".equals(string)) {
            string = WWIO.makeMimeTypeForSuffix(WWIO.getSuffix(uRL.getPath()));
        }
        this.kmlDoc = "application/vnd.google-earth.kmz".equals(string) ? new KMZInputStream(uRLConnection.getInputStream()) : new KMLInputStream(uRLConnection.getInputStream(), WWIO.makeURI(uRL));
        this.initialize(bl);
    }

    public KMLRoot(String string, KMLDoc kMLDoc) throws IOException {
        this(string, kMLDoc, true);
    }

    public KMLRoot(String string, KMLDoc kMLDoc, boolean bl) throws IOException {
        super(string);
        if (kMLDoc == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.kmlDoc = kMLDoc;
        this.initialize(bl);
    }

    protected void initialize(boolean bl) throws IOException {
        this.eventStream = this.getKMLDoc().getKMLStream();
        this.eventReader = this.createReader(this.eventStream, bl);
        if (this.eventReader == null) {
            throw new WWRuntimeException(Logging.getMessage("XML.UnableToOpenDocument", this.getKMLDoc()));
        }
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object, boolean bl) {
        return WWXML.openEventReader(object, bl);
    }

    protected KMLParserContext createParserContext(XMLEventReader xMLEventReader) {
        KMLParserContext kMLParserContext = (KMLParserContext)XMLEventParserContextFactory.createParserContext("application/vnd.google-earth.kml+xml", this.getNamespaceURI());
        if (kMLParserContext == null) {
            String[] stringArray = new String[]{"application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz"};
            XMLEventParserContextFactory.addParserContext(stringArray, new KMLParserContext(this.getNamespaceURI()));
            kMLParserContext = (KMLParserContext)XMLEventParserContextFactory.createParserContext("application/vnd.google-earth.kml+xml", this.getNamespaceURI());
        }
        kMLParserContext.setEventReader(xMLEventReader);
        return kMLParserContext;
    }

    public void setNotificationListener(final XMLParserNotificationListener xMLParserNotificationListener) {
        if (xMLParserNotificationListener == null) {
            this.parserContext.setNotificationListener(null);
        } else {
            this.parserContext.setNotificationListener(new XMLParserNotificationListener(){

                @Override
                public void notify(XMLParserNotification xMLParserNotification) {
                    xMLParserNotification.setSource(KMLRoot.this);
                    xMLParserNotificationListener.notify(xMLParserNotification);
                }
            });
        }
    }

    public KMLDoc getKMLDoc() {
        return this.kmlDoc;
    }

    public Object getItemByID(String string) {
        return string != null ? this.getParserContext().getIdTable().get(string) : null;
    }

    public String getSupportFilePath(String string) throws IOException {
        return this.getKMLDoc().getSupportFilePath(string);
    }

    public Object resolveReference(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.resolveReference(string, true);
    }

    public Object resolveReference(String string, boolean bl) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Object object;
            String string3;
            String[] stringArray = string.split("#");
            String string4 = stringArray[0];
            String string5 = string3 = stringArray.length > 1 ? stringArray[1] : null;
            if (WWUtil.isEmpty(string4) && !WWUtil.isEmpty(string3)) {
                return this.getItemByID(string3);
            }
            String string6 = this.getSupportFilePath(string4);
            if (string6 == null) {
                string6 = string4;
            }
            if ((object = WorldWind.getSessionCache().get(string6)) != null && object instanceof KMLRoot) {
                return string3 != null ? ((KMLRoot)object).getItemByID(string3) : object;
            }
            URL uRL = WWIO.makeURL(string6);
            if (uRL == null) {
                object = this.resolveLocalReference(string6, string3);
            }
            if (object == null) {
                object = this.resolveRemoteReference(string6, string3, bl);
            }
            if (object != null) {
                return object;
            }
            return this.getItemByID(string);
        }
        catch (Exception exception) {
            String string7 = Logging.getMessage("generic.UnableToResolveReference", string);
            Logging.logger().warning(string7);
            return null;
        }
    }

    public Object resolveLocalReference(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            File file = new File(string);
            if (!file.exists() || !WWIO.isContentType(file, "application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kmz")) {
                return string;
            }
            KMLRoot kMLRoot = KMLRoot.createAndParse(file);
            WorldWind.getSessionCache().put(string, kMLRoot);
            if (string2 != null) {
                return kMLRoot.getItemByID(string2);
            }
            return kMLRoot;
        }
        catch (Exception exception) {
            String string4 = Logging.getMessage("generic.UnableToResolveReference", string + "/" + string2);
            Logging.logger().warning(string4);
            return null;
        }
    }

    public Object resolveRemoteReference(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return this.resolveRemoteReference(string, string2, true);
    }

    public Object resolveRemoteReference(String string, String string2, boolean bl) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        try {
            Object object;
            URL uRL = WorldWind.getDataFileStore().requestFile(string, bl);
            if (uRL == null) {
                return null;
            }
            String string4 = WorldWind.getDataFileStore().getContentType(string);
            if (string4 == null && !WWUtil.isEmpty(object = WWIO.getSuffix(string.split(";")[0]))) {
                string4 = WWIO.makeMimeTypeForSuffix((String)object);
            }
            if (!this.canParseContentType(string4)) {
                return uRL;
            }
            try {
                object = this.parseCachedKMLFile(uRL, string, string4, true);
            }
            catch (XMLStreamException xMLStreamException) {
                object = this.parseCachedKMLFile(uRL, string, string4, false);
            }
            if (object == null) {
                return uRL;
            }
            WorldWind.getSessionCache().put(string, object);
            if (string2 != null) {
                return ((KMLRoot)object).getItemByID(string2);
            }
            return object;
        }
        catch (Exception exception) {
            String string5 = Logging.getMessage("generic.UnableToResolveReference", string + "/" + string2);
            Logging.logger().warning(string5);
            return null;
        }
    }

    public Object resolveNetworkLink(String string, boolean bl, long l) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = null;
        try {
            String string3 = this.getSupportFilePath(string);
            if (string3 == null) {
                string3 = string;
            }
            if (bl && (object = WorldWind.getSessionCache().get(string3)) instanceof KMLRoot) {
                return object;
            }
            URL uRL = WWIO.makeURL(string3);
            if (uRL == null) {
                object = this.resolveLocalReference(string3, null);
            }
            if (object == null) {
                File file;
                uRL = WorldWind.getDataFileStore().requestFile(string3, bl);
                if (uRL != null && (file = new File(uRL.toURI())).lastModified() < l) {
                    WorldWind.getDataFileStore().removeFile(string);
                }
                object = this.resolveRemoteReference(string3, null, bl);
            }
        }
        catch (Exception exception) {
            String string4 = Logging.getMessage("generic.UnableToResolveReference", string);
            Logging.logger().warning(string4);
        }
        return object;
    }

    public void evictIfExpired(String string, long l) {
        try {
            File file;
            URL uRL = WorldWind.getDataFileStore().requestFile(string, false);
            if (uRL != null && (file = new File(uRL.toURI())).lastModified() < l) {
                WorldWind.getDataFileStore().removeFile(string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = Logging.getMessage("generic.UnableToResolveReference", string);
            Logging.logger().warning(string2);
        }
    }

    public long getExpiration(String string) {
        try {
            if (string == null) {
                return 0L;
            }
            String string2 = this.getSupportFilePath(string);
            if (string2 == null) {
                string2 = string;
            }
            return WorldWind.getDataFileStore().getExpirationTime(string2);
        }
        catch (IOException iOException) {
            String string3 = Logging.getMessage("generic.UnableToResolveReference", string);
            Logging.logger().warning(string3);
            return 0L;
        }
    }

    protected boolean canParseContentType(String string) {
        return "application/vnd.google-earth.kml+xml".equals(string) || "application/vnd.google-earth.kmz".equals(string) || "text/plain".equals(string) || "text/xml".equals(string);
    }

    protected KMLRoot parseCachedKMLFile(URL uRL, String string, String string2, boolean bl) throws IOException, XMLStreamException {
        InputStream inputStream = uRL.openStream();
        KMLDoc kMLDoc = "application/vnd.google-earth.kmz".equals(string2) ? new KMZInputStream(inputStream) : new KMLInputStream(inputStream, WWIO.makeURI(string));
        try {
            KMLRoot kMLRoot = new KMLRoot(kMLDoc, bl);
            kMLRoot = kMLRoot.parse(new Object[0]);
            return kMLRoot;
        }
        catch (XMLStreamException xMLStreamException) {
            inputStream.close();
            throw xMLStreamException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KMLRoot parse(Object ... objectArray) throws XMLStreamException {
        KMLParserContext kMLParserContext = this.parserContext;
        try {
            XMLEvent xMLEvent = kMLParserContext.nextEvent();
            while (kMLParserContext.hasNext()) {
                if (xMLEvent != null) {
                    if (xMLEvent.isStartElement() && xMLEvent.asStartElement().getName().getLocalPart().equals("kml")) {
                        super.parse(kMLParserContext, xMLEvent, objectArray);
                        KMLRoot kMLRoot = this;
                        return kMLRoot;
                    }
                    if (xMLEvent.isStartElement() && kMLParserContext.getParser(xMLEvent) != null) {
                        this.doParseEventContent(kMLParserContext, xMLEvent, objectArray);
                        KMLRoot kMLRoot = this;
                        return kMLRoot;
                    }
                }
                xMLEvent = kMLParserContext.nextEvent();
            }
        }
        finally {
            kMLParserContext.getEventReader().close();
            this.closeEventStream();
        }
        return null;
    }

    protected void closeEventStream() {
        try {
            this.eventStream.close();
            this.eventStream = null;
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionClosingXmlEventReader");
            Logging.logger().warning(string);
        }
    }

    protected XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public String getHint() {
        return (String)this.getField("hint");
    }

    public KMLNetworkLinkControl getNetworkLinkControl() {
        if (!this.linkControlFetched) {
            this.networkLinkControl = (KMLNetworkLinkControl)this.getField("NetworkLinkControl");
            this.linkControlFetched = true;
        }
        return this.networkLinkControl;
    }

    public KMLAbstractFeature getFeature() {
        if (!this.featureFetched) {
            this.feature = this.findFeature();
            this.featureFetched = true;
        }
        return this.feature;
    }

    protected KMLAbstractFeature findFeature() {
        if (!this.hasFields()) {
            return null;
        }
        for (Map.Entry<String, Object> entry : this.getFields().getEntries()) {
            if (!(entry.getValue() instanceof KMLAbstractFeature)) continue;
            return (KMLAbstractFeature)entry.getValue();
        }
        return null;
    }

    public double getDetailHint() {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
    }

    public void requestRedraw() {
        this.firePropertyChange("gov.nasa.worldwind.avkey.Repaint", null, null);
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getFeature() != null) {
            this.getFeature().preRender(kMLTraversalContext, drawContext);
        }
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.getFeature() != null) {
            this.getFeature().render(kMLTraversalContext, drawContext);
        }
    }

    @Override
    public void onMessage(Message message) {
        if (this.getFeature() != null) {
            this.getFeature().onMessage(message);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = Logging.getMessage("nullValue.PropertyChangeEventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getChangeSupport().firePropertyChange(string, object, object2);
    }

    protected synchronized PropertyChangeSupport getChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }
}

