/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLNetworkLinkControl;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class KMLLink
extends KMLAbstractObject {
    protected static final String DEFAULT_VIEW_FORMAT = "BBOX=[bboxWest],[bboxSouth],[bboxEast],[bboxNorth]";
    protected AtomicLong updateTime = new AtomicLong();
    protected String finalHref;
    protected URL hrefURL;
    protected ScheduledFuture refreshTask;

    public KMLLink(String string) {
        super(string);
    }

    public String getHref() {
        return (String)this.getField("href");
    }

    public String getRefreshMode() {
        return (String)this.getField("refreshMode");
    }

    public Double getRefreshInterval() {
        return (Double)this.getField("refreshInterval");
    }

    public String getViewRefreshMode() {
        return (String)this.getField("viewRefreshMode");
    }

    public Double getViewRefreshTime() {
        return (Double)this.getField("viewRefreshTime");
    }

    public Double getViewBoundScale() {
        return (Double)this.getField("viewBoundScale");
    }

    public String getViewFormat() {
        return (String)this.getField("viewFormat");
    }

    public String getHttpQuery() {
        return (String)this.getField("httpQuery");
    }

    @Override
    public void setField(String string, Object object) {
        super.setField(string, object);
        if ("onChange".equals(this.getRefreshMode())) {
            this.setUpdateTime(System.currentTimeMillis());
        }
    }

    public long getUpdateTime() {
        this.scheduleRefreshIfNeeded();
        return this.updateTime.get();
    }

    public void setUpdateTime(long l) {
        this.updateTime.set(l);
    }

    public void setExpirationTime(long l) {
        if ("onExpire".equals(this.getRefreshMode())) {
            if (this.refreshTask != null) {
                this.refreshTask.cancel(false);
            }
            if (l != 0L) {
                long l2 = l - System.currentTimeMillis();
                this.refreshTask = this.scheduleDelayedTask(new RefreshTask(), l2, TimeUnit.MILLISECONDS);
            }
        }
    }

    protected void scheduleRefreshIfNeeded() {
        boolean bl;
        Long l = this.computeRefreshTime();
        if (l == null) {
            return;
        }
        boolean bl2 = bl = System.currentTimeMillis() > l;
        if (bl) {
            this.updateTime.set(System.currentTimeMillis());
        }
        if (bl || this.refreshTask == null || this.refreshTask.isDone()) {
            long l2 = l - System.currentTimeMillis();
            this.refreshTask = this.scheduleDelayedTask(new RefreshTask(), l2, TimeUnit.MILLISECONDS);
        }
    }

    protected Long computeRefreshTime() {
        Long l;
        Object object;
        Long l2 = null;
        if ("onInterval".equals(this.getRefreshMode())) {
            object = this.getRefreshInterval();
            Long l3 = l2 = object != null ? Long.valueOf(this.updateTime.get() + (long)((Double)object * 1000.0)) : null;
        }
        if (l2 == null) {
            return null;
        }
        object = this.getRoot().getNetworkLinkControl();
        if (object != null && (l = Long.valueOf((long)(((KMLNetworkLinkControl)object).getMinRefreshPeriod() * 1000.0))) != null && l > l2) {
            l2 = l;
        }
        return l2;
    }

    @Override
    public void onMessage(Message message) {
        Double d;
        String string = this.getViewRefreshMode();
        if ("gov.nasa.worldwind.View.ViewStopped".equals(message.getName()) && "onStop".equals(string) && (d = this.getViewRefreshTime()) != null) {
            this.scheduleDelayedTask(new RefreshTask(), d.longValue(), TimeUnit.SECONDS);
        }
    }

    protected ScheduledFuture scheduleDelayedTask(Runnable runnable, long l, TimeUnit timeUnit) {
        return WorldWind.getScheduledTaskService().addScheduledTask(runnable, l, timeUnit);
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object = super.parse(xMLEventParserContext, xMLEvent, objectArray);
        if (WWUtil.isEmpty(this.getRefreshMode())) {
            this.setField("refreshMode", (Object)"onChange");
        }
        return object;
    }

    public String getAddress(DrawContext drawContext) {
        URL uRL;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.finalHref != null) {
            return this.finalHref;
        }
        String string = this.getHref();
        if (string != null) {
            string = string.trim();
        }
        if (WWUtil.isEmpty(string)) {
            return string;
        }
        URL uRL2 = uRL = this.hrefURL != null ? this.hrefURL : WWIO.makeURL(string);
        if (uRL == null || this.isLocalReference(uRL)) {
            this.finalHref = string;
            return string;
        }
        String string2 = this.buildQueryString(drawContext);
        if (WWUtil.isEmpty(string2)) {
            this.finalHref = string;
            return string;
        }
        this.hrefURL = uRL;
        try {
            URL uRL3 = new URL(this.hrefURL.getProtocol(), this.hrefURL.getHost(), this.hrefURL.getPort(), this.hrefURL.getPath() + string2);
            return uRL3.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    protected boolean isLocalReference(URL uRL) {
        return uRL.getProtocol() == null || "file".equals(uRL.getProtocol()) || "jar".equals(uRL.getProtocol());
    }

    protected String buildQueryString(DrawContext drawContext) {
        Object object;
        Object object2;
        String string;
        URL uRL = WWIO.makeURL(this.getHref());
        if (uRL == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(uRL.getQuery() != null ? uRL.getQuery() : "");
        String string2 = this.getViewRefreshMode();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (!WWUtil.isEmpty(string2) && !"never".equals(string2)) {
            string = this.getViewFormat();
            if (string != null) {
                string = string.trim();
            }
            if (string == null && "onStop".equals(string2)) {
                string = DEFAULT_VIEW_FORMAT;
            }
            if (!WWUtil.isEmpty(string)) {
                Position position;
                object2 = this.computeVisibleBounds(drawContext);
                string = string.replaceAll("\\[bboxWest\\]", Double.toString(((Sector)object2).getMinLongitude().degrees));
                string = string.replaceAll("\\[bboxSouth\\]", Double.toString(((Sector)object2).getMinLatitude().degrees));
                string = string.replaceAll("\\[bboxEast\\]", Double.toString(((Sector)object2).getMaxLongitude().degrees));
                string = string.replaceAll("\\[bboxNorth\\]", Double.toString(((Sector)object2).getMaxLatitude().degrees));
                object = drawContext.getView();
                Vec4 vec4 = object.getCenterPoint();
                if (vec4 != null) {
                    position = object.getGlobe().computePositionFromPoint(vec4);
                    string = string.replaceAll("\\[lookatLat\\]", Double.toString(position.getLatitude().degrees));
                    string = string.replaceAll("\\[lookatLon\\]", Double.toString(position.getLongitude().degrees));
                    string = string.replaceAll("\\[lookatAlt\\]", Double.toString(position.getAltitude()));
                    double d = vec4.distanceTo3(object.getEyePoint());
                    string = string.replaceAll("\\[lookatRange\\]", Double.toString(d));
                    string = string.replaceAll("\\[lookatHeading\\]", Double.toString(object.getHeading().degrees));
                    string = string.replaceAll("\\[lookatTilt\\]", Double.toString(object.getPitch().degrees));
                    string = string.replaceAll("\\[lookatTerrainLat\\]", Double.toString(position.getLatitude().degrees));
                    string = string.replaceAll("\\[lookatTerrainLon\\]", Double.toString(position.getLongitude().degrees));
                    string = string.replaceAll("\\[lookatTerrainAlt\\]", Double.toString(position.getAltitude()));
                }
                position = object.getCurrentEyePosition();
                string = string.replaceAll("\\[cameraLat\\]", Double.toString(position.getLatitude().degrees));
                string = string.replaceAll("\\[cameraLon\\]", Double.toString(position.getLongitude().degrees));
                string = string.replaceAll("\\[cameraAlt\\]", Double.toString(position.getAltitude()));
                string = string.replaceAll("\\[horizFOV\\]", Double.toString(object.getFieldOfView().degrees));
                Rectangle rectangle = object.getViewport();
                string = string.replaceAll("\\[horizPixels\\]", Integer.toString(rectangle.width));
                string = string.replaceAll("\\[vertPixels\\]", Integer.toString(rectangle.height));
                if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '&') {
                    stringBuilder.append('&');
                }
                stringBuilder.append(string, string.startsWith("&") ? 1 : 0, string.length());
            }
        }
        if ((string = this.getHttpQuery()) != null) {
            string = string.trim();
        }
        if (!WWUtil.isEmpty(string)) {
            object2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.Name", Version.getVersionName());
            object = Configuration.getStringValue("gov.nasa.worldwind.avkey.Version", Version.getVersionNumber());
            string = string.replaceAll("\\[clientVersion\\]", (String)object);
            string = string.replaceAll("\\[kmlVersion\\]", "2.2");
            string = string.replaceAll("\\[clientName\\]", (String)object2);
            string = string.replaceAll("\\[language\\]", Locale.getDefault().getLanguage());
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '&') {
                stringBuilder.append('&');
            }
            stringBuilder.append(string, string.startsWith("&") ? 1 : 0, string.length());
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) != '?') {
            stringBuilder.insert(0, '?');
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    protected Sector computeVisibleBounds(DrawContext drawContext) {
        if (drawContext.getVisibleSector() != null && this.getViewBoundScale() != null) {
            double d = drawContext.getVisibleSector().getCentroid().getLatitude().degrees;
            double d2 = drawContext.getVisibleSector().getCentroid().getLongitude().degrees;
            double d3 = drawContext.getVisibleSector().getDeltaLatDegrees();
            double d4 = drawContext.getVisibleSector().getDeltaLonDegrees();
            return new Sector(Angle.fromDegreesLatitude(d - this.getViewBoundScale() * (d3 / 2.0)), Angle.fromDegreesLatitude(d + this.getViewBoundScale() * (d3 / 2.0)), Angle.fromDegreesLongitude(d2 - this.getViewBoundScale() * (d4 / 2.0)), Angle.fromDegreesLongitude(d2 + this.getViewBoundScale() * (d4 / 2.0)));
        }
        if (drawContext.getVisibleSector() != null) {
            return drawContext.getVisibleSector();
        }
        return Sector.EMPTY_SECTOR;
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLLink)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        KMLLink kMLLink = (KMLLink)kMLAbstractObject;
        kMLLink.finalHref = null;
        kMLLink.hrefURL = null;
        kMLLink.refreshTask = null;
        kMLLink.updateTime.set(System.currentTimeMillis());
        super.applyChange(kMLAbstractObject);
        this.onChange(new Message("KMLAbstractObject.LinkChanged", this));
    }

    class RefreshTask
    implements Runnable {
        RefreshTask() {
        }

        @Override
        public void run() {
            KMLLink.this.setUpdateTime(System.currentTimeMillis());
            KMLLink.this.getRoot().requestRedraw();
        }
    }
}

