/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaColor;
import gov.nasa.worldwind.ogc.collada.ColladaTexture;
import java.awt.Color;

public class ColladaTextureOrColor
extends ColladaAbstractObject {
    public ColladaTextureOrColor(String string) {
        super(string);
    }

    public ColladaTexture getTexture() {
        return (ColladaTexture)this.getField("texture");
    }

    public Color getColor() {
        ColladaColor colladaColor = (ColladaColor)this.getField("color");
        if (colladaColor == null) {
            return null;
        }
        String string = colladaColor.getCharacters();
        float[] fArray = this.parseFloatArray(string);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        float f4 = fArray.length > 3 ? fArray[3] : 1.0f;
        return new Color(f, f2, f3, f4);
    }

    protected float[] parseFloatArray(String string) {
        String[] stringArray = string.trim().split("\\s+");
        float[] fArray = new float[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            fArray[n++] = Float.parseFloat(string2);
        }
        return fArray;
    }
}

