/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BasicDataRasterReaderFactory;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.GDALDataRaster;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.ImageTiler;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

public class SurfaceImageLayer
extends RenderableLayer {
    protected ImageTiler imageTiler = new ImageTiler();
    protected ConcurrentHashMap<String, ArrayList<SurfaceImage>> imageTable = new ConcurrentHashMap();
    protected BasicDataRasterReaderFactory factory = new BasicDataRasterReaderFactory();

    @Override
    public void dispose() {
        super.dispose();
        this.imageTable.clear();
    }

    public void addImage(String string) throws IOException {
        DataRaster dataRaster = this.openDataRaster(string, null);
        BufferedImage bufferedImage = this.getBufferedImage(dataRaster);
        if (null == dataRaster || bufferedImage == null) {
            String string2 = Logging.getMessage("generic.ImageReadFailed", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        this.addImage(string, bufferedImage, dataRaster.getSector());
    }

    protected BufferedImage getBufferedImage(DataRaster dataRaster) {
        if (null == dataRaster) {
            return null;
        }
        if (dataRaster instanceof GDALDataRaster) {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", dataRaster.getWidth());
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", dataRaster.getHeight());
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", dataRaster.getSector());
            dataRaster = dataRaster.getSubRaster(aVListImpl);
        }
        if (dataRaster instanceof BufferedImageRaster) {
            return ((BufferedImageRaster)dataRaster).getBufferedImage();
        }
        if (dataRaster instanceof BufferWrapperRaster) {
            return ImageUtil.visualize((BufferWrapperRaster)dataRaster);
        }
        return null;
    }

    protected DataRaster openDataRaster(Object object, AVList aVList) throws IllegalArgumentException, WWRuntimeException {
        DataRaster dataRaster;
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File file = WWIO.getFileForLocalAddress(object);
        if (null == file || !file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == aVList) {
            aVList = new AVListImpl();
        }
        try {
            Object object2;
            Object object3;
            DataRasterReader dataRasterReader = this.factory.findReaderFor(file, aVList);
            DataRaster[] dataRasterArray = dataRasterReader.read(file, aVList);
            if (null == dataRasterArray || dataRasterArray.length == 0 || null == dataRasterArray[0]) {
                String string = Logging.getMessage("generic.ImageReadFailed", object);
                Logging.logger().severe(string);
                throw new WWRuntimeException(string);
            }
            dataRaster = dataRasterArray[0];
            if (dataRaster.getSector() == null && aVList.hasKey("gov.nasa.worldwind.avKey.Sector") && null != (object3 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) && object3 instanceof Sector) {
                object2 = (Sector)object3;
                if (dataRaster instanceof GDALDataRaster) {
                    ((GDALDataRaster)dataRaster).setSector((Sector)object2);
                } else {
                    dataRaster.setValue("gov.nasa.worldwind.avKey.Sector", object2);
                }
            }
            if (dataRaster.getSector() == null) {
                object3 = Logging.getMessage("nullValue.SpatialReferenceIsNull");
                object2 = Logging.getMessage("generic.ImageReadFailed", object + ":" + (String)object3);
                Logging.logger().severe((String)object2);
                throw new WWRuntimeException((String)object2);
            }
        }
        catch (WWRuntimeException wWRuntimeException) {
            throw wWRuntimeException;
        }
        catch (Throwable throwable) {
            String string = WWUtil.extractExceptionReason(throwable);
            String string2 = Logging.getMessage("generic.ImageReadFailed", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        return dataRaster;
    }

    public void addImage(String string, Sector sector) throws IOException, WWRuntimeException {
        AVListImpl aVListImpl = new AVListImpl();
        if (null != sector) {
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        }
        DataRaster dataRaster = this.openDataRaster(string, aVListImpl);
        BufferedImage bufferedImage = this.getBufferedImage(dataRaster);
        if (null == dataRaster || bufferedImage == null) {
            String string2 = Logging.getMessage("generic.ImageReadFailed", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        Sector sector2 = dataRaster.getSector();
        sector2 = null == sector2 ? sector : sector2;
        this.addImage(string, bufferedImage, sector2);
    }

    public void addImage(String string, BufferedImage bufferedImage, Sector sector) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bufferedImage == null) {
            String string3 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (sector == null) {
            String string4 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.imageTable.contains(string)) {
            this.removeImage(string);
        }
        final ArrayList arrayList = new ArrayList();
        this.imageTable.put(string, arrayList);
        this.imageTiler.tileImage(bufferedImage, sector, new ImageTiler.ImageTilerListener(){

            @Override
            public void newTile(BufferedImage bufferedImage, Sector sector) {
                try {
                    File file = File.createTempFile("wwj-", ".png");
                    file.deleteOnExit();
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                    SurfaceImage surfaceImage = new SurfaceImage((Object)file.getPath(), sector);
                    arrayList.add(surfaceImage);
                    surfaceImage.setOpacity(SurfaceImageLayer.this.getOpacity());
                    SurfaceImageLayer.this.addRenderable(surfaceImage);
                }
                catch (IOException iOException) {
                    String string = Logging.getMessage("generic.ImageReadFailed");
                    Logging.logger().severe(string);
                }
            }

            @Override
            public void newTile(BufferedImage bufferedImage, List<? extends LatLon> list) {
            }
        });
    }

    public void addImage(String string, List<? extends LatLon> list) throws IOException, WWRuntimeException {
        Object object;
        AVListImpl aVListImpl = new AVListImpl();
        if (null != list) {
            object = Sector.boundingSector(list);
            aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", object);
        }
        object = this.openDataRaster(string, aVListImpl);
        BufferedImage bufferedImage = this.getBufferedImage((DataRaster)object);
        if (null == object || bufferedImage == null) {
            String string2 = Logging.getMessage("generic.ImageReadFailed", string);
            Logging.logger().severe(string2);
            throw new WWRuntimeException(string2);
        }
        this.addImage(string, bufferedImage, list);
    }

    public void addImage(String string, BufferedImage bufferedImage, List<? extends LatLon> list) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bufferedImage == null) {
            String string3 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (list == null) {
            String string4 = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.imageTable.contains(string)) {
            this.removeImage(string);
        }
        final ArrayList arrayList = new ArrayList();
        this.imageTable.put(string, arrayList);
        this.imageTiler.tileImage(bufferedImage, list, new ImageTiler.ImageTilerListener(){

            @Override
            public void newTile(BufferedImage bufferedImage, Sector sector) {
            }

            @Override
            public void newTile(BufferedImage bufferedImage, List<? extends LatLon> list) {
                SurfaceImage surfaceImage = new SurfaceImage((Object)bufferedImage, list);
                arrayList.add(surfaceImage);
                surfaceImage.setOpacity(SurfaceImageLayer.this.getOpacity());
                SurfaceImageLayer.this.addRenderable(surfaceImage);
            }
        });
    }

    public void removeImage(String string) {
        ArrayList<SurfaceImage> arrayList = this.imageTable.get(string);
        if (arrayList == null) {
            return;
        }
        this.imageTable.remove(string);
        for (SurfaceImage surfaceImage : arrayList) {
            if (surfaceImage == null) continue;
            this.removeRenderable(surfaceImage);
        }
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
        for (Map.Entry<String, ArrayList<SurfaceImage>> entry : this.imageTable.entrySet()) {
            for (SurfaceImage surfaceImage : entry.getValue()) {
                if (surfaceImage == null) continue;
                surfaceImage.setOpacity(d);
            }
        }
    }

    public int getNumImages() {
        int n = 0;
        for (ArrayList<SurfaceImage> arrayList : this.imageTable.values()) {
            n += arrayList.size();
        }
        return n;
    }

    public BufferedImage composeImageForSector(Sector sector, int n, int n2, double d, BufferedImage bufferedImage) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.getRenderables().iterator().hasNext()) {
            Logging.logger().severe(Logging.getMessage("generic.NoImagesAvailable"));
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        for (Renderable renderable : this.getRenderables()) {
            SurfaceImage surfaceImage = (SurfaceImage)renderable;
            if (surfaceImage.getImageSource() == null) continue;
            BufferedImage bufferedImage2 = null;
            try {
                bufferedImage2 = surfaceImage.getImageSource() instanceof String ? ImageIO.read(new File((String)surfaceImage.getImageSource())) : (BufferedImage)surfaceImage.getImageSource();
            }
            catch (IOException iOException) {
                Logging.logger().severe(Logging.getMessage("generic.ExceptionAttemptingToReadImageFile", bufferedImage2));
                return null;
            }
            ImageUtil.mergeImage(sector, surfaceImage.getSector(), d, bufferedImage2, bufferedImage);
        }
        return bufferedImage;
    }
}

