/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.render.markers.MarkerRenderer;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public class MarkerLayer
extends AbstractLayer {
    private MarkerRenderer markerRenderer = new MarkerRenderer();
    private Iterable<Marker> markers;

    public MarkerLayer() {
    }

    public MarkerLayer(Iterable<Marker> iterable) {
        this.markers = iterable;
    }

    public Iterable<Marker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(Iterable<Marker> iterable) {
        this.markers = iterable;
    }

    public double getElevation() {
        return this.getMarkerRenderer().getElevation();
    }

    public void setElevation(double d) {
        this.getMarkerRenderer().setElevation(d);
    }

    public boolean isOverrideMarkerElevation() {
        return this.getMarkerRenderer().isOverrideMarkerElevation();
    }

    public void setOverrideMarkerElevation(boolean bl) {
        this.getMarkerRenderer().setOverrideMarkerElevation(bl);
    }

    public boolean isKeepSeparated() {
        return this.getMarkerRenderer().isKeepSeparated();
    }

    public void setKeepSeparated(boolean bl) {
        this.getMarkerRenderer().setKeepSeparated(bl);
    }

    public boolean isEnablePickSizeReturn() {
        return this.getMarkerRenderer().isEnablePickSizeReturn();
    }

    public void setEnablePickSizeReturn(boolean bl) {
        this.getMarkerRenderer().setEnablePickSizeReturn(bl);
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
    }

    @Override
    public double getOpacity() {
        return super.getOpacity();
    }

    protected MarkerRenderer getMarkerRenderer() {
        return this.markerRenderer;
    }

    protected void setMarkerRenderer(MarkerRenderer markerRenderer) {
        this.markerRenderer = markerRenderer;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.draw(drawContext, null);
    }

    @Override
    protected void doPick(DrawContext drawContext, Point point) {
        this.draw(drawContext, point);
    }

    protected void draw(DrawContext drawContext, Point point) {
        if (this.markers == null) {
            return;
        }
        if (drawContext.getVisibleSector() == null) {
            return;
        }
        SectorGeometryList sectorGeometryList = drawContext.getSurfaceGeometry();
        if (sectorGeometryList == null) {
            return;
        }
        this.getMarkerRenderer().render(drawContext, this.markers);
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.MarkerLayer.Name");
    }
}

