/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

class TMCoordConverter {
    public static final int TRANMERC_NO_ERROR = 0;
    private static final int TRANMERC_LAT_ERROR = 1;
    private static final int TRANMERC_LON_ERROR = 2;
    public static final int TRANMERC_EASTING_ERROR = 4;
    public static final int TRANMERC_NORTHING_ERROR = 8;
    private static final int TRANMERC_ORIGIN_LAT_ERROR = 16;
    private static final int TRANMERC_CENT_MER_ERROR = 32;
    private static final int TRANMERC_A_ERROR = 64;
    private static final int TRANMERC_INV_F_ERROR = 128;
    private static final int TRANMERC_SCALE_FACTOR_ERROR = 256;
    public static final int TRANMERC_LON_WARNING = 512;
    private static final double PI = Math.PI;
    public static final double PI_OVER = 1.5707963267948966;
    private static final double MAX_LAT = 1.570621793869697;
    private static final double MAX_DELTA_LONG = 1.5707963267948966;
    private static final double MIN_SCALE_FACTOR = 0.3;
    private static final double MAX_SCALE_FACTOR = 3.0;
    private double TranMerc_a = 6378137.0;
    private double TranMerc_f = 0.0033528106647474805;
    private double TranMerc_es = 0.00669437999014138;
    private double TranMerc_ebs = 0.0067394967565869;
    private double TranMerc_Origin_Lat = 0.0;
    private double TranMerc_Origin_Long = 0.0;
    private double TranMerc_False_Northing = 0.0;
    private double TranMerc_False_Easting = 0.0;
    private double TranMerc_Scale_Factor = 1.0;
    private double TranMerc_ap = 6367449.1458008;
    private double TranMerc_bp = 16038.508696861;
    private double TranMerc_cp = 16.832613334334;
    private double TranMerc_dp = 0.021984404273757;
    private double TranMerc_ep = 3.1148371319283E-5;
    private double TranMerc_Delta_Easting = 4.0E7;
    private double TranMerc_Delta_Northing = 4.0E7;
    private double Easting;
    private double Northing;
    private double Longitude;
    private double Latitude;

    TMCoordConverter() {
    }

    public double getA() {
        return this.TranMerc_a;
    }

    public double getF() {
        return this.TranMerc_f;
    }

    public long setTransverseMercatorParameters(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = 1.0 / d2;
        long l = 0L;
        if (d <= 0.0) {
            l |= 0x40L;
        }
        if (d8 < 250.0 || d8 > 350.0) {
            l |= 0x80L;
        }
        if (d3 < -1.570621793869697 || d3 > 1.570621793869697) {
            l |= 0x10L;
        }
        if (d4 < -Math.PI || d4 > Math.PI * 2) {
            l |= 0x20L;
        }
        if (d7 < 0.3 || d7 > 3.0) {
            l |= 0x100L;
        }
        if (l == 0L) {
            this.TranMerc_a = d;
            this.TranMerc_f = d2;
            this.TranMerc_Origin_Lat = 0.0;
            this.TranMerc_Origin_Long = 0.0;
            this.TranMerc_False_Northing = 0.0;
            this.TranMerc_False_Easting = 0.0;
            this.TranMerc_Scale_Factor = 1.0;
            this.TranMerc_es = 2.0 * this.TranMerc_f - this.TranMerc_f * this.TranMerc_f;
            this.TranMerc_ebs = 1.0 / (1.0 - this.TranMerc_es) - 1.0;
            double d9 = this.TranMerc_a * (1.0 - this.TranMerc_f);
            double d10 = (this.TranMerc_a - d9) / (this.TranMerc_a + d9);
            double d11 = d10 * d10;
            double d12 = d11 * d10;
            double d13 = d12 * d10;
            double d14 = d13 * d10;
            this.TranMerc_ap = this.TranMerc_a * (1.0 - d10 + 5.0 * (d11 - d12) / 4.0 + 81.0 * (d13 - d14) / 64.0);
            this.TranMerc_bp = 3.0 * this.TranMerc_a * (d10 - d11 + 7.0 * (d12 - d13) / 8.0 + 55.0 * d14 / 64.0) / 2.0;
            this.TranMerc_cp = 15.0 * this.TranMerc_a * (d11 - d12 + 3.0 * (d13 - d14) / 4.0) / 16.0;
            this.TranMerc_dp = 35.0 * this.TranMerc_a * (d12 - d13 + 11.0 * d14 / 16.0) / 48.0;
            this.TranMerc_ep = 315.0 * this.TranMerc_a * (d13 - d14) / 512.0;
            this.convertGeodeticToTransverseMercator(1.570621793869697, 1.5707963267948966);
            this.TranMerc_Delta_Easting = this.getEasting();
            this.TranMerc_Delta_Northing = this.getNorthing();
            this.convertGeodeticToTransverseMercator(0.0, 1.5707963267948966);
            this.TranMerc_Delta_Easting = this.getEasting();
            this.TranMerc_Origin_Lat = d3;
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            this.TranMerc_Origin_Long = d4;
            this.TranMerc_False_Northing = d6;
            this.TranMerc_False_Easting = d5;
            this.TranMerc_Scale_Factor = d7;
        }
        return l;
    }

    public long convertGeodeticToTransverseMercator(double d, double d2) {
        double d3;
        double d4;
        long l = 0L;
        if (d < -1.570621793869697 || d > 1.570621793869697) {
            l |= 1L;
        }
        if (d2 > Math.PI) {
            d2 -= Math.PI * 2;
        }
        if ((d2 < this.TranMerc_Origin_Long - 1.5707963267948966 || d2 > this.TranMerc_Origin_Long + 1.5707963267948966) && ((d4 = d2 < 0.0 ? d2 + Math.PI * 2 : d2) < (d3 = this.TranMerc_Origin_Long < 0.0 ? this.TranMerc_Origin_Long + Math.PI * 2 : this.TranMerc_Origin_Long) - 1.5707963267948966 || d4 > d3 + 1.5707963267948966)) {
            l |= 2L;
        }
        if (l == 0L) {
            double d5 = d2 - this.TranMerc_Origin_Long;
            if (Math.abs(d5) > 0.15707963267948966) {
                l |= 0x200L;
            }
            if (d5 > Math.PI) {
                d5 -= Math.PI * 2;
            }
            if (d5 < -Math.PI) {
                d5 += Math.PI * 2;
            }
            if (Math.abs(d5) < 2.0E-10) {
                d5 = 0.0;
            }
            double d6 = Math.sin(d);
            double d7 = Math.cos(d);
            double d8 = d7 * d7;
            double d9 = d8 * d7;
            double d10 = d9 * d8;
            double d11 = d10 * d8;
            double d12 = Math.tan(d);
            double d13 = d12 * d12;
            double d14 = d13 * d12;
            double d15 = d14 * d12;
            double d16 = d15 * d12;
            double d17 = d16 * d12;
            double d18 = this.TranMerc_ebs * d8;
            double d19 = d18 * d18;
            double d20 = d19 * d18;
            double d21 = d20 * d18;
            double d22 = this.TranMerc_a / Math.sqrt(1.0 - this.TranMerc_es * Math.pow(Math.sin(d), 2.0));
            double d23 = this.TranMerc_ap * d - this.TranMerc_bp * Math.sin(2.0 * d) + this.TranMerc_cp * Math.sin(4.0 * d) - this.TranMerc_dp * Math.sin(6.0 * d) + this.TranMerc_ep * Math.sin(8.0 * d);
            double d24 = this.TranMerc_ap * this.TranMerc_Origin_Lat - this.TranMerc_bp * Math.sin(2.0 * this.TranMerc_Origin_Lat) + this.TranMerc_cp * Math.sin(4.0 * this.TranMerc_Origin_Lat) - this.TranMerc_dp * Math.sin(6.0 * this.TranMerc_Origin_Lat) + this.TranMerc_ep * Math.sin(8.0 * this.TranMerc_Origin_Lat);
            double d25 = (d23 - d24) * this.TranMerc_Scale_Factor;
            double d26 = d22 * d6 * d7 * this.TranMerc_Scale_Factor / 2.0;
            double d27 = d22 * d6 * d9 * this.TranMerc_Scale_Factor * (5.0 - d13 + 9.0 * d18 + 4.0 * d19) / 24.0;
            double d28 = d22 * d6 * d10 * this.TranMerc_Scale_Factor * (61.0 - 58.0 * d13 + d15 + 270.0 * d18 - 330.0 * d13 * d18 + 445.0 * d19 + 324.0 * d20 - 680.0 * d13 * d19 + 88.0 * d21 - 600.0 * d13 * d20 - 192.0 * d13 * d21) / 720.0;
            double d29 = d22 * d6 * d11 * this.TranMerc_Scale_Factor * (1385.0 - 3111.0 * d13 + 543.0 * d15 - d17) / 40320.0;
            this.Northing = this.TranMerc_False_Northing + d25 + Math.pow(d5, 2.0) * d26 + Math.pow(d5, 4.0) * d27 + Math.pow(d5, 6.0) * d28 + Math.pow(d5, 8.0) * d29;
            double d30 = d22 * d7 * this.TranMerc_Scale_Factor;
            double d31 = d22 * d9 * this.TranMerc_Scale_Factor * (1.0 - d13 + d18) / 6.0;
            double d32 = d22 * d10 * this.TranMerc_Scale_Factor * (5.0 - 18.0 * d13 + d15 + 14.0 * d18 - 58.0 * d13 * d18 + 13.0 * d19 + 4.0 * d20 - 64.0 * d13 * d19 - 24.0 * d13 * d20) / 120.0;
            double d33 = d22 * d11 * this.TranMerc_Scale_Factor * (61.0 - 479.0 * d13 + 179.0 * d15 - d17) / 5040.0;
            this.Easting = this.TranMerc_False_Easting + d5 * d30 + Math.pow(d5, 3.0) * d31 + Math.pow(d5, 5.0) * d32 + Math.pow(d5, 7.0) * d33;
        }
        return l;
    }

    public double getEasting() {
        return this.Easting;
    }

    public double getNorthing() {
        return this.Northing;
    }

    public long convertTransverseMercatorToGeodetic(double d, double d2) {
        long l = 0L;
        if (d < this.TranMerc_False_Easting - this.TranMerc_Delta_Easting || d > this.TranMerc_False_Easting + this.TranMerc_Delta_Easting) {
            l |= 4L;
        }
        if (d2 < this.TranMerc_False_Northing - this.TranMerc_Delta_Northing || d2 > this.TranMerc_False_Northing + this.TranMerc_Delta_Northing) {
            l |= 8L;
        }
        if (l == 0L) {
            double d3;
            double d4 = this.TranMerc_ap * this.TranMerc_Origin_Lat - this.TranMerc_bp * Math.sin(2.0 * this.TranMerc_Origin_Lat) + this.TranMerc_cp * Math.sin(4.0 * this.TranMerc_Origin_Lat) - this.TranMerc_dp * Math.sin(6.0 * this.TranMerc_Origin_Lat) + this.TranMerc_ep * Math.sin(8.0 * this.TranMerc_Origin_Lat);
            double d5 = d4 + (d2 - this.TranMerc_False_Northing) / this.TranMerc_Scale_Factor;
            double d6 = this.TranMerc_a * (1.0 - this.TranMerc_es) / Math.pow(Math.sqrt(1.0 - this.TranMerc_es * Math.pow(Math.sin(0.0), 2.0)), 3.0);
            double d7 = d5 / d6;
            for (int i = 0; i < 5; ++i) {
                d3 = this.TranMerc_ap * d7 - this.TranMerc_bp * Math.sin(2.0 * d7) + this.TranMerc_cp * Math.sin(4.0 * d7) - this.TranMerc_dp * Math.sin(6.0 * d7) + this.TranMerc_ep * Math.sin(8.0 * d7);
                d6 = this.TranMerc_a * (1.0 - this.TranMerc_es) / Math.pow(Math.sqrt(1.0 - this.TranMerc_es * Math.pow(Math.sin(d7), 2.0)), 3.0);
                d7 += (d5 - d3) / d6;
            }
            d6 = this.TranMerc_a * (1.0 - this.TranMerc_es) / Math.pow(Math.sqrt(1.0 - this.TranMerc_es * Math.pow(Math.sin(d7), 2.0)), 3.0);
            double d8 = this.TranMerc_a / Math.sqrt(1.0 - this.TranMerc_es * Math.pow(Math.sin(d7), 2.0));
            double d9 = Math.sin(d7);
            double d10 = Math.cos(d7);
            double d11 = Math.tan(d7);
            double d12 = d11 * d11;
            double d13 = d12 * d12;
            double d14 = this.TranMerc_ebs * Math.pow(d10, 2.0);
            double d15 = d14 * d14;
            double d16 = d15 * d14;
            double d17 = d16 * d14;
            double d18 = d - this.TranMerc_False_Easting;
            if (Math.abs(d18) < 1.0E-4) {
                d18 = 0.0;
            }
            d3 = d11 / (2.0 * d6 * d8 * Math.pow(this.TranMerc_Scale_Factor, 2.0));
            double d19 = d11 * (5.0 + 3.0 * d12 + d14 - 4.0 * Math.pow(d14, 2.0) - 9.0 * d12 * d14) / (24.0 * d6 * Math.pow(d8, 3.0) * Math.pow(this.TranMerc_Scale_Factor, 4.0));
            double d20 = d11 * (61.0 + 90.0 * d12 + 46.0 * d14 + 45.0 * d13 - 252.0 * d12 * d14 - 3.0 * d15 + 100.0 * d16 - 66.0 * d12 * d15 - 90.0 * d13 * d14 + 88.0 * d17 + 225.0 * d13 * d15 + 84.0 * d12 * d16 - 192.0 * d12 * d17) / (720.0 * d6 * Math.pow(d8, 5.0) * Math.pow(this.TranMerc_Scale_Factor, 6.0));
            double d21 = d11 * (1385.0 + 3633.0 * d12 + 4095.0 * d13 + 1575.0 * Math.pow(d11, 6.0)) / (40320.0 * d6 * Math.pow(d8, 7.0) * Math.pow(this.TranMerc_Scale_Factor, 8.0));
            this.Latitude = d7 - Math.pow(d18, 2.0) * d3 + Math.pow(d18, 4.0) * d19 - Math.pow(d18, 6.0) * d20 + Math.pow(d18, 8.0) * d21;
            double d22 = 1.0 / (d8 * d10 * this.TranMerc_Scale_Factor);
            double d23 = (1.0 + 2.0 * d12 + d14) / (6.0 * Math.pow(d8, 3.0) * d10 * Math.pow(this.TranMerc_Scale_Factor, 3.0));
            double d24 = (5.0 + 6.0 * d14 + 28.0 * d12 - 3.0 * d15 + 8.0 * d12 * d14 + 24.0 * d13 - 4.0 * d16 + 4.0 * d12 * d15 + 24.0 * d12 * d16) / (120.0 * Math.pow(d8, 5.0) * d10 * Math.pow(this.TranMerc_Scale_Factor, 5.0));
            double d25 = (61.0 + 662.0 * d12 + 1320.0 * d13 + 720.0 * Math.pow(d11, 6.0)) / (5040.0 * Math.pow(d8, 7.0) * d10 * Math.pow(this.TranMerc_Scale_Factor, 7.0));
            double d26 = d18 * d22 - Math.pow(d18, 3.0) * d23 + Math.pow(d18, 5.0) * d24 - Math.pow(d18, 7.0) * d25;
            this.Longitude = this.TranMerc_Origin_Long + d26;
            if (Math.abs(this.Latitude) > 1.5707963267948966) {
                l |= 8L;
            }
            if (this.Longitude > Math.PI) {
                this.Longitude -= Math.PI * 2;
                if (Math.abs(this.Longitude) > Math.PI) {
                    l |= 4L;
                }
            }
            if (Math.abs(d26) > 0.15707963267948966 * Math.cos(this.Latitude)) {
                l |= 0x200L;
            }
            if (this.Latitude > 1.0E10) {
                l |= 0x200L;
            }
        }
        return l;
    }

    public double getLatitude() {
        return this.Latitude;
    }

    public double getLongitude() {
        return this.Longitude;
    }
}

