/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class DatumTransformation {
    private static final double Clarke1866_EQUATORIAL_RADIUS = 6378206.4;
    private static final double Clarke1866_POLAR_RADIUS = 6356583.8;
    private static final double Clarke1866_ES = 0.00676865799729;
    public static Globe CLARKE1866_GLOBE = new EllipsoidalGlobe(6378206.4, 6356583.8, 0.00676865799729, EllipsoidalGlobe.makeElevationModel("gov.nasa.worldwind.avkey.EarthElevationModelConfigFile", "config/Earth/EarthMergedElevationModel.xml"));

    public static Position convertNad27toWGS84(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = -8.0;
        double d2 = 160.0;
        double d3 = 176.0;
        return DatumTransformation.threeParamMolodenski(position, CLARKE1866_GLOBE, new Earth(), d, d2, d3);
    }

    public static Position convertWGS84toNad27(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 8.0;
        double d2 = -160.0;
        double d3 = -176.0;
        return DatumTransformation.threeParamMolodenski(position, new Earth(), CLARKE1866_GLOBE, d, d2, d3);
    }

    private static Position threeParamMolodenski(Position position, Globe globe, Globe globe2, double d, double d2, double d3) {
        double d4 = Math.sin(position.getLatitude().getRadians());
        double d5 = Math.cos(position.getLatitude().getRadians());
        double d6 = Math.sin(position.getLongitude().getRadians());
        double d7 = Math.cos(position.getLongitude().getRadians());
        double d8 = d4 * d4;
        double d9 = (globe.getEquatorialRadius() - globe.getPolarRadius()) / globe.getEquatorialRadius();
        double d10 = (globe2.getEquatorialRadius() - globe2.getPolarRadius()) / globe2.getEquatorialRadius();
        double d11 = d10 - d9;
        double d12 = 1.0 / (1.0 - d9);
        double d13 = globe2.getEquatorialRadius() - globe.getEquatorialRadius();
        double d14 = globe.getEquatorialRadius() / Math.sqrt(1.0 - globe.getEccentricitySquared() * d8);
        double d15 = globe.getEquatorialRadius() * (1.0 - globe.getEccentricitySquared()) / Math.pow(1.0 - globe.getEccentricitySquared() * d8, 1.5);
        double d16 = (-d * d4 * d7 - d2 * d4 * d6 + d3 * d5 + d13 * (d14 * globe.getEccentricitySquared() * d4 * d5 / globe.getEquatorialRadius()) + d11 * (d15 * d12 + d14 / d12) * d4 * d5) / (d15 + position.getElevation());
        double d17 = (-d * d6 + d2 * d7) / ((d14 + position.getElevation()) * d5);
        double d18 = d * d5 * d7 + d2 * d5 * d6 + d3 * d4 - d13 * (globe.getEquatorialRadius() / d14) + d11 * d14 * d8 / d12;
        return Position.fromRadians(position.getLatitude().getRadians() + d16, position.getLongitude().getRadians() + d17, position.getElevation() + d18);
    }
}

