/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TIFFReader;
import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.util.Logging;

class BaselineTiff {
    public int width = 0;
    public int height = 0;
    public int samplesPerPixel = 0;
    public int photometric = -1;
    public int rowsPerStrip = 0;
    public int planarConfig = 0;
    public int minSampleValue;
    public int maxSampleValue;
    public int[] sampleFormat = null;
    public int[] bitsPerSample = null;
    public String displayName = null;
    public String imageDescription = null;
    public String softwareVersion = null;
    public String dateTime = null;

    private BaselineTiff() {
    }

    public static BaselineTiff extract(TiffIFDEntry[] tiffIFDEntryArray, TIFFReader tIFFReader) {
        if (null == tiffIFDEntryArray || null == tIFFReader) {
            return null;
        }
        BaselineTiff baselineTiff = new BaselineTiff();
        for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
            try {
                switch (tiffIFDEntry.tag) {
                    case 256: {
                        baselineTiff.width = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 257: {
                        baselineTiff.height = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 269: {
                        baselineTiff.displayName = tIFFReader.readString(tiffIFDEntry);
                        break;
                    }
                    case 270: {
                        baselineTiff.imageDescription = tIFFReader.readString(tiffIFDEntry);
                        break;
                    }
                    case 305: {
                        baselineTiff.softwareVersion = tIFFReader.readString(tiffIFDEntry);
                        break;
                    }
                    case 306: {
                        baselineTiff.dateTime = tIFFReader.readString(tiffIFDEntry);
                        break;
                    }
                    case 277: {
                        baselineTiff.samplesPerPixel = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 262: {
                        baselineTiff.photometric = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 278: {
                        baselineTiff.rowsPerStrip = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 284: {
                        baselineTiff.planarConfig = (int)tiffIFDEntry.asLong();
                        break;
                    }
                    case 339: {
                        baselineTiff.sampleFormat = tiffIFDEntry.getShortsAsInts();
                        break;
                    }
                    case 258: {
                        baselineTiff.bitsPerSample = tiffIFDEntry.getShortsAsInts();
                        break;
                    }
                    case 280: {
                        baselineTiff.minSampleValue = tiffIFDEntry.asShort();
                        break;
                    }
                    case 281: {
                        baselineTiff.maxSampleValue = tiffIFDEntry.asShort();
                    }
                }
            }
            catch (Exception exception) {
                Logging.logger().finest(exception.toString());
            }
        }
        return baselineTiff;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("{ ");
        stringBuffer.append("width=").append(this.width).append(", ");
        stringBuffer.append("height=").append(this.height).append(", ");
        stringBuffer.append("samplesPerPixel=").append(this.samplesPerPixel).append(", ");
        stringBuffer.append("photometric=").append(this.photometric).append(", ");
        stringBuffer.append("rowsPerStrip=").append(this.rowsPerStrip).append(", ");
        stringBuffer.append("planarConfig=").append(this.planarConfig).append(", ");
        stringBuffer.append("sampleFormat=( ");
        if (null != this.sampleFormat) {
            for (n = 0; n < this.sampleFormat.length; ++n) {
                stringBuffer.append(this.sampleFormat[n]).append(" ");
            }
        } else {
            stringBuffer.append(" NULL ");
        }
        stringBuffer.append("), ");
        stringBuffer.append("bitsPerSample=( ");
        if (null != this.bitsPerSample) {
            for (n = 0; n < this.bitsPerSample.length; ++n) {
                stringBuffer.append(this.bitsPerSample[n]).append(" ");
            }
        } else {
            stringBuffer.append(" NULL ");
        }
        stringBuffer.append("), ");
        stringBuffer.append("displayName=").append(this.displayName).append(", ");
        stringBuffer.append("imageDescription=").append(this.imageDescription).append(", ");
        stringBuffer.append("softwareVersion=").append(this.softwareVersion).append(", ");
        stringBuffer.append("dateTime=").append(this.dateTime);
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }
}

