/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.geojson;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometry;
import gov.nasa.worldwind.formats.geojson.GeoJSONPositionArray;
import java.util.Arrays;

public class GeoJSONPolygon
extends GeoJSONGeometry {
    public GeoJSONPolygon(AVList aVList) {
        super(aVList);
    }

    @Override
    public boolean isPolygon() {
        return true;
    }

    public int getInteriorRingCount() {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? geoJSONPositionArrayArray.length - 1 : 0;
    }

    public GeoJSONPositionArray[] getCoordinates() {
        return (GeoJSONPositionArray[])this.getValue("coordinates");
    }

    public GeoJSONPositionArray getExteriorRing() {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 0 ? geoJSONPositionArrayArray[0] : null;
    }

    public GeoJSONPositionArray getInteriorRing(int n) {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? geoJSONPositionArrayArray[1 + n] : null;
    }

    public GeoJSONPositionArray[] getInteriorRings() {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? Arrays.copyOfRange(geoJSONPositionArrayArray, 1, geoJSONPositionArrayArray.length) : null;
    }
}

