/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.MipMappedBufferedImageRaster;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageIORasterReader
extends AbstractDataRasterReader {
    private boolean generateMipMaps;

    public ImageIORasterReader(boolean bl) {
        super(ImageIO.getReaderMIMETypes(), ImageIORasterReader.getImageIOReaderSuffixes());
        this.generateMipMaps = bl;
    }

    public ImageIORasterReader() {
        this(false);
    }

    public boolean isGenerateMipMaps() {
        return this.generateMipMaps;
    }

    public void setGenerateMipMaps(boolean bl) {
        this.generateMipMaps = bl;
    }

    @Override
    protected boolean doCanRead(Object object, AVList aVList) {
        Object object2;
        Object object3 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avKey.Sector") : null;
        if (!(object2 != null && object2 instanceof Sector || this.canReadWorldFiles(object))) {
            return false;
        }
        if (null != aVList && !aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        }
        return true;
    }

    @Override
    protected DataRaster[] doRead(Object object, AVList aVList) throws IOException {
        Object object2;
        ImageInputStream imageInputStream = ImageIORasterReader.createInputStream(object);
        BufferedImage bufferedImage = ImageIO.read(imageInputStream);
        bufferedImage = ImageUtil.toCompatibleImage(bufferedImage);
        Object object3 = object2 = aVList != null ? aVList.getValue("gov.nasa.worldwind.avKey.Sector") : null;
        if (object2 == null || !(object2 instanceof Sector)) {
            AVListImpl aVListImpl = new AVListImpl();
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
            this.readWorldFiles(object, aVListImpl);
            object2 = aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        return new DataRaster[]{this.createRaster((Sector)object2, bufferedImage)};
    }

    @Override
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        Object object2;
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        Object object4 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (object3 == null || object4 == null || !(object3 instanceof Integer) || !(object4 instanceof Integer)) {
            this.readImageDimension(object, aVList);
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object2 instanceof Sector)) {
            this.readWorldFiles(object, aVList);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat")) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Image");
        }
    }

    protected DataRaster createRaster(Sector sector, BufferedImage bufferedImage) {
        if (this.isGenerateMipMaps()) {
            return new MipMappedBufferedImageRaster(sector, bufferedImage);
        }
        return new BufferedImageRaster(sector, bufferedImage);
    }

    private boolean canReadWorldFiles(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        try {
            File[] fileArray = WorldFile.getWorldFiles((File)object);
            if (fileArray == null || fileArray.length == 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readImageDimension(Object object, AVList aVList) throws IOException {
        ImageInputStream imageInputStream = ImageIORasterReader.createInputStream(object);
        ImageReader imageReader = ImageIORasterReader.readerFor(imageInputStream);
        try {
            if (imageReader == null) {
                String string = Logging.getMessage("generic.UnrecognizedImageSourceType", object);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            imageReader.setInput(imageInputStream, true, true);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
            aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            imageInputStream.close();
        }
    }

    private void readWorldFiles(Object object, AVList aVList) throws IOException {
        Object object2;
        if (!(object instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Image");
        if (!(object3 != null && object3 instanceof BufferedImage || (object3 = aVList.getValue("gov.nasa.worldwind.worldFile.ImageSize")) != null && object3 instanceof int[])) {
            object2 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
            Object object4 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (object2 != null && object4 != null && object2 instanceof Integer && object4 instanceof Integer) {
                int[] nArray = new int[]{(Integer)object2, (Integer)object4};
                aVList.setValue("gov.nasa.worldwind.worldFile.ImageSize", nArray);
            }
        }
        object2 = WorldFile.getWorldFiles((File)object);
        WorldFile.decodeWorldFiles(object2, aVList);
    }

    private static ImageInputStream createInputStream(Object object) throws IOException {
        Object object2 = object;
        if (object instanceof URL) {
            object2 = ((URL)object).openStream();
        } else if (object instanceof CharSequence) {
            object2 = ImageIORasterReader.openInputStream(object.toString());
        }
        return ImageIO.createImageInputStream(object2);
    }

    private static InputStream openInputStream(String string) throws IOException {
        Object object = WWIO.getFileOrResourceAsStream(string, null);
        if (object == null) {
            return null;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof Exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadImageFile", string);
            Logging.logger().log(Level.SEVERE, string2, object);
            throw new IOException(string2);
        }
        return (InputStream)object;
    }

    private static ImageReader readerFor(ImageInputStream imageInputStream) {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    private static String[] getImageIOReaderSuffixes() {
        String[] stringArray;
        Iterator<ImageReaderSpi> iterator;
        try {
            iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        }
        catch (Exception exception) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String[] stringArray2 = stringArray.getFileSuffixes();
            hashSet.addAll(Arrays.asList(stringArray2));
        }
        stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(GeotiffImageReaderSpi.inst());
    }
}

