/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.KeyEventState;
import gov.nasa.worldwind.awt.ViewInputAttributes;
import gov.nasa.worldwind.awt.ViewInputHandler;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class AbstractViewInputHandler
implements ViewInputHandler,
PropertyChangeListener {
    protected WorldWindow wwd;
    protected ViewInputAttributes attributes;
    protected ViewInputAttributes.ActionAttributesMap mouseActionMap;
    protected ViewInputAttributes.ActionAttributesMap keyActionMap;
    protected ViewInputAttributes.DeviceModifierMap keyModsActionMap;
    protected ViewInputAttributes.DeviceModifierMap mouseModsActionMap;
    protected ViewInputAttributes.DeviceModifierMap mouseWheelModsActionMap;
    protected boolean enableSmoothing = true;
    protected boolean lockHeading = true;
    protected boolean stopOnFocusLost = true;
    protected boolean wwdFocusOwner;
    protected Point mouseDownPoint;
    protected Point lastMousePoint;
    protected Point mousePoint;
    protected Position selectedPosition;
    protected KeyEventState keyEventState = new KeyEventState();
    protected double dragSlopeFactor = 0.002;
    protected long lastPerFrameInputTime;
    protected static final double DEFAULT_DRAG_SLOPE_FACTOR = 0.002;
    protected static final long DEFAULT_PER_FRAME_INPUT_DELAY = 35L;
    protected static final String GENERATE_EVENTS = "GenerateEvents";
    protected static final String QUERY_EVENTS = "QueryEvents";
    protected static final String SCALE_FUNC_EYE_ALTITUDE = "ScaleFuncEyeAltitude";
    protected static final String SCALE_FUNC_EYE_ALTITUDE_EXP = "ScaleFuncEyeAltitudeExp";
    protected static final String SCALE_FUNC_ZOOM = "ScaleFuncZoom";
    protected static final String SCALE_FUNC_ZOOM_EXP = "ScaleFuncZoomExp";
    protected int[] modifierList = new int[]{576, 640, 768, 64, 128, 256, 512, 0};
    protected final int NUM_MODIFIERS = 8;

    protected abstract void onMoveTo(Position var1, ViewInputAttributes.ActionAttributes var2);

    protected abstract void onMoveTo(Position var1, ViewInputAttributes.DeviceAttributes var2, ViewInputAttributes.ActionAttributes var3);

    protected abstract void onHorizontalTranslateAbs(Angle var1, Angle var2, ViewInputAttributes.ActionAttributes var3);

    protected abstract void onResetHeading(ViewInputAttributes.ActionAttributes var1);

    protected abstract void onResetHeadingPitchRoll(ViewInputAttributes.ActionAttributes var1);

    protected abstract void onRotateView(Angle var1, Angle var2, ViewInputAttributes.ActionAttributes var3);

    protected abstract void onRotateView(double var1, double var3, double var5, double var7, ViewInputAttributes.DeviceAttributes var9, ViewInputAttributes.ActionAttributes var10);

    protected abstract void onVerticalTranslate(double var1, ViewInputAttributes.ActionAttributes var3);

    protected abstract void onVerticalTranslate(double var1, double var3, ViewInputAttributes.DeviceAttributes var5, ViewInputAttributes.ActionAttributes var6);

    protected abstract void onHorizontalTranslateRel(double var1, double var3, double var5, double var7, ViewInputAttributes.DeviceAttributes var9, ViewInputAttributes.ActionAttributes var10);

    protected abstract void onHorizontalTranslateRel(Angle var1, Angle var2, ViewInputAttributes.ActionAttributes var3);

    public AbstractViewInputHandler() {
        this.attributes = new ViewInputAttributes();
        this.mouseActionMap = this.attributes.getActionMap("gov.nasa.worldwind.DeviceMouse");
        this.keyActionMap = this.attributes.getActionMap("gov.nasa.worldwind.DeviceKeyboard");
        this.keyModsActionMap = this.attributes.getModifierActionMap("gov.nasa.worldwind.DeviceKeyboard");
        this.mouseModsActionMap = this.attributes.getModifierActionMap("gov.nasa.worldwind.DeviceMouse");
        this.mouseWheelModsActionMap = this.attributes.getModifierActionMap("gov.nasa.worldwind.DeviceMouseWheel");
    }

    @Override
    public WorldWindow getWorldWindow() {
        return this.wwd;
    }

    @Override
    public void setWorldWindow(WorldWindow worldWindow) {
        if (worldWindow == this.wwd) {
            return;
        }
        if (this.wwd != null) {
            this.wwd.getSceneController().removePropertyChangeListener(this);
        }
        this.wwd = worldWindow;
        if (this.wwd != null) {
            this.wwd.getSceneController().addPropertyChangeListener(this);
        }
    }

    @Override
    public ViewInputAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(ViewInputAttributes viewInputAttributes) {
        if (viewInputAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.attributes = viewInputAttributes;
    }

    @Override
    public boolean isEnableSmoothing() {
        return this.enableSmoothing;
    }

    @Override
    public void setEnableSmoothing(boolean bl) {
        this.enableSmoothing = bl;
    }

    @Override
    public boolean isLockHeading() {
        return this.lockHeading;
    }

    @Override
    public void setLockHeading(boolean bl) {
        this.lockHeading = bl;
    }

    @Override
    public boolean isStopOnFocusLost() {
        return this.stopOnFocusLost;
    }

    @Override
    public void setStopOnFocusLost(boolean bl) {
        this.stopOnFocusLost = bl;
    }

    @Override
    public double getDragSlopeFactor() {
        return this.dragSlopeFactor;
    }

    @Override
    public void setDragSlopeFactor(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "factor < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dragSlopeFactor = d;
    }

    protected View getView() {
        return this.wwd != null ? this.wwd.getView() : null;
    }

    public boolean callActionListener(KeyEventState keyEventState, String string, ViewInputAttributes.ActionAttributes actionAttributes) {
        if (actionAttributes.getActionListener() != null) {
            return actionAttributes.getActionListener().inputActionPerformed(this, keyEventState, string, actionAttributes);
        }
        if (actionAttributes.getMouseActionListener() != null) {
            return actionAttributes.getMouseActionListener().inputActionPerformed(keyEventState, string, actionAttributes);
        }
        return false;
    }

    protected boolean isWorldWindowFocusOwner() {
        return this.wwdFocusOwner;
    }

    protected void setWorldWindowFocusOwner(boolean bl) {
        this.wwdFocusOwner = bl;
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    protected Point getLastMousePoint() {
        return this.lastMousePoint;
    }

    protected void updateMousePoint(MouseEvent mouseEvent) {
        this.lastMousePoint = this.mousePoint;
        this.mousePoint = new Point(mouseEvent.getPoint());
    }

    protected Position getSelectedPosition() {
        return this.selectedPosition;
    }

    protected void setSelectedPosition(Position position) {
        this.selectedPosition = position;
    }

    protected Position computeSelectedPosition() {
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (pickedObjectList != null && pickedObjectList.getTerrainObject() != null) {
            return pickedObjectList.getTerrainObject().getPosition();
        }
        return null;
    }

    protected void onStopView() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        view.stopMovement();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyTyped(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyPressed(keyEvent);
        this.handleKeyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.keyEventState.keyReleased(keyEvent);
        this.handleKeyReleased(keyEvent);
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
        View view;
        if (this.handlePerFrameKeyState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected void handleKeyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.handleMouseClicked(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.keyEventState.mousePressed(mouseEvent);
        this.setMouseDownPoint(mouseEvent.getPoint());
        this.setSelectedPosition(this.computeSelectedPosition());
        this.updateMousePoint(mouseEvent);
        this.handleMousePressed(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.keyEventState.mouseReleased(mouseEvent);
        this.setSelectedPosition(null);
        this.handleMouseReleased(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
    }

    protected void handleMouseClicked(MouseEvent mouseEvent) {
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        View view;
        if (this.handlePerFrameMouseState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
            view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
        }
    }

    protected void handleMouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.handleMouseDragged(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.updateMousePoint(mouseEvent);
        this.handleMouseMoved(mouseEvent);
    }

    protected void handleMouseDragged(MouseEvent mouseEvent) {
    }

    protected void handleMouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        this.handleMouseWheelMoved(mouseWheelEvent);
    }

    protected void handleMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.setWorldWindowFocusOwner(true);
        this.handleFocusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.keyEventState.clearKeyState();
        this.setWorldWindowFocusOwner(false);
        this.handleFocusLost(focusEvent);
    }

    protected void handleFocusGained(FocusEvent focusEvent) {
    }

    protected void handleFocusLost(FocusEvent focusEvent) {
        if (this.isStopOnFocusLost()) {
            this.onStopView();
        }
    }

    @Override
    public void apply() {
        if (!this.isWorldWindowFocusOwner()) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastPerFrameInputTime > 35L) {
            this.handlePerFrameKeyState(this.keyEventState, GENERATE_EVENTS);
            this.handlePerFrameMouseState(this.keyEventState, GENERATE_EVENTS);
            this.lastPerFrameInputTime = l;
        } else {
            View view;
            if (this.handlePerFrameKeyState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
                view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
            }
            if (this.handlePerFrameMouseState(this.keyEventState, QUERY_EVENTS) && (view = this.getView()) != null) {
                view.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, view);
            }
        }
    }

    @Override
    public void viewApplied() {
    }

    protected boolean handlePerFrameKeyState(KeyEventState keyEventState, String string) {
        return false;
    }

    protected boolean handlePerFrameMouseState(KeyEventState keyEventState, String string) {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.wwd == null) {
            return;
        }
        if (propertyChangeEvent == null) {
            return;
        }
        this.handlePropertyChange(propertyChangeEvent);
    }

    protected void handlePropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected double rawInputToChangeInValue(double d, ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes, String string) {
        double d2 = d;
        double[] dArray = actionAttributes.getValues();
        d2 *= this.getScaledValue(dArray[0], dArray[1], string);
        return d2 *= deviceAttributes.getSensitivity();
    }

    protected double getScaledValue(double d, double d2, String string) {
        if (string == null) {
            return d;
        }
        double d3 = 0.0;
        if (string.startsWith(SCALE_FUNC_EYE_ALTITUDE)) {
            d3 = this.evaluateScaleFuncEyeAltitude();
        } else if (string.startsWith(SCALE_FUNC_ZOOM)) {
            d3 = this.evaluateScaleFuncZoom();
        }
        if (string.toLowerCase().endsWith("exp")) {
            d3 = Math.pow(2.0, d3) - 1.0;
        }
        return d * (1.0 - d3) + d2 * d3;
    }

    protected double evaluateScaleFuncEyeAltitude() {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        Position position = view.getEyePosition();
        double d = this.wwd.getModel().getGlobe().getRadius();
        double d2 = this.wwd.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        double d3 = (position.getElevation() - d2) / (3.0 * d);
        return d3 < 0.0 ? 0.0 : (d3 > 1.0 ? 1.0 : d3);
    }

    protected double evaluateScaleFuncZoom() {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        if (view instanceof OrbitView) {
            double d = this.wwd.getModel().getGlobe().getRadius();
            double d2 = ((OrbitView)view).getZoom() / (3.0 * d);
            return d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
        }
        return 0.0;
    }

    protected double getScaleValueElevation(ViewInputAttributes.DeviceAttributes deviceAttributes, ViewInputAttributes.ActionAttributes actionAttributes) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        double[] dArray = actionAttributes.getValues();
        Position position = view.getEyePosition();
        double d = this.wwd.getModel().getGlobe().getRadius();
        double d2 = this.wwd.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        double d3 = this.getScaleValue(dArray[0], dArray[1], position.getElevation() - d2, 3.0 * d, true);
        return d3 *= deviceAttributes.getSensitivity();
    }

    protected double getScaleValue(double d, double d2, double d3, double d4, boolean bl) {
        double d5 = d3 / d4;
        double d6 = d5 < 0.0 ? 0.0 : (d5 = d5 > 1.0 ? 1.0 : d5);
        if (bl) {
            d5 = Math.pow(2.0, d5) - 1.0;
        }
        return d * (1.0 - d5) + d2 * d5;
    }

    protected Vec4 computeSelectedPointAt(Point point) {
        if (this.getSelectedPosition() == null) {
            return null;
        }
        View view = this.getView();
        if (view == null) {
            return null;
        }
        double d = this.getSelectedPosition().getElevation();
        if (view.getEyePosition().getElevation() <= d) {
            return null;
        }
        Line line = view.computeRayFromScreenPoint(point.getX(), point.getY());
        Intersection[] intersectionArray = this.wwd.getModel().getGlobe().intersect(line, d);
        if (intersectionArray == null || intersectionArray.length == 0) {
            return null;
        }
        return line.nearestIntersectionPoint(intersectionArray);
    }

    protected LatLon getChangeInLocation(Point point, Point point2, Vec4 vec4, Vec4 vec42) {
        double d = this.computeDragSlope(point, point2, vec4, vec42);
        double d2 = this.getDragSlopeFactor();
        double d3 = 1.0 / (1.0 + d2 * d * d);
        Position position = this.wwd.getModel().getGlobe().computePositionFromPoint(vec4);
        Position position2 = this.wwd.getModel().getGlobe().computePositionFromPoint(vec42);
        LatLon latLon = LatLon.interpolateGreatCircle(d3, position, position2);
        return position.subtract(latLon);
    }

    @Override
    public double computeDragSlope(Point point, Point point2, Vec4 vec4, Vec4 vec42) {
        View view = this.getView();
        if (view == null) {
            return 0.0;
        }
        double d = point2.getX() - point.getX();
        double d2 = point2.getY() - point.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = view.getEyePoint().distanceTo3(vec4);
        double d5 = view.computePixelSizeAtDistance(d4);
        double d6 = vec4.distanceTo3(vec42) / (d3 * d5);
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        return d6 - 1.0;
    }

    protected static Point constrainToSourceBounds(Point point, Object object) {
        int n;
        if (point == null) {
            return null;
        }
        if (!(object instanceof Component)) {
            return point;
        }
        Component component = (Component)object;
        int n2 = (int)point.getX();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > component.getWidth()) {
            n2 = component.getWidth();
        }
        if ((n = (int)point.getY()) < 0) {
            n = 0;
        }
        if (n > component.getHeight()) {
            n = component.getHeight();
        }
        return new Point(n2, n);
    }

    public Point getMouseDownPoint() {
        return this.mouseDownPoint;
    }

    public void setMouseDownPoint(Point point) {
        this.mouseDownPoint = point;
    }
}

