/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.avlist;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class AVListImpl
implements AVList {
    private static final String PROPERTY_CHANGE_SUPPORT = "avlist.PropertyChangeSupport";
    private Map<String, Object> avList;

    public AVListImpl() {
    }

    public AVListImpl(Object object) {
        if (object != null) {
            this.setValue(PROPERTY_CHANGE_SUPPORT, new PropertyChangeSupport(object));
        }
    }

    private boolean hasAvList() {
        return this.avList != null;
    }

    private Map<String, Object> createAvList() {
        if (!this.hasAvList()) {
            this.avList = new HashMap<String, Object>(1);
        }
        return this.avList;
    }

    private Map<String, Object> avList(boolean bl) {
        if (bl && !this.hasAvList()) {
            this.createAvList();
        }
        return this.avList;
    }

    @Override
    public synchronized Object getValue(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.hasAvList()) {
            return this.avList.get(string);
        }
        return null;
    }

    @Override
    public synchronized Collection<Object> getValues() {
        return this.hasAvList() ? this.avList.values() : this.createAvList().values();
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> getEntries() {
        return this.hasAvList() ? this.avList.entrySet() : this.createAvList().entrySet();
    }

    @Override
    public synchronized String getStringValue(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        try {
            return (String)this.getValue(string);
        }
        catch (ClassCastException classCastException) {
            String string3 = Logging.getMessage("AVAAccessibleImpl.AttributeValueForKeyIsNotAString", string);
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3, classCastException);
        }
    }

    @Override
    public synchronized Object setValue(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.avList(true).put(string, object);
    }

    @Override
    public synchronized AVList setValues(AVList aVList) {
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Set<Map.Entry<String, Object>> set = aVList.getEntries();
        for (Map.Entry<String, Object> entry : set) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public synchronized boolean hasKey(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.hasAvList() && this.avList.containsKey(string);
    }

    @Override
    public synchronized Object removeKey(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.hasKey(string) ? this.avList.remove(string) : null;
    }

    @Override
    public synchronized AVList copy() {
        AVListImpl aVListImpl = new AVListImpl();
        if (this.avList != null) {
            aVListImpl.createAvList();
            aVListImpl.avList.putAll(this.avList);
        }
        return aVListImpl;
    }

    @Override
    public synchronized AVList clearList() {
        if (this.hasAvList()) {
            this.avList.clear();
        }
        return this;
    }

    protected synchronized PropertyChangeSupport getChangeSupport() {
        Object object = this.getValue(PROPERTY_CHANGE_SUPPORT);
        if (object == null || !(object instanceof PropertyChangeSupport)) {
            object = new PropertyChangeSupport(this);
            this.setValue(PROPERTY_CHANGE_SUPPORT, object);
        }
        return (PropertyChangeSupport)object;
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (propertyChangeListener == null) {
            String string3 = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (propertyChangeListener == null) {
            String string3 = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.getChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            String string = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String string = Logging.getMessage("nullValue.PropertyChangeEventIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.getChangeSupport().firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void firePropertyChange(String string, Object object, Object object2) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.getChangeSupport().firePropertyChange(string, object, object2);
    }

    public static String getStringValue(AVList aVList, String string, String string2) {
        String string3 = AVListImpl.getStringValue(aVList, string);
        return string3 != null ? string3 : string2;
    }

    public static String getStringValue(AVList aVList, String string) {
        try {
            return aVList.getStringValue(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Integer getIntegerValue(AVList aVList, String string, Integer n) {
        Integer n2 = AVListImpl.getIntegerValue(aVList, string);
        return n2 != null ? n2 : n;
    }

    public static Integer getIntegerValue(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        String string2 = AVListImpl.getStringValue(aVList, string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static Long getLongValue(AVList aVList, String string, Long l) {
        Long l2 = AVListImpl.getLongValue(aVList, string);
        return l2 != null ? l2 : l;
    }

    public static Long getLongValue(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        String string2 = AVListImpl.getStringValue(aVList, string);
        if (string2 == null) {
            return null;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public static Double getDoubleValue(AVList aVList, String string, Double d) {
        Double d2 = AVListImpl.getDoubleValue(aVList, string);
        return d2 != null ? d2 : d;
    }

    public static Double getDoubleValue(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        String string2 = AVListImpl.getStringValue(aVList, string);
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }

    public void getRestorableStateForAVPair(String string, Object object, RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (object == null) {
            return;
        }
        if (string.equals(PROPERTY_CHANGE_SUPPORT)) {
            return;
        }
        if (restorableSupport == null) {
            String string2 = Logging.getMessage("nullValue.RestorableStateIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        restorableSupport.addStateValueAsString(stateObject, string, object.toString());
    }

    public static Boolean getBooleanValue(AVList aVList, String string, Boolean bl) {
        Boolean bl2 = AVListImpl.getBooleanValue(aVList, string);
        return bl2 != null ? bl2 : bl;
    }

    public static Boolean getBooleanValue(AVList aVList, String string) {
        Object object = aVList.getValue(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string2 = AVListImpl.getStringValue(aVList, string);
        if (string2 == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", string2);
            return null;
        }
    }
}

