/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.AnimationSupport;
import gov.nasa.worldwind.animation.Interpolator;
import gov.nasa.worldwind.util.Logging;
import java.util.Date;

public class ScheduledInterpolator
implements Interpolator {
    private long startTime = -1L;
    private final long length;

    public ScheduledInterpolator(long l) {
        this(null, l);
    }

    public ScheduledInterpolator(Date date, long l) {
        if (l < 0L) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (date != null) {
            this.startTime = date.getTime();
        }
        this.length = l;
    }

    public ScheduledInterpolator(Date date, Date date2) {
        if (date == null || date2 == null) {
            String string = Logging.getMessage("nullValue.DateIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (date.after(date2)) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", date);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startTime = date.getTime();
        this.length = date2.getTime() - date.getTime();
    }

    @Override
    public double nextInterpolant() {
        long l = System.currentTimeMillis();
        if (this.startTime < 0L) {
            this.startTime = l;
        }
        if (l < this.startTime) {
            return 0.0;
        }
        long l2 = l - this.startTime;
        double d = (double)l2 / (double)this.length;
        return AnimationSupport.clampDouble(d, 0.0, 1.0);
    }
}

