/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Factory;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.ogc.OGCCapabilities;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicFactory
implements Factory {
    public static Object create(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage("generic.FactoryKeyIsNull");
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(object)) {
            String string3 = Logging.getMessage("generic.ConfigurationSourceIsInvalid", object);
            throw new IllegalArgumentException(string3);
        }
        Factory factory = (Factory)WorldWind.createConfigurationComponent(string);
        return factory.createFromConfigSource(object, null);
    }

    public static Object create(String string, Object object, AVList aVList) {
        if (string == null) {
            String string2 = Logging.getMessage("generic.FactoryKeyIsNull");
            throw new IllegalArgumentException(string2);
        }
        if (WWUtil.isEmpty(object)) {
            String string3 = Logging.getMessage("generic.ConfigurationSourceIsInvalid", object);
            throw new IllegalArgumentException(string3);
        }
        Factory factory = (Factory)WorldWind.createConfigurationComponent(string);
        return factory.createFromConfigSource(object, aVList);
    }

    @Override
    public Object createFromConfigSource(Object object, AVList aVList) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("generic.ConfigurationSourceIsInvalid", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Object object2 = null;
        try {
            if (object instanceof Element) {
                object2 = this.doCreateFromElement((Element)object, aVList);
            } else if (object instanceof OGCCapabilities) {
                object2 = this.doCreateFromCapabilities((OGCCapabilities)object, aVList);
            } else {
                Document document = WWXML.openDocument(object);
                if (document != null) {
                    object2 = this.doCreateFromElement(document.getDocumentElement(), aVList);
                }
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.CreationFromConfigurationFileFailed", object);
            throw new WWRuntimeException(string, exception);
        }
        return object2;
    }

    public Object createFromCapabilities(String string, AVList aVList) {
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        WMSCapabilities wMSCapabilities = new WMSCapabilities((Object)string);
        try {
            wMSCapabilities.parse(new Object[0]);
        }
        catch (XMLStreamException xMLStreamException) {
            String string3 = Logging.getMessage("generic.CannotParseCapabilities", string);
            Logging.logger().log(Level.SEVERE, string3, xMLStreamException);
            throw new WWRuntimeException(string3, xMLStreamException);
        }
        return this.doCreateFromCapabilities(wMSCapabilities, aVList);
    }

    protected Object doCreateFromCapabilities(OGCCapabilities oGCCapabilities, AVList aVList) {
        return null;
    }

    protected Object doCreateFromElement(Element element, AVList aVList) throws Exception {
        return null;
    }
}

