/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.impl.JsonGeneratorBase;
import org.codehaus.jackson.impl.JsonWriteContext;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.util.CharTypes;

public final class WriterBasedGenerator
extends JsonGeneratorBase {
    static final int SHORT_WRITE = 32;
    static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    protected final IOContext _ioContext;
    protected final Writer _writer;
    protected char[] _outputBuffer;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected int _outputEnd;
    protected char[] _entityBuffer;

    public WriterBasedGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, Writer writer) {
        super(n, objectCodec);
        this._ioContext = iOContext;
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    @Override
    protected void _writeStartArray() throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    protected void _writeEndArray() throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 93;
    }

    @Override
    protected void _writeStartObject() throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    protected void _writeEndObject() throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 125;
    }

    @Override
    protected void _writeFieldName(String string, boolean bl) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    protected final void _writePPFieldName(String string, boolean bl) throws IOException, JsonGenerationException {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this._writeString(string);
        }
    }

    @Override
    public void writeString(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeRaw(String string) throws IOException, JsonGenerationException {
        int n = string.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
        } else {
            this.writeRawLong(string);
        }
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string.substring(n, n + n2));
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n, n2);
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    @Override
    public void writeRawValue(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string);
    }

    @Override
    public void writeRawValue(String string, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(string, n, n2);
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write raw value");
        this.writeRaw(cArray, n, n2);
    }

    private void writeRawLong(String string) throws IOException, JsonGenerationException {
        int n;
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n = string.length() - n3; n > this._outputEnd; n -= n2) {
            n2 = this._outputEnd;
            string.getChars(n4, n4 + n2, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        string.getChars(n4, n4 + n, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n;
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d) || Double.isInfinite(d)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d));
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f) || Float.isInfinite(f)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
        } else {
            this.writeRaw(bigDecimal.toString());
        }
    }

    @Override
    public void writeNumber(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    private final void _writeQuotedRaw(Object object) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n] = 116;
            cArray[++n] = 114;
            cArray[++n] = 117;
            cArray[++n] = 101;
        } else {
            cArray[n] = 102;
            cArray[++n] = 97;
            cArray[++n] = 108;
            cArray[++n] = 115;
            cArray[++n] = 101;
        }
        this._outputTail = n + 1;
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    @Override
    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 44;
                    break;
                }
                case 2: {
                    n2 = 58;
                    break;
                }
                case 3: {
                    n2 = 32;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail] = n2;
            ++this._outputTail;
            return;
        }
        this._verifyPrettyValueWrite(string, n);
    }

    protected final void _verifyPrettyValueWrite(String string, int n) throws IOException, JsonGenerationException {
        switch (n) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            default: {
                this._cantHappen();
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        this._flushBuffer();
        this._writer.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._writer.close();
        } else {
            this._writer.flush();
        }
        this._releaseBuffers();
    }

    @Override
    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string) throws IOException, JsonGenerationException {
        int n = string.length();
        if (n > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n, this._outputBuffer, this._outputTail);
        int n2 = this._outputTail + n;
        int[] nArray = CharTypes.getOutputEscapes();
        int n3 = nArray.length;
        block0: while (this._outputTail < n2) {
            int n4;
            int n5;
            int n6;
            while ((n6 = this._outputBuffer[this._outputTail]) >= n3 || nArray[n6] == 0) {
                if (++this._outputTail < n2) continue;
                break block0;
            }
            n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            int n7 = nArray[this._outputBuffer[this._outputTail]];
            ++this._outputTail;
            int n8 = n5 = n7 < 0 ? 6 : 2;
            if (n5 > this._outputTail) {
                this._outputHead = this._outputTail;
                this._writeSingleEscape(n7);
                continue;
            }
            this._outputHead = n4 = this._outputTail - n5;
            this._appendSingleEscape(n7, this._outputBuffer, n4);
        }
    }

    private void _writeLongString(String string) throws IOException, JsonGenerationException {
        int n;
        this._flushBuffer();
        int n2 = string.length();
        int n3 = 0;
        do {
            int n4;
            n = n3 + (n4 = this._outputEnd) > n2 ? n2 - n3 : n4;
            string.getChars(n3, n3 + n, this._outputBuffer, 0);
            this._writeSegment(n);
        } while ((n3 += n) < n2);
    }

    private final void _writeSegment(int n) throws IOException, JsonGenerationException {
        int[] nArray = CharTypes.getOutputEscapes();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            int n6 = n3;
            while (((n5 = this._outputBuffer[n3]) >= n2 || nArray[n5] == 0) && ++n3 < n) {
            }
            n5 = n3 - n6;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, n6, n5);
                if (n3 >= n) break;
            }
            int n7 = nArray[this._outputBuffer[n3]];
            ++n3;
            int n8 = n4 = n7 < 0 ? 6 : 2;
            if (n4 > this._outputTail) {
                this._writeSingleEscape(n7);
                continue;
            }
            this._appendSingleEscape(n7, this._outputBuffer, n3 -= n4);
        }
    }

    private void _writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        n2 += n;
        int[] nArray = CharTypes.getOutputEscapes();
        int n3 = nArray.length;
        while (n < n2) {
            int n4;
            int n5;
            int n6 = n;
            while (((n5 = cArray[n]) >= n3 || nArray[n5] == 0) && ++n < n2) {
            }
            n5 = n - n6;
            if (n5 < 32) {
                if (this._outputTail + n5 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n5 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n5);
                    this._outputTail += n5;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n5);
            }
            if (n >= n2) break;
            int n7 = nArray[cArray[n]];
            ++n;
            int n8 = n4 = n7 < 0 ? 6 : 2;
            if (this._outputTail + n4 > this._outputEnd) {
                this._flushBuffer();
            }
            this._appendSingleEscape(n7, this._outputBuffer, this._outputTail);
            this._outputTail += n4;
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = byArray[n++] << 8;
            n3 |= byArray[n++] & 0xFF;
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n7 = byArray[n++] << 16;
            if (n3 == 2) {
                n7 |= (byArray[n++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n7, n3, this._outputBuffer, this._outputTail);
        }
    }

    private final void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n] = 110;
        cArray[++n] = 117;
        cArray[++n] = 108;
        cArray[++n] = 108;
        this._outputTail = n + 1;
    }

    private void _writeSingleEscape(int n) throws IOException {
        char[] cArray = this._entityBuffer;
        if (cArray == null) {
            cArray = new char[6];
            cArray[0] = 92;
            cArray[2] = 48;
            cArray[3] = 48;
        }
        if (n < 0) {
            int n2 = -(n + 1);
            cArray[1] = 117;
            cArray[4] = HEX_CHARS[n2 >> 4];
            cArray[5] = HEX_CHARS[n2 & 0xF];
            this._writer.write(cArray, 0, 6);
        } else {
            cArray[1] = (char)n;
            this._writer.write(cArray, 0, 2);
        }
    }

    private void _appendSingleEscape(int n, char[] cArray, int n2) {
        if (n < 0) {
            int n3 = -(n + 1);
            cArray[n2] = 92;
            cArray[++n2] = 117;
            cArray[++n2] = 48;
            cArray[++n2] = 48;
            cArray[++n2] = HEX_CHARS[n3 >> 4];
            cArray[++n2] = HEX_CHARS[n3 & 0xF];
        } else {
            cArray[n2] = 92;
            cArray[n2 + 1] = (char)n;
        }
    }

    protected final void _flushBuffer() throws IOException {
        int n = this._outputTail - this._outputHead;
        if (n > 0) {
            int n2 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n);
        }
    }
}

