/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWBufferUtil;
import gov.nasa.worldwind.util.WWUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WWIO {
    public static final String DELETE_ON_EXIT_PREFIX = "WWJDeleteOnExit";
    public static final String ILLEGAL_FILE_PATH_PART_CHARACTERS = "[?/\\\\=+<>:;\\,\"\\|^\\[\\]]";
    protected static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final int MAX_FILE_PATH_LENGTH = 255;
    protected static Map<String, String> mimeTypeToSuffixMap = new HashMap<String, String>();
    protected static Map<String, String> suffixToMimeTypeMap = new HashMap<String, String>();

    public static String formPath(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (string == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.separator);
            }
            stringBuilder.append(string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_"));
        }
        return stringBuilder.toString();
    }

    public static String appendPathPart(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string == null || string.length() == 0) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(WWIO.stripTrailingSeparator(string));
        stringBuilder.append(File.separator);
        stringBuilder.append(WWIO.stripLeadingSeparator(string2));
        return stringBuilder.toString();
    }

    public static String replaceIllegalFileNameCharacters(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return string.replaceAll(ILLEGAL_FILE_PATH_PART_CHARACTERS, "_");
    }

    public static String stripTrailingSeparator(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.endsWith("/") || string.endsWith("\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String stripLeadingSeparator(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.startsWith("/") || string.startsWith("\\")) {
            return string.substring(1, string.length());
        }
        return string;
    }

    public static String stripLeadingZeros(String string) {
        int n;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n2 = string.length();
        if (n2 < 2) {
            return string;
        }
        for (n = 0; n < n2 && string.charAt(n) == '0'; ++n) {
        }
        if (n == n2) {
            n = n2 - 1;
        }
        if (n == 0) {
            return string;
        }
        return string.substring(n, n2);
    }

    public static File getFileForLocalAddress(Object object) {
        if (WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof File) {
            return (File)object;
        }
        if (object instanceof URL) {
            return WWIO.convertURLToFile((URL)object);
        }
        if (object instanceof URI) {
            return WWIO.convertURIToFile((URI)object);
        }
        if (!(object instanceof String)) {
            return null;
        }
        String string = (String)object;
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            return WWIO.convertURLToFile(uRL);
        }
        URI uRI = WWIO.makeURI(string);
        if (uRI != null) {
            return WWIO.convertURIToFile(uRI);
        }
        return null;
    }

    public static File convertURIToFile(URI uRI) {
        if (uRI == null) {
            String string = Logging.getMessage("nullValue.URIIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static File convertURLToFile(URL uRL) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return new File(uRL.toURI());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveBuffer(ByteBuffer byteBuffer, File file, boolean bl) throws IOException {
        boolean bl2;
        int n;
        FileChannel fileChannel;
        FileOutputStream fileOutputStream;
        block12: {
            if (byteBuffer == null) {
                String string = Logging.getMessage("nullValue.BufferNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (file == null) {
                String string = Logging.getMessage("nullValue.FileIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            fileOutputStream = null;
            fileChannel = null;
            n = 0;
            fileOutputStream = new FileOutputStream(file);
            fileChannel = fileOutputStream.getChannel();
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock != null) break block12;
            Logging.logger().log(Level.FINER, "WWIO.UnableToAcquireLockFor", file.getPath());
            boolean bl3 = false;
            WWIO.closeStream(fileChannel, file.getPath());
            WWIO.closeStream(fileOutputStream, file.getPath());
            return bl3;
        }
        try {
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                n += fileChannel.write(byteBuffer);
            }
            if (bl) {
                fileChannel.force(true);
            }
            fileOutputStream.flush();
            bl2 = true;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            try {
                Logging.logger().log(Level.FINE, Logging.getMessage("generic.interrupted", "WWIO.saveBuffer", file.getPath()), closedByInterruptException);
                if (n > 0) {
                    file.delete();
                }
                throw closedByInterruptException;
                catch (IOException iOException) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("WWIO.ErrorSavingBufferTo", file.getPath()), iOException);
                    if (n > 0) {
                        file.delete();
                    }
                    throw iOException;
                }
            }
            catch (Throwable throwable) {
                WWIO.closeStream(fileChannel, file.getPath());
                WWIO.closeStream(fileOutputStream, file.getPath());
                throw throwable;
            }
        }
        WWIO.closeStream(fileChannel, file.getPath());
        WWIO.closeStream(fileOutputStream, file.getPath());
        return bl2;
    }

    public static boolean saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        return WWIO.saveBuffer(byteBuffer, file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBufferToStream(ByteBuffer byteBuffer, OutputStream outputStream) throws IOException {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (outputStream == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
            byteBuffer.rewind();
            while (byteBuffer.hasRemaining()) {
                writableByteChannel.write(byteBuffer);
            }
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            WWIO.closeStream(outputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer mapFile(File file, FileChannel.MapMode mapMode) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (mapMode == null) {
            String string = Logging.getMessage("nullValue.ModelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw";
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, string);
            FileChannel fileChannel = randomAccessFile.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(mapMode, 0L, fileChannel.size());
            return mappedByteBuffer;
        }
        finally {
            WWIO.closeStream(randomAccessFile, file.getPath());
        }
    }

    public static MappedByteBuffer mapFile(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWIO.mapFile(file, FileChannel.MapMode.READ_ONLY);
    }

    public static ByteBuffer readURLContentToBuffer(URL uRL) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWIO.readURLContentToBuffer(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readURLContentToBuffer(URL uRL, boolean bl) throws IOException {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            ByteBuffer byteBuffer = WWIO.readStreamToBuffer(inputStream, bl);
            return byteBuffer;
        }
        finally {
            WWIO.closeStream(inputStream, uRL.toString());
        }
    }

    public static String readURLContentToString(URL uRL, String string) throws IOException {
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        ByteBuffer byteBuffer = WWIO.readURLContentToBuffer(uRL);
        return WWIO.byteBufferToString(byteBuffer, string);
    }

    public static ByteBuffer readFileToBuffer(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWIO.readFileToBuffer(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readFileToBuffer(File file, boolean bl) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileChannel fileChannel = fileInputStream.getChannel();
            int n = (int)fileChannel.size();
            ByteBuffer byteBuffer = bl ? ByteBuffer.allocateDirect(n) : ByteBuffer.allocate(n);
            int n2 = 0;
            while (n2 >= 0 && byteBuffer.hasRemaining()) {
                n2 = fileChannel.read(byteBuffer);
            }
            byteBuffer.flip();
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        finally {
            WWIO.closeStream(fileInputStream, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer inflateFileToBuffer(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            ByteBuffer byteBuffer = WWIO.inflateStreamToBuffer(fileInputStream);
            return byteBuffer;
        }
        finally {
            WWIO.closeStream(fileInputStream, file.getPath());
        }
    }

    public static boolean saveBufferToGZipFile(ByteBuffer byteBuffer, File file) throws IOException {
        return WWIO.saveBufferToStream(byteBuffer, new GZIPOutputStream(new FileOutputStream(file)));
    }

    public static boolean deflateBufferToFile(ByteBuffer byteBuffer, File file) throws IOException {
        return WWIO.saveBufferToStream(byteBuffer, new DeflaterOutputStream(new FileOutputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readGZipFileToBuffer(File file) throws IllegalArgumentException, IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        if (!file.canRead()) {
            String string = Logging.getMessage("generic.FileNoReadPermission", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        int n = WWIO.gzipGetInflatedLength(file);
        if (0 == n) {
            String string = Logging.getMessage("generic.LengthIsInvalid", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        ByteBuffer byteBuffer = null;
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file)));
            byteBuffer = WWIO.transferStreamToByteBuffer(gZIPInputStream, n);
            byteBuffer.rewind();
        }
        catch (Throwable throwable) {
            WWIO.closeStream(gZIPInputStream, file.getPath());
            throw throwable;
        }
        WWIO.closeStream(gZIPInputStream, file.getPath());
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int gzipGetInflatedLength(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        int n = 0;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            randomAccessFile.seek(randomAccessFile.length() - 4L);
            int n2 = 0xFF & randomAccessFile.read();
            int n3 = 0xFF & randomAccessFile.read();
            int n4 = 0xFF & randomAccessFile.read();
            int n5 = 0xFF & randomAccessFile.read();
            n = n5 << 24 | (n4 << 16) + (n3 << 8) + n2;
        }
        finally {
            if (null != randomAccessFile) {
                randomAccessFile.close();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readZipEntryToBuffer(File file, String string) throws IOException {
        Object object;
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        InputStream inputStream = null;
        Object object2 = null;
        try {
            Object object3;
            ZipFile zipFile = new ZipFile(file);
            if (zipFile.size() < 1) {
                String string3 = Logging.getMessage("WWIO.ZipFileIsEmpty", file.getPath());
                Logging.logger().severe(string3);
                throw new IOException(string3);
            }
            if (string != null) {
                object2 = zipFile.getEntry(string);
                if (object2 == null) {
                    String string4 = Logging.getMessage("WWIO.ZipFileEntryNIF", string, file.getPath());
                    Logging.logger().severe(string4);
                    throw new IOException(string4);
                }
            } else {
                object3 = zipFile.entries();
                while (object3.hasMoreElements()) {
                    object = object3.nextElement();
                    if (null == object || ((ZipEntry)object).isDirectory()) continue;
                    object2 = object;
                    break;
                }
                if (null == object2) {
                    object = Logging.getMessage("WWIO.ZipFileIsEmpty", file.getPath());
                    Logging.logger().severe((String)object);
                    throw new IOException((String)object);
                }
            }
            inputStream = zipFile.getInputStream((ZipEntry)object2);
            object3 = null;
            if (((ZipEntry)object2).getSize() > 0L) {
                object3 = WWIO.transferStreamToByteBuffer(inputStream, (int)((ZipEntry)object2).getSize());
                ((ByteBuffer)object3).rewind();
            }
            object = object3;
        }
        catch (Throwable throwable) {
            WWIO.closeStream(inputStream, string);
            throw throwable;
        }
        WWIO.closeStream(inputStream, string);
        return object;
    }

    private static ByteBuffer transferStreamToByteBuffer(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 1) {
            Logging.logger().severe("WWIO.NumberBytesTransferLessThanOne");
            throw new IllegalArgumentException(Logging.getMessage("WWIO.NumberBytesTransferLessThanOne"));
        }
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = new byte[n];
        while (n3 >= 0 && n - n2 > 0) {
            n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(byArray.length);
        return byteBuffer.put(byArray);
    }

    public static ByteBuffer readStreamToBuffer(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWIO.readStreamToBuffer(inputStream, false);
    }

    public static ByteBuffer readStreamToBuffer(InputStream inputStream, boolean bl) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        return WWIO.readChannelToBuffer(readableByteChannel, bl);
    }

    public static String readStreamToString(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            String string2 = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWIO.readCharacterStreamToString(new InputStreamReader(inputStream, string != null ? string : DEFAULT_CHARACTER_ENCODING));
    }

    public static ByteBuffer readChannelToBuffer(ReadableByteChannel readableByteChannel, boolean bl) throws IOException {
        if (readableByteChannel == null) {
            String string = Logging.getMessage("nullValue.ChannelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = (int)Math.round(Math.pow(2.0, 16.0));
        ByteBuffer byteBuffer = WWBufferUtil.newByteBuffer(n, bl);
        int n2 = 0;
        while (n2 >= 0) {
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 <= 0 || byteBuffer.hasRemaining()) continue;
            ByteBuffer byteBuffer2 = bl ? ByteBuffer.allocateDirect(byteBuffer.limit() + n) : ByteBuffer.allocate(byteBuffer.limit() + n);
            byteBuffer2.put((ByteBuffer)byteBuffer.rewind());
            byteBuffer = byteBuffer2;
        }
        if (byteBuffer != null) {
            byteBuffer.flip();
        }
        return byteBuffer;
    }

    public static ByteBuffer readChannelToBuffer(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        if (readableByteChannel == null) {
            String string = Logging.getMessage("nullValue.ChannelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        while (n >= 0 && byteBuffer.hasRemaining()) {
            n = readableByteChannel.read(byteBuffer);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String readChannelToString(ReadableByteChannel readableByteChannel, String string) throws IOException {
        if (readableByteChannel == null) {
            String string2 = Logging.getMessage("nullValue.ChannelIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return WWIO.readCharacterStreamToString(Channels.newReader(readableByteChannel, string != null ? string : DEFAULT_CHARACTER_ENCODING));
    }

    public static String readCharacterStreamToString(Reader reader) throws IOException {
        String string;
        if (reader == null) {
            String string2 = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static ByteBuffer inflateStreamToBuffer(InputStream inputStream) throws IOException {
        return WWIO.readStreamToBuffer(new InflaterInputStream(inputStream));
    }

    public static String replaceSuffix(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = string2 != null ? string2 : "";
        int n = string.lastIndexOf(".");
        return n >= 0 ? string.substring(0, n) + string4 : string + string4;
    }

    public static String getSuffix(String string) {
        String string2;
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        int n = string.length();
        int n2 = string.lastIndexOf(".");
        String string4 = string2 = n2 >= 0 && n2 + 1 < n ? string.substring(n2 + 1, n) : null;
        if (null != string2 && n2 > 0 && "gz".equals(string2)) {
            int n3 = string.lastIndexOf(".", n2 - 1);
            string2 = n3 >= 0 && n3 + 1 < n ? string.substring(n3 + 1, n) : string2;
        }
        return string2;
    }

    public static String getFilename(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        string = WWIO.stripTrailingSeparator(string);
        int n = string.length();
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            n2 = string.lastIndexOf("\\");
        }
        return n2 >= 0 && n2 + 1 < n ? string.substring(n2 + 1, n) : null;
    }

    public static String getParentFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        string = WWIO.stripTrailingSeparator(string);
        int n = string.length();
        int n2 = string.lastIndexOf("/");
        if (n2 < 0) {
            n2 = string.lastIndexOf("\\");
        }
        return n2 > 0 && n2 < n ? string.substring(0, n2) : null;
    }

    public static boolean makeParentDirs(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = File.separator;
        String[] stringArray = string.split("[/" + (string3.equals("/") ? "" : (string3.equals("\\") ? "\\\\" : string3)) + "]");
        if (stringArray.length <= 1) {
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].length() == 0) continue;
            stringBuilder.append(File.separator);
            stringBuilder.append(stringArray[i]);
        }
        return new File(stringBuilder.toString()).mkdirs();
    }

    public static File makeTempDir() throws IOException {
        File file = File.createTempFile("wwj", null);
        if (!file.delete()) {
            return null;
        }
        if (!file.mkdir()) {
            return null;
        }
        return file;
    }

    public static File saveBufferToTempFile(ByteBuffer byteBuffer, String string) throws IOException {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = File.createTempFile("WorldWind", string != null ? string : "");
        file.deleteOnExit();
        byteBuffer.rewind();
        WWIO.saveBuffer(byteBuffer, file);
        return file;
    }

    public static boolean isFileOutOfDate(URL uRL, long l) {
        if (uRL == null) {
            String string = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            URI uRI = uRL.toURI();
            if (uRI.isOpaque()) {
                return false;
            }
            File file = new File(uRI);
            return file.exists() && file.lastModified() < l;
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.logger().log(Level.SEVERE, "WWIO.ExceptionValidatingFileExpiration", uRL);
            return false;
        }
    }

    public static Proxy configureProxy() {
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyHost");
        if (string == null) {
            return null;
        }
        Proxy proxy = null;
        try {
            int n = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.UrlProxyPort");
            String string2 = Configuration.getStringValue("gov.nasa.worldwind.avkey.UrlProxyType");
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            if (string2.equals("Proxy.Type.Http")) {
                proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            } else if (string2.equals("Proxy.Type.SOCKS")) {
                proxy = new Proxy(Proxy.Type.SOCKS, inetSocketAddress);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.WARNING, Logging.getMessage("URLRetriever.ErrorConfiguringProxy", string), exception);
        }
        return proxy;
    }

    public static boolean isContentType(File file, String ... stringArray) {
        if (file == null || stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string == null) continue;
            String string2 = WWIO.makeSuffixForMimeType(string);
            String string3 = WWIO.getSuffix(file.getName());
            if (string3 == null || string2 == null) continue;
            if (!string3.startsWith(".")) {
                string3 = "." + string3;
            }
            if (!string3.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static String makeSuffixForMimeType(String string) {
        String string2;
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.ImageFomat");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        if (!string.contains("/") || string.endsWith("/")) {
            String string4 = Logging.getMessage("generic.InvalidImageFormat");
            Logging.logger().severe(string4);
            throw new IllegalStateException(string4);
        }
        int n = string.indexOf(";");
        if (n != -1) {
            string = string.substring(0, n);
        }
        if ((string2 = mimeTypeToSuffixMap.get(string)) == null) {
            string2 = string.substring(string.lastIndexOf("/") + 1);
        }
        string2 = string2.replaceFirst("bil32", "bil");
        string2 = string2.replaceFirst("bil16", "bil");
        return "." + string2;
    }

    public static String makeMimeTypeForSuffix(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FormatSuffixIsNull");
            Logging.logger().severe(string2);
            throw new IllegalStateException(string2);
        }
        if (string.startsWith(".")) {
            string = string.substring(1, string.length());
        }
        return suffixToMimeTypeMap.get(string.toLowerCase());
    }

    public static String makeDataTypeForMimeType(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.MimeTypeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (!string.contains("/") || string.endsWith("/")) {
            String string3 = Logging.getMessage("generic.InvalidImageFormat");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string.equals("application/bil32")) {
            return "gov.nasa.worldwind.avkey.Float32";
        }
        if (string.equals("application/bil16")) {
            return "gov.nasa.worldwind.avkey.Int16";
        }
        if (string.equals("application/bil")) {
            return "gov.nasa.worldwind.avkey.Int16";
        }
        if (string.equals("image/bil")) {
            return "gov.nasa.worldwind.avkey.Int16";
        }
        return null;
    }

    public static Object getFileOrResourceAsStream(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (Exception exception) {
                return exception;
            }
        }
        if (clazz == null) {
            clazz = WWIO.class;
        }
        try {
            return clazz.getResourceAsStream("/" + string);
        }
        catch (Exception exception) {
            return exception;
        }
    }

    public static InputStream getInputStreamFromString(String string) {
        return WWIO.getInputStreamFromString(string, DEFAULT_CHARACTER_ENCODING);
    }

    public static InputStream getInputStreamFromString(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        try {
            return new ByteArrayInputStream(string.getBytes(string2 != null ? string2 : DEFAULT_CHARACTER_ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WWRuntimeException(unsupportedEncodingException);
        }
    }

    public static InputStream getInputStreamFromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.ByteBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer.hasArray() && byteBuffer.limit() == byteBuffer.capacity()) {
            return new ByteArrayInputStream(byteBuffer.array());
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return new ByteArrayInputStream(byArray);
    }

    public static BufferedInputStream getBufferedInputStream(InputStream inputStream) {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return inputStream instanceof BufferedInputStream && BufferedInputStream.class.equals(inputStream.getClass()) ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static boolean isAncestorOf(File file, File file2) {
        File file3;
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.AncestorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (file3 = file; file3 != null && !file3.equals(file2); file3 = file3.getParentFile()) {
        }
        return file3 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            fileOutputStream = new FileOutputStream(file2);
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
            fileOutputStream.flush();
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            WWIO.closeStream(fileInputStream, file.getPath());
            WWIO.closeStream(fileOutputStream, file2.getPath());
            throw throwable;
        }
        WWIO.closeStream(fileInputStream, file.getPath());
        WWIO.closeStream(fileOutputStream, file2.getPath());
    }

    public static void copyDirectory(File file, File file2, boolean bl) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file2 == null) {
            String string = Logging.getMessage("nullValue.DestinationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.exists()) {
            String string = Logging.getMessage("generic.CannotCreateFile", file2);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file3 : fileArray) {
            if (file3 == null) continue;
            if (file3.isDirectory()) {
                arrayList2.add(file3);
                continue;
            }
            arrayList.add(file3);
        }
        for (File file4 : arrayList) {
            File file5 = new File(file2, file4.getName());
            WWIO.copyFile(file4, file5);
        }
        if (bl) {
            for (File file6 : arrayList2) {
                File file7 = new File(file2, file6.getName());
                WWIO.copyDirectory(file6, file7, bl);
            }
        }
    }

    public static void deleteDirectory(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            ArrayList<File> arrayList = new ArrayList<File>();
            ArrayList<File> arrayList2 = new ArrayList<File>();
            for (File file2 : fileArray) {
                if (file2 == null) continue;
                if (file2.isDirectory()) {
                    arrayList2.add(file2);
                    continue;
                }
                arrayList.add(file2);
            }
            for (File file3 : arrayList) {
                file3.delete();
            }
            for (File file4 : arrayList2) {
                WWIO.deleteDirectory(file4);
            }
        }
    }

    public static void closeStream(Object object, String string) {
        if (object == null) {
            return;
        }
        try {
            if (object instanceof Closeable) {
                ((Closeable)object).close();
            } else {
                String string2 = Logging.getMessage("WWIO.StreamTypeNotSupported", string != null ? string : "Unknown");
                Logging.logger().warning(string2);
            }
        }
        catch (IOException iOException) {
            String string3 = Logging.getMessage("generic.ExceptionClosingStream", iOException, string != null ? string : "Unknown");
            Logging.logger().severe(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
        }
        catch (IOException iOException) {
            String string;
            try {
                String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadFile", file.getPath());
                Logging.logger().log(Level.SEVERE, string2);
                string = null;
            }
            catch (Throwable throwable) {
                WWIO.closeStream(bufferedReader, file.getPath());
                throw throwable;
            }
            WWIO.closeStream(bufferedReader, file.getPath());
            return string;
        }
        WWIO.closeStream(bufferedReader, file.getPath());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(String string, File file) {
        if (file == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {
            try {
                String string4 = Logging.getMessage("generic.ExceptionAttemptingToWriteTo", file.getPath());
                Logging.logger().log(Level.SEVERE, string4);
            }
            catch (Throwable throwable) {
                WWIO.closeStream(bufferedWriter, file.getPath());
                throw throwable;
            }
            WWIO.closeStream(bufferedWriter, file.getPath());
        }
        WWIO.closeStream(bufferedWriter, file.getPath());
    }

    public static InputStream openFileOrResourceStream(String string, Class clazz) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WWIO.getFileOrResourceAsStream(string, clazz);
        if (object instanceof Exception) {
            String string3 = Logging.getMessage("generic.CannotOpenFile", string);
            throw new WWRuntimeException(string3, (Exception)object);
        }
        return (InputStream)object;
    }

    public static String byteBufferToString(ByteBuffer byteBuffer, String string) {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return Charset.forName(string != null ? string : DEFAULT_CHARACTER_ENCODING).decode(byteBuffer).toString();
    }

    public static String byteBufferToString(ByteBuffer byteBuffer, int n, String string) {
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 1) {
            String string3 = Logging.getMessage("generic.LengthIsInvalid", n);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        CharBuffer charBuffer = Charset.forName(string != null ? string : DEFAULT_CHARACTER_ENCODING).decode(byteBuffer);
        if (charBuffer.remaining() > n) {
            charBuffer = charBuffer.slice();
            charBuffer.limit(n);
        }
        return charBuffer.toString();
    }

    public static ByteBuffer stringToByteBuffer(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return ByteBuffer.wrap(string.getBytes(string2 != null ? string2 : DEFAULT_CHARACTER_ENCODING));
    }

    public static Reader openReader(Object object) throws IOException {
        Reader reader = null;
        if (object instanceof Reader) {
            reader = (Reader)object;
        } else if (object instanceof InputStream) {
            reader = new InputStreamReader((InputStream)object);
        } else if (object instanceof File) {
            reader = new FileReader((File)object);
        } else if (object instanceof URL) {
            reader = new InputStreamReader(((URL)object).openStream());
        } else if (object instanceof String) {
            reader = new StringReader((String)object);
        }
        return reader;
    }

    public static InputStream openStream(Object object) throws Exception {
        if (object == null || WWUtil.isEmpty(object)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof URL) {
            return ((URL)object).openStream();
        }
        if (object instanceof URI) {
            return ((URI)object).toURL().openStream();
        }
        if (object instanceof File) {
            Object object2 = WWIO.getFileOrResourceAsStream(((File)object).getPath(), null);
            if (object2 instanceof Exception) {
                throw (Exception)object2;
            }
            return (InputStream)object2;
        }
        if (!(object instanceof String)) {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", object.toString());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = (String)object;
        URL uRL = WWIO.makeURL(string);
        if (uRL != null) {
            return uRL.openStream();
        }
        Object object3 = WWIO.getFileOrResourceAsStream(string, null);
        if (object3 instanceof Exception) {
            throw (Exception)object3;
        }
        return (InputStream)object3;
    }

    public static String getSourcePath(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = null;
        if (object instanceof File) {
            string = ((File)object).getAbsolutePath();
        } else if (object instanceof URL) {
            string = ((URL)object).toExternalForm();
        } else if (object instanceof URI) {
            string = object.toString();
        } else if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    public static URL makeURL(String string) {
        try {
            return new URL(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL makeURL(Object object) {
        try {
            URI uRI = WWIO.makeURI(object);
            return uRI != null ? uRI.toURL() : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URL makeURL(Object object, String string) {
        try {
            URL uRL = WWIO.makeURL(object);
            if (uRL == null && !WWUtil.isEmpty(object.toString()) && !WWUtil.isEmpty(string)) {
                uRL = new URL(string, null, object.toString());
            }
            return uRL;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static URI makeURI(Object object) {
        try {
            if (object instanceof String) {
                return new URI((String)object);
            }
            if (object instanceof File) {
                return ((File)object).toURI();
            }
            if (object instanceof URL) {
                return ((URL)object).toURI();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] listChildFilenames(File file, FileFilter fileFilter) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null || string.length() == 0 || fileFilter != null && !fileFilter.accept(new File(file, string))) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] listDescendantFilenames(File file, FileFilter fileFilter) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWIO.listDescendantFilenames(file, fileFilter, true);
    }

    public static String[] listDescendantFilenames(File file, FileFilter fileFilter, boolean bl) {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (file.list() == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        WWIO.listDescendantFilenames(file, null, fileFilter, bl, arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static void listDescendantFilenames(File file, String string, FileFilter fileFilter, boolean bl, Collection<String> collection) {
        File file2 = string != null ? new File(file, string) : file;
        String[] stringArray = file2.list();
        if (stringArray == null) {
            return;
        }
        boolean bl2 = false;
        for (String string2 : stringArray) {
            if (string2 == null || string2.length() == 0 || fileFilter != null && !fileFilter.accept(new File(file2, string2))) continue;
            collection.add(WWIO.appendPathPart(string, string2));
            bl2 = true;
        }
        if (bl2 && !bl) {
            return;
        }
        for (String string2 : stringArray) {
            WWIO.listDescendantFilenames(file, WWIO.appendPathPart(string, string2), fileFilter, bl, collection);
        }
    }

    public static void skipBytes(InputStream inputStream, int n) throws IOException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = 0;
        while (n2 < n) {
            n2 = (int)((long)n2 + inputStream.skip(n - n2));
        }
    }

    public static String[] makeCachePathForURL(URL uRL) {
        String string = WWIO.replaceIllegalFileNameCharacters(uRL.getHost());
        String string2 = WWIO.replaceIllegalFileNameCharacters(uRL.getPath());
        return new String[]{string, string2};
    }

    public static void reverseFloatArray(int n, int n2, float[] fArray) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "pos=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "count=" + n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray == null) {
            String string = "nullValue.ArrayIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (fArray.length < n + n2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", "points.length < " + (n + n2));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = 0;
        int n4 = n2 >> 1;
        int n5 = n2 - 1;
        while (n3 < n4) {
            float f = fArray[n + n3];
            fArray[n + n3] = fArray[n + n5];
            fArray[n + n5] = f;
            ++n3;
            --n5;
        }
    }

    public static boolean isLocalJarAddress(URL uRL) {
        return uRL != null && uRL.getFile().startsWith("file:");
    }

    static {
        mimeTypeToSuffixMap.put("application/acad", "dwg");
        mimeTypeToSuffixMap.put("application/bil", "bil");
        mimeTypeToSuffixMap.put("application/bil16", "bil");
        mimeTypeToSuffixMap.put("application/bil32", "bil");
        mimeTypeToSuffixMap.put("application/dxf", "dxf");
        mimeTypeToSuffixMap.put("application/octet-stream", "bin");
        mimeTypeToSuffixMap.put("application/pdf", "pdf");
        mimeTypeToSuffixMap.put("application/rss+xml", "xml");
        mimeTypeToSuffixMap.put("application/rtf", "rtf");
        mimeTypeToSuffixMap.put("application/sla", "slt");
        mimeTypeToSuffixMap.put("application/vnd.google-earth.kml+xml", "kml");
        mimeTypeToSuffixMap.put("application/vnd.google-earth.kmz", "kmz");
        mimeTypeToSuffixMap.put("application/vnd.ogc.gml+xml", "gml");
        mimeTypeToSuffixMap.put("application/x-gzip", "gz");
        mimeTypeToSuffixMap.put("application/xml", "xml");
        mimeTypeToSuffixMap.put("application/zip", "zip");
        mimeTypeToSuffixMap.put("multipart/zip", "zip");
        mimeTypeToSuffixMap.put("multipart/x-gzip", "gzip");
        mimeTypeToSuffixMap.put("model/collada+xml", "dae");
        mimeTypeToSuffixMap.put("text/html", "html");
        mimeTypeToSuffixMap.put("text/plain", "txt");
        mimeTypeToSuffixMap.put("text/richtext", "rtx");
        mimeTypeToSuffixMap.put("text/tab-separated-values", "tsv");
        mimeTypeToSuffixMap.put("text/xml", "xml");
        mimeTypeToSuffixMap.put("image/bmp", "bmp");
        mimeTypeToSuffixMap.put("image/dds", "dds");
        mimeTypeToSuffixMap.put("image/geotiff", "gtif");
        mimeTypeToSuffixMap.put("image/gif", "gif");
        mimeTypeToSuffixMap.put("image/jp2", "jp2");
        mimeTypeToSuffixMap.put("image/jpeg", "jpg");
        mimeTypeToSuffixMap.put("image/jpg", "jpg");
        mimeTypeToSuffixMap.put("image/png", "png");
        mimeTypeToSuffixMap.put("image/svg+xml", "svg");
        mimeTypeToSuffixMap.put("image/tiff", "tif");
        mimeTypeToSuffixMap.put("image/x-imagewebserver-ecw", "ecw");
        mimeTypeToSuffixMap.put("image/x-mrsid", "sid");
        mimeTypeToSuffixMap.put("image/x-rgb", "rgb");
        mimeTypeToSuffixMap.put("video/mpeg", "mpg");
        mimeTypeToSuffixMap.put("video/quicktime", "mov");
        mimeTypeToSuffixMap.put("audio/x-aiff", "aif");
        mimeTypeToSuffixMap.put("audio/x-midi", "mid");
        mimeTypeToSuffixMap.put("audio/x-wav", "wav");
        mimeTypeToSuffixMap.put("world/x-vrml", "wrl");
        suffixToMimeTypeMap.put("aif", "audio/x-aiff");
        suffixToMimeTypeMap.put("aifc", "audio/x-aiff");
        suffixToMimeTypeMap.put("aiff", "audio/x-aiff");
        suffixToMimeTypeMap.put("bil", "application/bil");
        suffixToMimeTypeMap.put("bil16", "application/bil16");
        suffixToMimeTypeMap.put("bil32", "application/bil32");
        suffixToMimeTypeMap.put("bin", "application/octet-stream");
        suffixToMimeTypeMap.put("bmp", "image/bmp");
        suffixToMimeTypeMap.put("dds", "image/dds");
        suffixToMimeTypeMap.put("dwg", "application/acad");
        suffixToMimeTypeMap.put("dxf", "application/dxf");
        suffixToMimeTypeMap.put("ecw", "image/x-imagewebserver-ecw");
        suffixToMimeTypeMap.put("gif", "image/gif");
        suffixToMimeTypeMap.put("gml", "application/vnd.ogc.gml+xml");
        suffixToMimeTypeMap.put("gtif", "image/geotiff");
        suffixToMimeTypeMap.put("gz", "application/x-gzip");
        suffixToMimeTypeMap.put("gzip", "multipart/x-gzip");
        suffixToMimeTypeMap.put("htm", "text/html");
        suffixToMimeTypeMap.put("html", "text/html");
        suffixToMimeTypeMap.put("jp2", "image/jp2");
        suffixToMimeTypeMap.put("jpeg", "image/jpeg");
        suffixToMimeTypeMap.put("jpg", "image/jpeg");
        suffixToMimeTypeMap.put("kml", "application/vnd.google-earth.kml+xml");
        suffixToMimeTypeMap.put("kmz", "application/vnd.google-earth.kmz");
        suffixToMimeTypeMap.put("mid", "audio/x-midi");
        suffixToMimeTypeMap.put("midi", "audio/x-midi");
        suffixToMimeTypeMap.put("mov", "video/quicktime");
        suffixToMimeTypeMap.put("mp3", "audio/x-mpeg");
        suffixToMimeTypeMap.put("mpe", "video/mpeg");
        suffixToMimeTypeMap.put("mpeg", "video/mpeg");
        suffixToMimeTypeMap.put("mpg", "video/mpeg");
        suffixToMimeTypeMap.put("pdf", "application/pdf");
        suffixToMimeTypeMap.put("png", "image/png");
        suffixToMimeTypeMap.put("rgb", "image/x-rgb");
        suffixToMimeTypeMap.put("rtf", "application/rtf");
        suffixToMimeTypeMap.put("rtx", "text/richtext");
        suffixToMimeTypeMap.put("sid", "image/x-mrsid");
        suffixToMimeTypeMap.put("slt", "application/sla");
        suffixToMimeTypeMap.put("svg", "image/svg+xml");
        suffixToMimeTypeMap.put("tif", "image/tiff");
        suffixToMimeTypeMap.put("tiff", "image/tiff");
        suffixToMimeTypeMap.put("tsv", "text/tab-separated-values");
        suffixToMimeTypeMap.put("txt", "text/plain");
        suffixToMimeTypeMap.put("wav", "audio/x-wav");
        suffixToMimeTypeMap.put("wbmp", "image/vnd.wap.wbmp");
        suffixToMimeTypeMap.put("wrl", "world/x-vrml");
        suffixToMimeTypeMap.put("xml", "application/xml");
        suffixToMimeTypeMap.put("zip", "application/zip");
    }
}

