/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.tiff.GeotiffReader;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.BarycentricQuadrilateral;
import gov.nasa.worldwind.geom.BarycentricTriangle;
import gov.nasa.worldwind.geom.GeoQuad;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.TMCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.globes.Earth;
import gov.nasa.worldwind.util.GeographicImageInterpolator;
import gov.nasa.worldwind.util.ImageInterpolator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWMath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.JFileChooser;

public class ImageUtil {
    public static int NEAREST_NEIGHBOR_INTERPOLATION = 1;
    public static int BILINEAR_INTERPOLATION = 2;
    public static int IMAGE_TILE_SIZE = 1024;
    public static Color TRANSPARENT = new Color(0, 0, 0, 0);
    private static final int MAX_IMAGE_SIZE_TO_CONVERT = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getScaledCopy(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.CanvasIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static void warpImageWithTransform(BufferedImage bufferedImage, BufferedImage bufferedImage2, Matrix matrix) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.CanvasIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                Vec4 vec4 = new Vec4(j, i, 1.0).transformBy3(matrix);
                if (!(vec4.x >= 0.0) || !(vec4.y >= 0.0) || !(vec4.x <= (double)(n - 1)) || !(vec4.y <= (double)(n2 - 1))) continue;
                int n5 = (int)Math.floor(vec4.x);
                int n6 = (int)Math.ceil(vec4.x);
                double d = vec4.x - (double)n5;
                int n7 = (int)Math.floor(vec4.y);
                int n8 = (int)Math.ceil(vec4.y);
                double d2 = vec4.y - (double)n7;
                int n9 = ImageUtil.interpolateColor(d, d2, bufferedImage.getRGB(n5, n7), bufferedImage.getRGB(n6, n7), bufferedImage.getRGB(n5, n8), bufferedImage.getRGB(n6, n8));
                bufferedImage2.setRGB(j, i, n9);
            }
        }
    }

    public static Sector warpImageWithControlPoints(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(3, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (point2DArray.length >= 4 && latLonArray.length >= 4) {
            return ImageUtil.warpImageWithControlPoints4(bufferedImage, point2DArray, latLonArray, bufferedImage2);
        }
        return ImageUtil.warpImageWithControlPoints3(bufferedImage, point2DArray, latLonArray, bufferedImage2);
    }

    public static Sector warpImageWithControlPoints4(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(4, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Point2D[] point2DArray2 = new Point2D[3];
        LatLon[] latLonArray2 = new LatLon[3];
        ImageUtil.computeBestFittingControlPoints4(point2DArray, latLonArray, point2DArray2, latLonArray2);
        return ImageUtil.warpImageWithControlPoints3(bufferedImage, point2DArray2, latLonArray2, bufferedImage2);
    }

    public static Sector warpImageWithControlPoints3(BufferedImage bufferedImage, Point2D[] point2DArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = ImageUtil.validateControlPoints(3, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromImageToGeographic(point2DArray, latLonArray);
        List<LatLon> list = ImageUtil.computeImageCorners(bufferedImage.getWidth(), bufferedImage.getHeight(), matrix);
        Sector sector = Sector.boundingSector(list);
        if (Sector.isSector(list) && sector.isSameSector(list)) {
            ImageUtil.getScaledCopy(bufferedImage, bufferedImage2);
        } else {
            Matrix matrix2 = Matrix.IDENTITY;
            matrix2 = matrix2.multiply(Matrix.fromGeographicToImage(point2DArray, latLonArray));
            matrix2 = matrix2.multiply(Matrix.fromImageToGeographic(bufferedImage2.getWidth(), bufferedImage2.getHeight(), sector));
            ImageUtil.warpImageWithTransform(bufferedImage, bufferedImage2, matrix2);
        }
        return sector;
    }

    public static Sector warpImageWithWorldFile(BufferedImage bufferedImage, AVList aVList, BufferedImage bufferedImage2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.SourceImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (bufferedImage2 == null) {
            String string = Logging.getMessage("nullValue.DestinationImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.fromImageToGeographic(aVList);
        if (matrix == null) {
            String string = Logging.getMessage("WorldFile.UnrecognizedValues", "");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        List<LatLon> list = ImageUtil.computeImageCorners(bufferedImage.getWidth(), bufferedImage.getHeight(), matrix);
        Sector sector = Sector.boundingSector(list);
        if (Sector.isSector(list) && sector.isSameSector(list)) {
            ImageUtil.getScaledCopy(bufferedImage, bufferedImage2);
        } else {
            Matrix matrix2 = Matrix.IDENTITY;
            matrix2 = matrix2.multiply(Matrix.fromGeographicToImage(aVList));
            matrix2 = matrix2.multiply(Matrix.fromImageToGeographic(bufferedImage2.getWidth(), bufferedImage2.getHeight(), sector));
            ImageUtil.warpImageWithTransform(bufferedImage, bufferedImage2, matrix2);
        }
        return sector;
    }

    public static void computeBestFittingControlPoints4(Point2D[] point2DArray, LatLon[] latLonArray, Point2D[] point2DArray2, LatLon[] latLonArray2) {
        String string = ImageUtil.validateControlPoints(4, point2DArray, latLonArray);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        string = ImageUtil.validateControlPoints(3, point2DArray2, latLonArray2);
        if (string != null) {
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Point2D[] point2DArray3 = null;
        LatLon[] latLonArray3 = null;
        double d = Double.MAX_VALUE;
        for (int[] nArray : new int[][]{{0, 1, 2}, {0, 1, 3}, {1, 2, 3}, {0, 2, 3}}) {
            Point2D[] point2DArray4 = new Point2D[]{point2DArray[nArray[0]], point2DArray[nArray[1]], point2DArray[nArray[2]]};
            LatLon[] latLonArray4 = new LatLon[]{latLonArray[nArray[0]], latLonArray[nArray[1]], latLonArray[nArray[2]]};
            Matrix matrix = Matrix.fromImageToGeographic(point2DArray4, latLonArray4);
            double d2 = 0.0;
            for (int i = 0; i < 4; ++i) {
                Vec4 vec4 = new Vec4(point2DArray[i].getX(), point2DArray[i].getY(), 1.0).transformBy3(matrix);
                LatLon latLon = LatLon.fromDegrees(vec4.y, vec4.x);
                LatLon latLon2 = latLonArray[i].subtract(latLon);
                double d3 = latLon2.getLatitude().degrees * latLon2.getLatitude().degrees + latLon2.getLongitude().degrees * latLon2.getLongitude().degrees;
                d2 += d3;
            }
            if (!(d2 < d)) continue;
            point2DArray3 = point2DArray4;
            latLonArray3 = latLonArray4;
            d = d2;
        }
        if (point2DArray3 != null) {
            System.arraycopy(point2DArray3, 0, point2DArray2, 0, 3);
            System.arraycopy(latLonArray3, 0, latLonArray2, 0, 3);
        }
    }

    public static List<LatLon> computeImageCorners(int n, int n2, Matrix matrix) {
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("generic.InvalidImageSize", n, n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (matrix == null) {
            String string = Logging.getMessage("nullValue.MatrixIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Vec4 vec4 = new Vec4(0.0, n2, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(n, n2, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(n, 0.0, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        vec4 = new Vec4(0.0, 0.0, 1.0).transformBy3(matrix);
        arrayList.add(LatLon.fromDegrees(vec4.y, vec4.x));
        return arrayList;
    }

    private static String validateControlPoints(int n, Point2D[] point2DArray, LatLon[] latLonArray) {
        if (point2DArray == null) {
            return Logging.getMessage("nullValue.ImagePointsIsNull");
        }
        if (latLonArray == null) {
            return Logging.getMessage("nullValue.GeoPointsIsNull");
        }
        if (point2DArray.length < n) {
            return Logging.getMessage("generic.ArrayInvalidLength", point2DArray.length);
        }
        if (latLonArray.length < n) {
            return Logging.getMessage("generic.ArrayInvalidLength", point2DArray.length);
        }
        return null;
    }

    public static void mergeImage(Sector sector, Sector sector2, double d, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (sector == null || sector2 == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (bufferedImage2 == null || bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = Logging.getMessage("Util.AspectRatioInvalid", d);
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!sector.intersects(sector2)) {
            return;
        }
        int n = d >= 1.0 ? bufferedImage2.getWidth() : (int)Math.ceil((double)bufferedImage2.getWidth() * d);
        int n2 = d >= 1.0 ? (int)Math.ceil((double)bufferedImage2.getHeight() / d) : bufferedImage2.getHeight();
        double d2 = d >= 1.0 ? (1.0 - 1.0 / d) * (double)bufferedImage2.getHeight() : 0.0;
        double d3 = (double)n2 / (double)bufferedImage.getHeight() * sector2.getDeltaLat().divide(sector.getDeltaLat());
        double d4 = (double)n / (double)bufferedImage.getWidth() * sector2.getDeltaLon().divide(sector.getDeltaLon());
        double d5 = (double)n2 * (-sector2.getMaxLatitude().subtract((Angle)sector.getMaxLatitude()).degrees / sector.getDeltaLat().degrees);
        double d6 = (double)n * (sector2.getMinLongitude().subtract((Angle)sector.getMinLongitude()).degrees / sector.getDeltaLon().degrees);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.translate(d6, d5 + d2);
        graphics2D.scale(d4, d3);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
    }

    public static Sector positionImage(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        if (pointArray.length == 3) {
            return ImageUtil.positionImage3(bufferedImage, pointArray, latLonArray, bufferedImage2);
        }
        if (pointArray.length == 4) {
            return ImageUtil.positionImage4(bufferedImage, pointArray, latLonArray, bufferedImage2);
        }
        return null;
    }

    public static Sector positionImage3(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        BarycentricTriangle barycentricTriangle = new BarycentricTriangle(latLonArray[0], latLonArray[1], latLonArray[2]);
        BarycentricTriangle barycentricTriangle2 = new BarycentricTriangle(pointArray[0], pointArray[1], pointArray[2]);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        double[] dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(0.0, bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), 0.0, 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        dArray = barycentricTriangle2.getBarycentricCoords(new Vec4(0.0, 0.0, 0.0));
        arrayList.add(barycentricTriangle.getLocation(dArray));
        Sector sector = Sector.boundingSector(arrayList);
        GeoQuad geoQuad = new GeoQuad(sector.asList());
        double d = bufferedImage2.getWidth();
        double d2 = bufferedImage2.getHeight();
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            double d3 = (double)i / d2;
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                double d4 = (double)j / d;
                LatLon latLon = geoQuad.interpolate(1.0 - d3, d4);
                double[] dArray2 = barycentricTriangle.getBarycentricCoords(latLon);
                Vec4 vec4 = barycentricTriangle2.getPoint(dArray2);
                if (vec4.x < 0.0 || vec4.x >= (double)bufferedImage.getWidth() || vec4.y < 0.0 || vec4.y >= (double)bufferedImage.getHeight()) continue;
                int n = bufferedImage.getRGB((int)vec4.x, (int)vec4.y);
                bufferedImage2.setRGB(j, i, n);
            }
        }
        return sector;
    }

    public static Sector positionImage4(BufferedImage bufferedImage, Point[] pointArray, LatLon[] latLonArray, BufferedImage bufferedImage2) {
        BarycentricQuadrilateral barycentricQuadrilateral = new BarycentricQuadrilateral(latLonArray[0], latLonArray[1], latLonArray[2], latLonArray[3]);
        BarycentricQuadrilateral barycentricQuadrilateral2 = new BarycentricQuadrilateral(pointArray[0], pointArray[1], pointArray[2], pointArray[3]);
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        double[] dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(0.0, bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), bufferedImage.getHeight(), 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(bufferedImage.getWidth(), 0.0, 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        dArray = barycentricQuadrilateral2.getBarycentricCoords(new Vec4(0.0, 0.0, 0.0));
        arrayList.add(barycentricQuadrilateral.getLocation(dArray));
        Sector sector = Sector.boundingSector(arrayList);
        GeoQuad geoQuad = new GeoQuad(sector.asList());
        double d = bufferedImage2.getWidth();
        double d2 = bufferedImage2.getHeight();
        for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
            double d3 = (double)i / d2;
            for (int j = 0; j < bufferedImage2.getWidth(); ++j) {
                double d4 = (double)j / d;
                LatLon latLon = geoQuad.interpolate(1.0 - d3, d4);
                double[] dArray2 = barycentricQuadrilateral.getBarycentricCoords(latLon);
                Vec4 vec4 = barycentricQuadrilateral2.getPoint(dArray2);
                if (vec4.x < 0.0 || vec4.x >= (double)bufferedImage.getWidth() || vec4.y < 0.0 || vec4.y >= (double)bufferedImage.getHeight()) continue;
                int n = bufferedImage.getRGB((int)vec4.x, (int)vec4.y);
                bufferedImage2.setRGB(j, i, n);
            }
        }
        return sector;
    }

    public static BufferedImage[] buildMipmaps(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "maxLevel < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[1 + n2];
        if (bufferedImage.getType() == n) {
            bufferedImageArray[0] = bufferedImage;
        } else {
            bufferedImageArray[0] = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
            ImageUtil.getScaledCopy(bufferedImage, bufferedImageArray[0]);
        }
        for (int i = 1; i <= n2; ++i) {
            int n3 = Math.max(bufferedImage.getWidth() >> i, 1);
            int n4 = Math.max(bufferedImage.getHeight() >> i, 1);
            bufferedImageArray[i] = new BufferedImage(n3, n4, n);
            ImageUtil.getScaledCopy(bufferedImageArray[i - 1], bufferedImageArray[i]);
        }
        return bufferedImageArray;
    }

    public static BufferedImage[] buildMipmaps(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = ImageUtil.getMipmapType(bufferedImage.getType());
        int n2 = ImageUtil.getMaxMipmapLevel(bufferedImage.getWidth(), bufferedImage.getHeight());
        return ImageUtil.buildMipmaps(bufferedImage, n, n2);
    }

    public static int getMipmapType(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    public static int getMaxMipmapLevel(int n, int n2) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "height < 1");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n3 = (int)WWMath.logBase2(n);
        int n4 = (int)WWMath.logBase2(n2);
        return Math.max(n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage convertToPowerOfTwoImage(BufferedImage bufferedImage, boolean bl) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (WWMath.isPowerOfTwo(bufferedImage.getWidth()) && WWMath.isPowerOfTwo(bufferedImage.getHeight())) {
            return bufferedImage;
        }
        int n = WWMath.powerOfTwoCeiling(bufferedImage.getWidth());
        int n2 = WWMath.powerOfTwoCeiling(bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getColorModel().hasAlpha() ? 6 : 5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            if (bl) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(bufferedImage, 0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null);
            } else {
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static long computeSizeInBytes(BufferedImage bufferedImage) {
        DataBuffer dataBuffer;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (writableRaster != null && (dataBuffer = writableRaster.getDataBuffer()) != null) {
            l = ImageUtil.computeSizeOfDataBuffer(dataBuffer);
        }
        return l;
    }

    private static long computeSizeOfDataBuffer(DataBuffer dataBuffer) {
        return (long)dataBuffer.getSize() * ImageUtil.computeSizeOfBufferDataType(dataBuffer.getDataType());
    }

    private static long computeSizeOfBufferDataType(int n) {
        switch (n) {
            case 0: {
                return 1L;
            }
            case 5: {
                return 8L;
            }
            case 4: {
                return 4L;
            }
            case 3: {
                return 4L;
            }
            case 1: 
            case 2: {
                return 2L;
            }
        }
        return 0L;
    }

    public static AVList openSpatialImage(File file, int n) throws IOException {
        BufferedImage bufferedImage;
        File[] fileArray;
        AVListImpl aVListImpl = new AVListImpl();
        if (file.getName().toLowerCase().endsWith(".tiff") || file.getName().toLowerCase().endsWith(".tif")) {
            fileArray = new GeotiffReader(file);
            int n2 = 0;
            bufferedImage = fileArray.read(n2);
            if (fileArray.isGeotiff(n2)) {
                return ImageUtil.handleGeotiff(bufferedImage, (GeotiffReader)fileArray, n2, n);
            }
        }
        if ((bufferedImage = ImageIO.read(file)) == null) {
            fileArray = Logging.getMessage("generic.ImageReadFailed", file);
            Logging.logger().severe((String)fileArray);
            throw new WWRuntimeException((String)fileArray);
        }
        fileArray = WorldFile.getWorldFiles(file.getAbsoluteFile());
        if (fileArray == null || fileArray.length == 0) {
            String string = Logging.getMessage("WorldFile.WorldFileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
        WorldFile.decodeWorldFiles(fileArray, aVListImpl);
        Sector sector = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            ImageUtil.reprojectUtmToGeographic(aVListImpl, n);
        }
        if ((sector = (Sector)aVListImpl.getValue("gov.nasa.worldwind.avKey.Sector")) == null) {
            String string = "Problem generating bounding sector for the image";
            throw new WWRuntimeException(string);
        }
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return aVListImpl;
    }

    public static AVList openSpatialImage(File file) throws IOException {
        return ImageUtil.openSpatialImage(file, NEAREST_NEIGHBOR_INTERPOLATION);
    }

    public static AVList readGeoKeys(GeotiffReader geotiffReader, int n, AVList aVList) throws IOException {
        if (null == aVList) {
            aVList = new AVListImpl();
        }
        if (null == geotiffReader) {
            return aVList;
        }
        return geotiffReader.copyMetadataTo(n, aVList);
    }

    private static AVList handleGeotiff(BufferedImage bufferedImage, GeotiffReader geotiffReader, int n, int n2) throws IOException {
        AVListImpl aVListImpl = new AVListImpl();
        if (null != bufferedImage) {
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage);
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Width", bufferedImage.getWidth());
            aVListImpl.setValue("gov.nasa.worldwind.avkey.Height", bufferedImage.getHeight());
        }
        ImageUtil.readGeoKeys(geotiffReader, n, aVListImpl);
        if ("gov.nasa.worldwind.avkey.CoordinateSystem.Projected".equals(aVListImpl.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"))) {
            ImageUtil.reprojectUtmToGeographic(aVListImpl, n2);
        }
        return aVListImpl;
    }

    public static Sector calcBoundingBoxForUTM(AVList aVList) throws IOException {
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Width")) {
            String string = Logging.getMessage("Geom.WidthInvalid");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Height")) {
            String string = Logging.getMessage("Geom.HeightInvalid");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.worldFile.XPixelSize")) {
            String string = Logging.getMessage("WorldFile.NoPixelSizeSpecified", "X");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.worldFile.YPixelSize")) {
            String string = Logging.getMessage("WorldFile.NoPixelSizeSpecified", "Y");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.worldFile.XLocation")) {
            String string = Logging.getMessage("WorldFile.NoLocationSpecified", "X");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.worldFile.YLocation")) {
            String string = Logging.getMessage("WorldFile.NoLocationSpecified", "Y");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Projection.Zone")) {
            String string = Logging.getMessage("generic.ZoneIsMissing");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.Projection.Hemisphere")) {
            String string = Logging.getMessage("generic.HemisphereIsMissing");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        double d = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.XPixelSize");
        double d2 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.YPixelSize");
        double d3 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.XLocation");
        double d4 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.YLocation");
        Integer n3 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Projection.Zone");
        String string = (String)aVList.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere");
        UTMCoord uTMCoord = UTMCoord.fromUTM(n3, string, d3, d4);
        UTMCoord uTMCoord2 = UTMCoord.fromUTM(n3, string, uTMCoord.getEasting() - d * 0.5, uTMCoord.getNorthing() - d2 * 0.5);
        UTMCoord uTMCoord3 = UTMCoord.fromUTM(n3, string, uTMCoord2.getEasting() + (double)n * d, uTMCoord2.getNorthing() + (double)n2 * d2);
        UTMCoord uTMCoord4 = UTMCoord.fromUTM(n3, uTMCoord.getHemisphere(), uTMCoord2.getEasting(), uTMCoord3.getNorthing());
        UTMCoord uTMCoord5 = UTMCoord.fromUTM(n3, uTMCoord.getHemisphere(), uTMCoord3.getEasting(), uTMCoord2.getNorthing());
        Angle angle = Angle.max(uTMCoord5.getLongitude(), uTMCoord3.getLongitude());
        Angle angle2 = Angle.min(uTMCoord4.getLongitude(), uTMCoord2.getLongitude());
        Angle angle3 = Angle.max(uTMCoord5.getLatitude(), uTMCoord2.getLatitude());
        Angle angle4 = Angle.min(uTMCoord3.getLatitude(), uTMCoord4.getLatitude());
        Sector sector = new Sector(angle4, angle3, angle2, angle);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        aVList.setValue("gov.nasa.worldwind.avkey.Origin", new LatLon(uTMCoord.getLatitude(), uTMCoord.getLongitude()));
        return sector;
    }

    public static void reprojectUtmToGeographic(AVList aVList, int n) {
        double d = 500000.0;
        double d2 = 0.0;
        double d3 = 0.9996;
        Earth earth = new Earth();
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        BufferedImage bufferedImage = (BufferedImage)aVList.getValue("gov.nasa.worldwind.avkey.Image");
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = bufferedImage.getColorModel() != null && bufferedImage.getColorModel() instanceof IndexColorModel ? new BufferedImage(n2, n3, 2, (IndexColorModel)bufferedImage.getColorModel()) : new BufferedImage(n2, n3, 2);
        double d4 = 0.0;
        double d5 = 0.0;
        Object object = aVList.getValue("gov.nasa.worldwind.worldFile.XPixelSize");
        if (object != null && object instanceof Double) {
            d4 = (Double)object;
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.worldFile.YPixelSize")) != null && object instanceof Double) {
            d5 = (Double)object;
        }
        double d6 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.XLocation");
        double d7 = (Double)aVList.getValue("gov.nasa.worldwind.worldFile.YLocation");
        Integer n4 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Projection.Zone");
        String string = (String)aVList.getValue("gov.nasa.worldwind.avkey.Projection.Hemisphere");
        UTMCoord uTMCoord = UTMCoord.fromUTM(n4, string, d6, d7);
        UTMCoord uTMCoord2 = UTMCoord.fromUTM(n4, string, uTMCoord.getEasting() - d4 * 0.5, uTMCoord.getNorthing() - d5 * 0.5);
        UTMCoord uTMCoord3 = UTMCoord.fromUTM(n4, string, uTMCoord2.getEasting() + (double)n2 * d4, uTMCoord2.getNorthing() + (double)n3 * d5);
        UTMCoord uTMCoord4 = UTMCoord.fromUTM(n4, uTMCoord.getHemisphere(), uTMCoord2.getEasting(), uTMCoord3.getNorthing());
        UTMCoord uTMCoord5 = UTMCoord.fromUTM(n4, uTMCoord.getHemisphere(), uTMCoord3.getEasting(), uTMCoord2.getNorthing());
        Angle angle = Angle.max(uTMCoord5.getLongitude(), uTMCoord3.getLongitude());
        Angle angle2 = Angle.min(uTMCoord4.getLongitude(), uTMCoord2.getLongitude());
        Angle angle3 = Angle.max(uTMCoord5.getLatitude(), uTMCoord2.getLatitude());
        Angle angle4 = Angle.min(uTMCoord3.getLatitude(), uTMCoord4.getLatitude());
        Sector sector = new Sector(angle4, angle3, angle2, angle);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        double d8 = (angle4.getDegrees() - angle3.getDegrees()) / (double)n3;
        double d9 = (angle.getDegrees() - angle2.getDegrees()) / (double)n2;
        double d10 = sector.getMaxLatitude().getDegrees() + d8 * 0.5;
        double d11 = sector.getMinLongitude().getDegrees() + d9 * 0.5;
        TMCoord tMCoord = TMCoord.fromLatLon(uTMCoord2.getLatitude(), uTMCoord2.getLongitude(), earth, null, null, Angle.fromDegrees(0.0), uTMCoord2.getCentralMeridian(), d, d2, d3);
        double d12 = tMCoord.getNorthing() + d5 * 0.5;
        double d13 = tMCoord.getEasting() + d4 * 0.5;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d14 = d10 + (double)i * d8;
                double d15 = d11 + (double)j * d9;
                TMCoord tMCoord2 = TMCoord.fromLatLon(Angle.fromDegreesLatitude(d14), Angle.fromDegreesLongitude(d15), earth, null, null, Angle.fromDegrees(0.0), uTMCoord2.getCentralMeridian(), d, d2, d3);
                double d16 = tMCoord2.getEasting() - d13;
                double d17 = d12 - tMCoord2.getNorthing();
                long l = Math.round(d16 / Math.abs(d4));
                long l2 = Math.round(d17 / Math.abs(d5));
                if (n == BILINEAR_INTERPOLATION) {
                    double d18 = d16 / Math.abs(d4);
                    double d19 = d17 / Math.abs(d5);
                    int n5 = (int)Math.floor(d18);
                    int n6 = (int)Math.floor(d19);
                    double d20 = d18 - (double)n5;
                    double d21 = d19 - (double)n6;
                    if (n5 <= 0 || n6 <= 0) continue;
                    if (n5 < n2 - 1 && n6 < n3 - 1) {
                        int n7 = bufferedImage.getRGB(n5, n6);
                        int n8 = bufferedImage.getRGB(n5 + 1, n6);
                        int n9 = bufferedImage.getRGB(n5, n6 + 1);
                        int n10 = bufferedImage.getRGB(n5 + 1, n6 + 1);
                        int n11 = ImageUtil.interpolateColor(d20, d21, n7, n8, n9, n10);
                        bufferedImage2.setRGB(j, i, Math.round(n11));
                        continue;
                    }
                    bufferedImage2.setRGB(j, i, 0);
                    continue;
                }
                if (l <= 0L || l2 <= 0L) continue;
                if (l < (long)n2 && l2 < (long)n3) {
                    bufferedImage2.setRGB(j, i, bufferedImage.getRGB(Long.valueOf(l).intValue(), Long.valueOf(l2).intValue()));
                    continue;
                }
                bufferedImage2.setRGB(j, i, 0);
            }
        }
        aVList.setValue("gov.nasa.worldwind.avkey.Image", bufferedImage2);
    }

    public static int interpolateColor(double d, double d2, int n, int n2, int n3, int n4) {
        int n5 = n >> 24 & 0xFF;
        int n6 = n >> 16 & 0xFF;
        int n7 = n >> 8 & 0xFF;
        int n8 = n & 0xFF;
        int n9 = n2 >> 24 & 0xFF;
        int n10 = n2 >> 16 & 0xFF;
        int n11 = n2 >> 8 & 0xFF;
        int n12 = n2 & 0xFF;
        int n13 = n3 >> 24 & 0xFF;
        int n14 = n3 >> 16 & 0xFF;
        int n15 = n3 >> 8 & 0xFF;
        int n16 = n3 & 0xFF;
        int n17 = n4 >> 24 & 0xFF;
        int n18 = n4 >> 16 & 0xFF;
        int n19 = n4 >> 8 & 0xFF;
        int n20 = n4 & 0xFF;
        double d3 = 1.0 - d;
        double d4 = 1.0 - d2;
        double d5 = d3 * (double)n5 + d * (double)n9;
        double d6 = d3 * (double)n13 + d * (double)n17;
        int n21 = (int)(d4 * d5 + d2 * d6);
        n21 <<= 24;
        d5 = d3 * (double)n6 + d * (double)n10;
        d6 = d3 * (double)n14 + d * (double)n18;
        int n22 = (int)(d4 * d5 + d2 * d6);
        n22 <<= 16;
        d5 = d3 * (double)n7 + d * (double)n11;
        d6 = d3 * (double)n15 + d * (double)n19;
        int n23 = (int)(d4 * d5 + d2 * d6);
        d5 = d3 * (double)n8 + d * (double)n12;
        d6 = d3 * (double)n16 + d * (double)n20;
        int n24 = (int)(d4 * d5 + d2 * d6);
        return n21 | n22 | (n23 <<= 8) | n24;
    }

    public static AlignedImage alignImage(BufferedImage bufferedImage, float[] fArray, float[] fArray2) throws InterruptedException {
        return ImageUtil.alignImage(bufferedImage, fArray, fArray2, null, null);
    }

    public static AlignedImage alignImage(BufferedImage bufferedImage, float[] fArray, float[] fArray2, Sector sector, Dimension dimension) throws InterruptedException {
        double d;
        double d2;
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            String string = Logging.getMessage("ImageUtil.FieldArrayInvalid");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("ImageUtil.EmptyImage");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (fArray2.length < n * n2 || fArray.length < n * n2) {
            String string = Logging.getMessage("ImageUtil.FieldArrayTooShort");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GeographicImageInterpolator geographicImageInterpolator = new GeographicImageInterpolator(new Dimension(n, n2), fArray2, fArray, 10, 1);
        if (sector == null) {
            sector = geographicImageInterpolator.getSector();
        }
        if (dimension == null) {
            double d3 = Math.max(n, n2);
            d2 = Math.max(sector.getDeltaLonDegrees(), sector.getDeltaLatDegrees());
            d = d3 / d2;
            dimension = new Dimension((int)Math.round(d * sector.getDeltaLonDegrees()), (int)Math.round(d * sector.getDeltaLatDegrees()));
        }
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        int[] nArray2 = new int[dimension.width * dimension.height];
        d2 = sector.getDeltaLonDegrees() / (double)dimension.width;
        d = sector.getDeltaLatDegrees() / (double)dimension.height;
        for (int i = 0; i < dimension.height; ++i) {
            Thread.sleep(0L);
            float f = (float)(sector.getMaxLatitude().degrees - (double)i * d - d2 / 2.0);
            for (int j = 0; j < dimension.width; ++j) {
                int n3;
                float f2 = (float)(sector.getMinLongitude().degrees + (double)j * d2 + d / 2.0);
                ImageInterpolator.ContainingCell containingCell = geographicImageInterpolator.findContainingCell(f2, f);
                if (containingCell == null) continue;
                nArray2[i * dimension.width + j] = n3 = ImageUtil.interpolateColor(containingCell.uv[0], containingCell.uv[1], nArray[containingCell.fieldIndices[0]], nArray[containingCell.fieldIndices[1]], nArray[containingCell.fieldIndices[3]], nArray[containingCell.fieldIndices[2]]);
            }
        }
        nArray = null;
        geographicImageInterpolator = null;
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 6);
        bufferedImage2.setRGB(0, 0, dimension.width, dimension.height, nArray2, 0, dimension.width);
        return new AlignedImage(bufferedImage2, sector);
    }

    public static void alignImageDump(BufferedImage bufferedImage, float[] fArray, float[] fArray2) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showSaveDialog(null);
            if (n != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (!file.getName().endsWith(".png")) {
                file = new File(file.getPath() + ".png");
            }
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            File file2 = new File(WWIO.replaceSuffix(file.getPath(), ".lats.dat"));
            File file3 = new File(WWIO.replaceSuffix(file.getPath(), ".lons.dat"));
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
            DataOutputStream dataOutputStream2 = new DataOutputStream(new FileOutputStream(file3));
            for (int i = 0; i < fArray.length; ++i) {
                dataOutputStream.writeFloat(fArray[i]);
                dataOutputStream2.writeFloat(fArray2[i]);
            }
            dataOutputStream.flush();
            dataOutputStream2.flush();
            dataOutputStream.close();
            dataOutputStream2.close();
            System.out.println("FILES SAVED");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (GraphicsEnvironment.isHeadless()) {
            return bufferedImage;
        }
        if (!ImageUtil.isCompatibleImage(bufferedImage) && bufferedImage.getWidth() <= 4096 && bufferedImage.getHeight() <= 4096) {
            BufferedImage bufferedImage2 = ImageUtil.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
        return bufferedImage;
    }

    public static BufferedImage createCompatibleImage(int n, int n2, int n3) {
        if (n < 1) {
            String string = Logging.getMessage("generic.InvalidWidth", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.InvalidHeight", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new BufferedImage(n, n2, n3 == 1 ? 1 : 2);
    }

    protected static boolean isCompatibleImage(BufferedImage bufferedImage) {
        if (GraphicsEnvironment.isHeadless()) {
            return false;
        }
        GraphicsConfiguration graphicsConfiguration = ImageUtil.getDefaultGraphicsConfiguration();
        ColorModel colorModel = graphicsConfiguration.getColorModel(bufferedImage.getTransparency());
        return bufferedImage.getColorModel().equals(colorModel);
    }

    protected static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    public static BufferedImage mapTransparencyColors(ByteBuffer byteBuffer, int[] nArray) {
        try {
            InputStream inputStream = WWIO.getInputStreamFromByteBuffer(byteBuffer);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return ImageUtil.mapTransparencyColors(bufferedImage, nArray);
        }
        catch (IOException iOException) {
            Logging.logger().finest(iOException.getMessage());
            return null;
        }
    }

    public static BufferedImage mapTransparencyColors(BufferedImage bufferedImage, int[] nArray) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (nArray == null) {
            String string = Logging.getMessage("nullValue.ColorArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("ImageUtil.EmptyImage");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int[] nArray2 = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
        for (int i = 0; i < n2; ++i) {
            block1: for (int j = 0; j < n; ++j) {
                int n3 = i * n + j;
                for (int n4 : nArray) {
                    if (nArray2[n3] != n4) continue;
                    nArray3[n3] = 0;
                    continue block1;
                }
            }
        }
        nArray2 = null;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 6);
        bufferedImage2.setRGB(0, 0, n, n2, nArray3, 0, n);
        return bufferedImage2;
    }

    public static BufferedImage mapColors(ByteBuffer byteBuffer, int n, int n2) {
        try {
            InputStream inputStream = WWIO.getInputStreamFromByteBuffer(byteBuffer);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return ImageUtil.mapColors(bufferedImage, new int[]{n}, new int[]{n2});
        }
        catch (IOException iOException) {
            Logging.logger().finest(iOException.getMessage());
            return null;
        }
    }

    public static BufferedImage mapColors(BufferedImage bufferedImage, int[] nArray, int[] nArray2) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (nArray == null || nArray2 == null) {
            String string = Logging.getMessage("nullValue.ColorArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n < 1 || n2 < 1) {
            String string = Logging.getMessage("ImageUtil.EmptyImage");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        int[] nArray3 = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
        int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i * n + j;
                for (int n4 : nArray) {
                    if (nArray3[n3] != nArray[n4]) continue;
                    nArray4[n3] = nArray2[n4];
                }
            }
        }
        nArray3 = null;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 6);
        bufferedImage2.setRGB(0, 0, n, n2, nArray4, 0, n);
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer asJPEG(DataRaster dataRaster) {
        BufferedImage bufferedImage;
        ByteBuffer byteBuffer = null;
        if (null == dataRaster) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRaster instanceof BufferedImageRaster) {
            bufferedImage = ((BufferedImageRaster)dataRaster).getBufferedImage();
        } else if (dataRaster instanceof BufferWrapperRaster) {
            bufferedImage = ImageUtil.visualize((BufferWrapperRaster)dataRaster);
        } else {
            String string = Logging.getMessage("generic.UnexpectedRasterType", dataRaster.getClass().getName());
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = null;
        if (null == bufferedImage) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
            ColorModel colorModel = bufferedImage.getColorModel();
            if (colorModel instanceof ComponentColorModel) {
                ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
                if (null != imageWriter) {
                    ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                    imageWriteParam.setSourceBands(new int[]{0, 1, 2});
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                    imageWriteParam.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(1, 1)));
                    imageWriter.setOutput(memoryCacheImageOutputStream);
                    imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                    imageWriter.dispose();
                }
            } else {
                ImageIO.write((RenderedImage)bufferedImage, "jpeg", memoryCacheImageOutputStream);
            }
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                Logging.logger().log(Level.SEVERE, throwable.getMessage(), throwable);
            }
            catch (Throwable throwable2) {
                ImageUtil.close(memoryCacheImageOutputStream);
                throw throwable2;
            }
            ImageUtil.close(memoryCacheImageOutputStream);
        }
        ImageUtil.close(memoryCacheImageOutputStream);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer asPNG(DataRaster dataRaster) {
        BufferedImage bufferedImage;
        ByteBuffer byteBuffer = null;
        if (null == dataRaster) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRaster instanceof BufferedImageRaster) {
            bufferedImage = ((BufferedImageRaster)dataRaster).getBufferedImage();
        } else if (dataRaster instanceof BufferWrapperRaster) {
            bufferedImage = ImageUtil.visualize((BufferWrapperRaster)dataRaster);
        } else {
            String string = Logging.getMessage("generic.UnexpectedRasterType", dataRaster.getClass().getName());
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = null;
        if (null == bufferedImage) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
            ImageIO.write((RenderedImage)bufferedImage, "png", memoryCacheImageOutputStream);
            byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                Logging.logger().log(Level.SEVERE, throwable.getMessage(), throwable);
            }
            catch (Throwable throwable2) {
                ImageUtil.close(memoryCacheImageOutputStream);
                throw throwable2;
            }
            ImageUtil.close(memoryCacheImageOutputStream);
        }
        ImageUtil.close(memoryCacheImageOutputStream);
        return byteBuffer;
    }

    protected static void close(ImageOutputStream imageOutputStream) {
        if (null != imageOutputStream) {
            try {
                imageOutputStream.close();
            }
            catch (Throwable throwable) {
                Logging.logger().log(Level.SEVERE, throwable.getMessage(), throwable);
            }
        }
    }

    public static BufferedImage visualize(BufferWrapperRaster bufferWrapperRaster) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        if (null == bufferWrapperRaster) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        double d = AVListImpl.getDoubleValue(bufferWrapperRaster, "gov.nasa.worldwind.avkey.MissingDataFlag", -32768.0);
        int n = 0;
        Double d2 = (Double)bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.ElevationMinKey");
        Double d3 = (Double)bufferWrapperRaster.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey");
        double d4 = null != d2 && d2 >= -11000.0 ? d2 : 0.0;
        double d5 = null != d3 && d2 <= 8500.0 ? d3 : 8500.0;
        int n2 = bufferWrapperRaster.getWidth();
        int n3 = bufferWrapperRaster.getHeight();
        int n4 = n2 * n3;
        short[][] sArrayArray = new short[][]{new short[n4], new short[n4]};
        int n5 = 0;
        boolean bl = false;
        double d6 = d5 != d4 ? Math.abs(65534.0 / (d5 - d4)) : 0.0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d7 = bufferWrapperRaster.getDoubleAtPosition(i, j);
                if (d7 == d || d7 == 0.0 || d7 < d4 || d7 > d5) {
                    sArrayArray[0][n5] = (short)(0xFFFF & n);
                    sArrayArray[1][n5] = 0;
                    bl = true;
                } else {
                    sArrayArray[0][n5] = (short)(0xFFFF & (int)((d7 - d4) * d6));
                    sArrayArray[1][n5] = -1;
                }
                ++n5;
            }
        }
        if (bl) {
            int[] nArray4 = new int[2];
            nArray4[0] = 0;
            nArray3 = nArray4;
            nArray4[1] = 1;
        } else {
            int[] nArray5 = new int[1];
            nArray3 = nArray5;
            nArray5[0] = 0;
        }
        int[] nArray6 = nArray3;
        if (bl) {
            int[] nArray7 = new int[2];
            nArray7[0] = 0;
            nArray2 = nArray7;
            nArray7[1] = 0;
        } else {
            int[] nArray8 = new int[1];
            nArray2 = nArray8;
            nArray8[0] = 0;
        }
        int[] nArray9 = nArray2;
        if (bl) {
            int[] nArray10 = new int[2];
            nArray10[0] = 16;
            nArray = nArray10;
            nArray10[1] = 8;
        } else {
            int[] nArray11 = new int[1];
            nArray = nArray11;
            nArray11[0] = 16;
        }
        int[] nArray12 = nArray;
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArrayArray, n4);
        BandedSampleModel bandedSampleModel = new BandedSampleModel(1, n2, n3, n2, nArray6, nArray9);
        WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferUShort, null);
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray12, bl, false, bl ? 3 : 1, 1);
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    public static class AlignedImage {
        public final Sector sector;
        public final BufferedImage image;

        public AlignedImage(BufferedImage bufferedImage, Sector sector) {
            this.image = bufferedImage;
            this.sector = sector;
        }
    }
}

