/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;

public class ElevationsUtil {
    public static final double DTED_DEFAULT_MISSING_SIGNAL = -32767.0;
    public static final double SRTM_DEFAULT_MISSING_SIGNAL = -32768.0;
    public static final double DEM_DEFAULT_MISSING_SIGNAL = -9999.0;
    protected static final double[] knownMissingSignals = new double[]{-32767.0, -32768.0, -9999.0};

    public static boolean isKnownMissingSignal(Double d) {
        if (null != d) {
            for (double d2 : knownMissingSignals) {
                if (d != d2) continue;
                return true;
            }
        }
        return false;
    }

    public static void rectify(ByteBufferRaster byteBufferRaster) throws IllegalArgumentException {
        if (null == byteBufferRaster) {
            String string = Logging.getMessage("nullValue.RasterIsNull");
            Logging.logger().finest(string);
            throw new IllegalArgumentException(string);
        }
        int n = byteBufferRaster.getWidth();
        int n2 = byteBufferRaster.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        double[] dArray = byteBufferRaster.getExtremes();
        if (null == dArray) {
            return;
        }
        Double d = dArray[0];
        Double d2 = dArray[1];
        Double d3 = AVListImpl.getDoubleValue(byteBufferRaster, "gov.nasa.worldwind.avkey.MissingDataFlag", null);
        if (ElevationsUtil.isKnownMissingSignal(d) || d3 != null && d3.equals(d)) {
            d3 = d;
            byteBufferRaster.setTransparentValue(d3);
            dArray = byteBufferRaster.getExtremes();
            if (null != dArray) {
                d = dArray[0];
                d2 = dArray[1];
            }
        }
        BufferWrapper bufferWrapper = byteBufferRaster.getBuffer();
        double[] dArray2 = new double[n];
        boolean bl = false;
        double d4 = 1.0;
        if (byteBufferRaster.hasKey("gov.nasa.worldwind.avkey.ElevationUnit")) {
            String string = byteBufferRaster.getStringValue("gov.nasa.worldwind.avkey.ElevationUnit");
            if ("gov.nasa.worldwind.avkey.Unit.Meter".equalsIgnoreCase(string)) {
                bl = false;
            } else if ("gov.nasa.worldwind.avkey.Unit.Foot".equalsIgnoreCase(string)) {
                bl = true;
                d4 = WWMath.convertFeetToMeters(1.0);
                d = WWMath.convertFeetToMeters(d);
                d2 = WWMath.convertFeetToMeters(d2);
                byteBufferRaster.setValue("gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.Unit.Meter");
            } else {
                bl = false;
                String string2 = Logging.getMessage("generic.UnrecognizedElevationUnit", string);
                Logging.logger().warning(string2);
            }
        }
        boolean bl2 = false;
        for (int i = 0; i < n2; ++i) {
            bufferWrapper.getDouble(i * n, dArray2, 0, n);
            boolean bl3 = false;
            for (int j = 0; j < n; ++j) {
                double d5 = dArray2[j];
                if (null != d3 && d5 == d3) {
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    bl3 = true;
                    dArray2[j] = d5 *= d4;
                }
                if (!(d5 < d) && !(d5 > d2)) continue;
                bl2 = true;
                if (null == d3) continue;
                dArray2[j] = d3;
                bl3 = true;
            }
            if (!bl3) continue;
            bufferWrapper.putDouble(i * n, dArray2, 0, n);
        }
        if (bl2) {
            if (d3 != null) {
                byteBufferRaster.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", d3);
            }
        } else {
            byteBufferRaster.removeKey("gov.nasa.worldwind.avkey.MissingDataFlag");
        }
        byteBufferRaster.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d);
        byteBufferRaster.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d2);
    }
}

