/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.tracks;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.TrackPoint;

public class TrackPointImpl
implements TrackPoint {
    private Position position;
    private String time;

    public TrackPointImpl(Angle angle, Angle angle2, double d, String string) {
        this(new Position(angle, angle2, d), string);
    }

    public TrackPointImpl(LatLon latLon, double d, String string) {
        this(new Position(latLon.getLatitude(), latLon.getLongitude(), d), string);
    }

    public TrackPointImpl(Position position, String string) {
        this.position = position;
    }

    public TrackPointImpl(Position position) {
        this(position, null);
    }

    @Override
    public double getLatitude() {
        return this.position.getLatitude().degrees;
    }

    @Override
    public void setLatitude(double d) {
        this.position = new Position(Angle.fromDegrees(d), this.position.getLongitude(), this.position.getElevation());
    }

    @Override
    public double getLongitude() {
        return this.position.getLongitude().degrees;
    }

    @Override
    public void setLongitude(double d) {
        this.position = new Position(this.position.getLatitude(), Angle.fromDegrees(d), this.position.getElevation());
    }

    @Override
    public double getElevation() {
        return this.position.getElevation();
    }

    @Override
    public void setElevation(double d) {
        this.position = new Position(this.position.getLatitude(), this.position.getLongitude(), d);
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public void setTime(String string) {
        this.time = string;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
    }
}

