/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.terrain;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterReaderFactory;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.AbstractElevationModel;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocalElevationModel
extends AbstractElevationModel {
    protected double[] extremeElevations = null;
    protected CopyOnWriteArrayList<LocalTile> tiles = new CopyOnWriteArrayList();

    @Override
    public double getMinElevation() {
        return this.extremeElevations[0];
    }

    @Override
    public double getMaxElevation() {
        return this.extremeElevations[1];
    }

    public Sector getSector() {
        if (this.tiles.size() < 1) {
            return null;
        }
        Sector sector = null;
        for (LocalTile localTile : this.tiles) {
            Sector sector2 = localTile.sector;
            sector = sector == null ? sector2 : sector.union(sector2);
        }
        return sector;
    }

    @Override
    public double[] getExtremeElevations(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.tiles.size() == 0) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.contains(angle, angle2)) continue;
            if (localTile.minElevation < d) {
                d = localTile.minElevation;
            }
            if (!(localTile.maxElevation > d2)) continue;
            d2 = localTile.maxElevation;
        }
        return new double[]{d != Double.MAX_VALUE ? d : this.getMinElevation(), d2 != -1.7976931348623157E308 ? d2 : this.getMaxElevation()};
    }

    @Override
    public double[] getExtremeElevations(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.tiles.size() == 0) {
            return new double[]{this.getMinElevation(), this.getMaxElevation()};
        }
        double d = Double.MAX_VALUE;
        double d2 = -d;
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.intersects(sector)) continue;
            if (localTile.minElevation < d) {
                d = localTile.minElevation;
            }
            if (!(localTile.maxElevation > d2)) continue;
            d2 = localTile.maxElevation;
        }
        return new double[]{d != Double.MAX_VALUE ? d : this.getMinElevation(), d2 != -1.7976931348623157E308 ? d2 : this.getMaxElevation()};
    }

    @Override
    public double getBestResolution(Sector sector) {
        double d = Double.MAX_VALUE;
        for (LocalTile localTile : this.tiles) {
            double d2;
            if (!sector.intersects(localTile.sector) || !((d2 = localTile.sector.getDeltaLatRadians() / (double)localTile.tileHeight) < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getUnmappedElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.contains(angle, angle2)) {
            return this.missingDataFlag;
        }
        Double d = this.lookupElevation(angle.radians, angle2.radians);
        return d != null ? d : this.getExtremeElevations(angle, angle2)[0];
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.doGetElevations(sector, list, d, dArray, true);
    }

    @Override
    public double getUnmappedElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.doGetElevations(sector, list, d, dArray, false);
    }

    protected double doGetElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray, boolean bl) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (list == null) {
            String string = Logging.getMessage("nullValue.LatLonListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ElevationsBufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dArray.length < list.size()) {
            String string = Logging.getMessage("ElevationModel.ElevationsBufferTooSmall", list.size());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.intersects(sector) == -1) {
            return Double.MAX_VALUE;
        }
        this.setValue("gov.nasa.worldwind.avkey.FrameTimestamp", System.currentTimeMillis());
        for (int i = 0; i < list.size(); ++i) {
            LatLon latLon = list.get(i);
            if (latLon == null || !this.contains(latLon.getLatitude(), latLon.getLongitude())) continue;
            Double d2 = this.lookupElevation(latLon.getLatitude().radians, latLon.getLongitude().radians);
            if (d2 != null && d2 != this.missingDataFlag) {
                dArray[i] = d2;
            }
            if (d2 == null) {
                dArray[i] = this.getExtremeElevations(sector)[0];
                continue;
            }
            if (!bl || d2 != this.missingDataFlag) continue;
            dArray[i] = this.getMissingDataReplacement();
        }
        return this.getBestResolution(sector);
    }

    public void addElevations(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.addElevations(new File(string));
    }

    public void addElevations(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DataRasterReaderFactory dataRasterReaderFactory = (DataRasterReaderFactory)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.DataRasterReaderFactoryClassName");
        DataRasterReader dataRasterReader = dataRasterReaderFactory.findReaderFor(file, null);
        AVList aVList = dataRasterReader.readMetadata(file, null);
        if (aVList == null || !"gov.nasa.worldwind.avkey.Elevation".equals(aVList.getStringValue("gov.nasa.worldwind.avkey.PixelFormat"))) {
            String string = Logging.getMessage("ElevationModel.SourceNotElevations", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        DataRaster[] dataRasterArray = dataRasterReader.read(file, null);
        if (dataRasterArray == null || dataRasterArray.length == 0) {
            String string = Logging.getMessage("ElevationModel.CannotReadElevations", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new WWRuntimeException(string);
        }
        for (DataRaster dataRaster : dataRasterArray) {
            this.addRaster(dataRaster, file.getAbsolutePath());
        }
    }

    protected void addRaster(DataRaster dataRaster, String string) throws IOException {
        int n;
        Sector sector = (Sector)dataRaster.getValue("gov.nasa.worldwind.avKey.Sector");
        if (sector == null) {
            String string2 = Logging.getMessage("DataRaster.MissingMetadata", "gov.nasa.worldwind.avKey.Sector");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        int n2 = dataRaster.getWidth();
        DataRaster dataRaster2 = dataRaster.getSubRaster(n2, n = dataRaster.getHeight(), sector, dataRaster);
        if (!(dataRaster2 instanceof ByteBufferRaster)) {
            String string3 = Logging.getMessage("ElevationModel.CannotCreateElevationBuffer", string);
            Logging.logger().severe(string3);
            throw new WWRuntimeException(string3);
        }
        ByteBuffer byteBuffer = ((ByteBufferRaster)dataRaster2).getByteBuffer();
        dataRaster2.dispose();
        this.addElevations(byteBuffer, sector, n2, n, dataRaster);
        dataRaster.dispose();
    }

    public void addElevations(ByteBuffer byteBuffer, Sector sector, int n, int n2, AVList aVList) {
        String string;
        if (byteBuffer == null) {
            String string2 = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sector == null) {
            String string3 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        if (aVList == null) {
            String string4 = Logging.getMessage("nullValue.ParamsIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValues(aVList.copy());
        Double d = AVListImpl.getDoubleValue(aVListImpl, "gov.nasa.worldwind.avkey.MissingDataFlag");
        if (d == null) {
            d = this.getMissingDataSignal();
        }
        Double d2 = null;
        Double d3 = null;
        Object object = aVListImpl.getValue("gov.nasa.worldwind.avkey.ElevationMinKey");
        if (object instanceof Double) {
            d2 = (Double)object;
        }
        if ((object = aVListImpl.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey")) instanceof Double) {
            d3 = (Double)object;
        }
        if (WWUtil.isEmpty(string = aVListImpl.getStringValue("gov.nasa.worldwind.avkey.DataType"))) {
            String string5 = Logging.getMessage("DataRaster.MissingMetadata", "gov.nasa.worldwind.avkey.DataType");
            Logging.logger().severe(string5);
            throw new IllegalStateException(string5);
        }
        BufferWrapper bufferWrapper = BufferWrapper.wrap(byteBuffer, aVListImpl);
        LocalTile localTile = new LocalTile(sector, d, n, n2, bufferWrapper, d2, d3);
        this.tiles.add(localTile);
        this.adjustMinMax(localTile);
    }

    @Override
    public int intersects(Sector sector) {
        boolean bl = false;
        for (LocalTile localTile : this.tiles) {
            if (localTile.sector.contains(sector)) {
                return 0;
            }
            if (!localTile.sector.intersects(sector)) continue;
            bl = true;
        }
        return bl ? 1 : -1;
    }

    @Override
    public boolean contains(Angle angle, Angle angle2) {
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.contains(angle, angle2)) continue;
            return true;
        }
        return false;
    }

    protected void adjustMinMax(LocalTile localTile) {
        if (this.extremeElevations == null && localTile != null) {
            this.extremeElevations = new double[]{localTile.minElevation, localTile.maxElevation};
        } else if (localTile != null) {
            if (localTile.minElevation < this.extremeElevations[0]) {
                this.extremeElevations[0] = localTile.minElevation;
            }
            if (localTile.maxElevation > this.extremeElevations[1]) {
                this.extremeElevations[1] = localTile.maxElevation;
            }
        } else {
            double d = Double.MAX_VALUE;
            double d2 = -d;
            for (LocalTile localTile2 : this.tiles) {
                if (localTile2.minElevation < d) {
                    d = localTile2.minElevation;
                }
                if (!(localTile2.maxElevation > d2)) continue;
                d2 = localTile2.maxElevation;
            }
            this.extremeElevations = new double[]{d != Double.MAX_VALUE ? d : 0.0, d2 != -1.7976931348623157E308 ? d2 : 0.0};
        }
    }

    protected Double lookupElevation(double d, double d2) {
        double d3;
        LocalTile localTile = this.findTile(d, d2);
        if (localTile == null) {
            return null;
        }
        double d4 = localTile.sector.getDeltaLat().radians;
        double d5 = localTile.sector.getDeltaLon().radians;
        double d6 = localTile.sector.getMaxLatitude().radians - d;
        double d7 = d2 - localTile.sector.getMinLongitude().radians;
        double d8 = d6 / d4;
        double d9 = d7 / d5;
        int n = (int)((double)(localTile.tileHeight - 1) * d8);
        int n2 = (int)((double)(localTile.tileWidth - 1) * d9);
        int n3 = n * localTile.tileWidth + n2;
        double d10 = localTile.elevations.getDouble(n3);
        double d11 = d3 = n2 < localTile.tileWidth - 1 ? localTile.elevations.getDouble(n3 + 1) : d10;
        if (localTile.isMissingData(d10) || localTile.isMissingData(d3)) {
            return this.missingDataFlag;
        }
        double d12 = d5 / (double)(localTile.tileWidth - 1);
        double d13 = d4 / (double)(localTile.tileHeight - 1);
        double d14 = (d7 - (double)n2 * d12) / d12;
        double d15 = (d6 - (double)n * d13) / d13;
        double d16 = d10 + d14 * (d3 - d10);
        if (n < localTile.tileHeight - 1 && n2 < localTile.tileWidth - 1) {
            d10 = localTile.elevations.getDouble(n3 + localTile.tileWidth);
            d3 = localTile.elevations.getDouble(n3 + localTile.tileWidth + 1);
            if (localTile.isMissingData(d10) || localTile.isMissingData(d3)) {
                return this.missingDataFlag;
            }
        }
        double d17 = d10 + d14 * (d3 - d10);
        return d16 + d15 * (d17 - d16);
    }

    protected LocalTile findTile(double d, double d2) {
        for (LocalTile localTile : this.tiles) {
            if (!localTile.sector.containsRadians(d, d2)) continue;
            return localTile;
        }
        return null;
    }

    protected static class LocalTile {
        protected final Sector sector;
        protected final int tileWidth;
        protected final int tileHeight;
        protected double minElevation;
        protected double maxElevation;
        protected final double missingDataFlag;
        protected final BufferWrapper elevations;

        protected LocalTile(Sector sector, double d, int n, int n2, BufferWrapper bufferWrapper, Double d2, Double d3) {
            this.sector = sector;
            this.tileWidth = n;
            this.tileHeight = n2;
            this.missingDataFlag = d;
            this.elevations = bufferWrapper;
            if (d2 != null) {
                this.minElevation = d2;
            }
            if (d3 != null) {
                this.maxElevation = d3;
            }
            if (d2 == null || d3 == null) {
                this.computeMinMaxElevations();
            }
        }

        protected void computeMinMaxElevations() {
            int n = this.elevations.length();
            if (n == 0) {
                this.minElevation = 0.0;
                this.maxElevation = 0.0;
                return;
            }
            double d = Double.MAX_VALUE;
            double d2 = -d;
            for (int i = 0; i < n; ++i) {
                double d3 = this.elevations.getDouble(i);
                if (d3 == this.missingDataFlag) continue;
                if (d3 < d) {
                    d = d3;
                }
                if (!(d3 > d2)) continue;
                d2 = d3;
            }
            this.minElevation = d;
            this.maxElevation = d2;
        }

        protected boolean isMissingData(double d) {
            return d == this.missingDataFlag || d < this.minElevation || d > this.maxElevation || d == -32767.0;
        }
    }
}

