/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class LinearTarget
extends AbstractMilStd2525TacticalGraphic {
    public static final double DEFAULT_VERTICAL_LENGTH = 0.25;
    protected double verticalLength = 0.25;
    protected static final Offset TOP_LABEL_OFFSET = new Offset(0.0, -1.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    protected static final Offset BOTTOM_LABEL_OFFSET = new Offset(0.0, 0.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    protected Position startPosition;
    protected Position endPosition;
    protected String additionalText;
    protected Path[] paths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-LT---------", "G-F-LTS--------", "G-F-LTF--------");
    }

    public LinearTarget(String string) {
        super(string);
    }

    public double getVerticalLength() {
        return this.verticalLength;
    }

    public void setVerticalLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.verticalLength = d;
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public void setAdditionalText(String string) {
        this.additionalText = string;
        this.onModifierChanged();
    }

    @Override
    public Object getModifier(String string) {
        if ("T".equals(string) && this.additionalText != null) {
            return Arrays.asList(this.getText(), this.getAdditionalText());
        }
        return super.getModifier(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("T".equals(string) && object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (iterator.hasNext()) {
                this.setText((String)iterator.next());
            }
            if (iterator.hasNext()) {
                this.setAdditionalText((String)iterator.next());
            }
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.startPosition = iterator.next();
            this.endPosition = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.paths = null;
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.startPosition, this.endPosition);
    }

    @Override
    public Position getReferencePosition() {
        return this.startPosition;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[3];
        this.paths[0] = this.createPath(Arrays.asList(this.startPosition, this.endPosition));
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(this.startPosition);
        Vec4 vec42 = globe.computePointFromPosition(this.endPosition);
        Vec4 vec43 = vec4.subtract3(vec42);
        double d = this.getVerticalLength();
        double d2 = vec43.getLength3() * d;
        List<Position> list = this.computeVerticalSegmentPositions(globe, vec4, vec43, d2);
        this.paths[1] = this.createPath(list);
        list = this.computeVerticalSegmentPositions(globe, vec42, vec43, d2);
        this.paths[2] = this.createPath(list);
    }

    protected List<Position> computeVerticalSegmentPositions(Globe globe, Vec4 vec4, Vec4 vec42, double d) {
        Vec4 vec43 = globe.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec44 = vec43.cross3(vec42);
        vec44 = vec44.normalize3().multiply3(d / 2.0);
        Vec4 vec45 = vec4.add3(vec44);
        Vec4 vec46 = vec4.subtract3(vec44);
        return Arrays.asList(globe.computePositionFromPoint(vec45), globe.computePositionFromPoint(vec46));
    }

    @Override
    protected void createLabels() {
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            this.addLabel(string);
        }
        if (!WWUtil.isEmpty(string = this.getBottomLabelText())) {
            TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setOffset(this.getBottomLabelOffset());
        }
    }

    protected String getBottomLabelText() {
        String string = this.maskedSymbolCode;
        if ("G-F-LTS--------".equalsIgnoreCase(string)) {
            return "SMOKE";
        }
        if ("G-F-LTF--------".equalsIgnoreCase(string)) {
            StringBuilder stringBuilder = new StringBuilder("FPF");
            String string2 = this.getAdditionalText();
            if (!WWUtil.isEmpty(string2)) {
                stringBuilder.append("\n").append(string2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        TacticalGraphicLabel tacticalGraphicLabel;
        if (this.labels == null || this.labels.size() == 0) {
            return;
        }
        Globe globe = drawContext.getGlobe();
        LatLon latLon = LatLon.interpolateGreatCircle(0.5, this.startPosition, this.endPosition);
        Vec4 vec4 = globe.computePointFromLocation(latLon);
        Vec4 vec42 = globe.computePointFromPosition(this.startPosition);
        Vec4 vec43 = globe.computePointFromPosition(this.endPosition);
        Vec4 vec44 = vec43.subtract3(vec42);
        double d = this.getVerticalLength();
        double d2 = vec44.getLength3() * d * 0.25;
        List<Position> list = this.computeVerticalSegmentPositions(globe, vec4, vec44, d2);
        List<Position> list2 = this.computeVerticalSegmentPositions(globe, vec43, vec44, d2);
        TacticalGraphicLabel tacticalGraphicLabel2 = (TacticalGraphicLabel)this.labels.get(0);
        if (tacticalGraphicLabel2 != null) {
            tacticalGraphicLabel2.setPosition(list.get(0));
            tacticalGraphicLabel2.setOrientationPosition(list2.get(0));
        }
        if (this.labels.size() > 1 && (tacticalGraphicLabel = (TacticalGraphicLabel)this.labels.get(1)) != null) {
            tacticalGraphicLabel.setPosition(list.get(1));
            tacticalGraphicLabel.setOrientationPosition(list2.get(1));
        }
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return TOP_LABEL_OFFSET;
    }

    protected Offset getBottomLabelOffset() {
        return BOTTOM_LABEL_OFFSET;
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

