/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DirectionOfAttack;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectionOfAttackForFeint
extends DirectionOfAttack {
    protected static final Offset LABEL_OFFSET = new Offset(0.0, -1.0, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.POS90;
    protected static final double DASHED_LINE_DISTANCE = 0.5;
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final double DEFAULT_CURVATURE = 0.5;
    protected int intervals = 32;
    protected double curvature = 0.5;
    protected ShapeAttributes dashedAttributes = new BasicShapeAttributes();
    protected Position labelPosition;
    protected Position labelOrientationPosition;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-PF---------");
    }

    public DirectionOfAttackForFeint(String string) {
        super(string);
        this.setArrowAngle(DEFAULT_ARROWHEAD_ANGLE);
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 3) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    public double getCurvature() {
        return this.curvature;
    }

    public void setCurvature(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.curvature = d;
    }

    protected void onShapeChanged() {
        this.paths = null;
    }

    @Override
    protected void createShapes(DrawContext drawContext) {
        List<Position> list;
        double d;
        this.paths = new Path[3];
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromLocation(this.startPosition);
        Vec4 vec42 = globe.computePointFromLocation(this.endPosition);
        Vec4[] vec4Array = this.computeBezierControlPoints(drawContext, vec4, vec42, this.getCurvature());
        Line line = Line.fromSegment(vec4, vec42);
        int n = 0;
        double d2 = -1.7976931348623157E308;
        ArrayList<Position> arrayList = new ArrayList<Position>();
        int[] nArray = new int[vec4Array.length];
        int n2 = this.getIntervals();
        double d3 = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            d = (double)i * d3;
            list = TacticalGraphicUtil.bezierCurve(vec4Array, d, nArray);
            Position position = globe.computePositionFromPoint((Vec4)((Object)list));
            arrayList.add(position);
            double d4 = line.distanceTo((Vec4)((Object)list));
            if (!(d4 > d2)) continue;
            n = i;
            d2 = d4;
        }
        arrayList.add(this.endPosition);
        this.labelPosition = (Position)arrayList.get(n);
        this.labelOrientationPosition = n != arrayList.size() - 1 ? (Position)arrayList.get(n + 1) : (Position)arrayList.get(n - 1);
        this.paths[0] = this.createPath(arrayList);
        Vec4 vec43 = vec4.subtract3(vec42);
        d = vec42.subtract3(vec4).getLength3() * this.getArrowLength();
        list = this.computeArrowheadPositions(drawContext, vec42, vec43, d);
        this.paths[1] = this.createPath(list);
        vec42 = vec42.subtract3(vec43.normalize3().multiply3(d * 0.5));
        list = this.computeArrowheadPositions(drawContext, vec42, vec43, d * 1.5);
        this.paths[2] = this.createPath(list);
        this.paths[2].setAttributes(this.dashedAttributes);
    }

    @Override
    protected void determineActiveAttributes() {
        super.determineActiveAttributes();
        this.dashedAttributes.copy(this.getActiveShapeAttributes());
        this.dashedAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        this.dashedAttributes.setOutlineStippleFactor(this.getOutlineStippleFactor());
    }

    @Override
    protected void createLabels() {
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string);
            tacticalGraphicLabel.setOffset(LABEL_OFFSET);
        }
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (WWUtil.isEmpty(this.labels)) {
            return;
        }
        ((TacticalGraphicLabel)this.labels.get(0)).setPosition(this.labelPosition);
        ((TacticalGraphicLabel)this.labels.get(0)).setOrientationPosition(this.labelOrientationPosition);
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return LABEL_OFFSET;
    }

    protected Vec4[] computeBezierControlPoints(DrawContext drawContext, Vec4 vec4, Vec4 vec42, double d) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec43 = vec42.subtract3(vec4);
        double d2 = vec43.getLength3();
        vec43 = vec43.normalize3();
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec4).normalize3();
        Vec4 vec45 = vec43.cross3(vec44).multiply3(d2 * d);
        double[] dArray = new double[]{0.2, -0.6, 0.2, 0.0};
        Vec4[] vec4Array = new Vec4[dArray.length + 2];
        vec4Array[0] = vec4;
        vec4Array[vec4Array.length - 1] = vec42;
        double d3 = d2 / (double)(dArray.length + 1);
        for (int i = 0; i < dArray.length; ++i) {
            vec4Array[i + 1] = vec4.add3(vec43.multiply3((double)(i + 1) * d3)).add3(vec45.multiply3(dArray[i]));
        }
        return vec4Array;
    }
}

