/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Aviation;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AttackRotaryWing
extends Aviation {
    protected static final int LEFT_VERTICAL = 1;
    protected static final int RIGHT_VERTICAL = 2;
    protected static final int ROTOR_SYMBOL = 3;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-OLAR-------");
    }

    public AttackRotaryWing(String string) {
        super(string, 4);
    }

    @Override
    protected void createLinePositions(List<Position> list, List<Position> list2, double d, Globe globe) {
        super.createLinePositions(list, list2, d, globe);
        Iterator iterator = this.positions.iterator();
        Position position = (Position)iterator.next();
        Position position2 = (Position)iterator.next();
        Position position3 = list2.get(0);
        Position position4 = list2.get(1);
        Position position5 = list.get(1);
        Position position6 = list.get(0);
        Vec4 vec4 = globe.computePointFromLocation(position);
        Vec4 vec42 = globe.computePointFromLocation(position2);
        Vec4 vec43 = globe.computePointFromLocation(position3);
        Vec4 vec44 = globe.computePointFromLocation(position4);
        Vec4 vec45 = globe.computePointFromLocation(position5);
        Vec4 vec46 = globe.computePointFromLocation(position6);
        Vec4 vec47 = vec44.subtract3(vec43);
        Vec4 vec48 = vec46.subtract3(vec45);
        Vec4 vec49 = vec4.subtract3(vec42);
        Vec4 vec410 = vec43.subtract3(vec45).divide3(2.0).add3(vec45);
        Vec4 vec411 = vec46.subtract3(vec44).divide3(2.0).add3(vec44);
        Vec4 vec412 = vec411.subtract3(vec410).divide3(2.0).add3(vec410);
        vec412 = Line.fromSegment(vec46, vec45).nearestPointTo(vec412);
        double d2 = vec47.getLength3() / 4.0;
        Vec4 vec413 = vec412.add3(vec47.normalize3().multiply3(d2));
        Vec4 vec414 = vec412.add3(vec48.normalize3().multiply3(-d2));
        Position position7 = globe.computePositionFromPoint(vec413);
        Position position8 = globe.computePositionFromPoint(vec414);
        this.paths[1].setPositions(Arrays.asList(position7, position8));
        vec413 = vec412.add3(vec47.normalize3().multiply3(-d2));
        vec414 = vec412.add3(vec48.normalize3().multiply3(d2));
        position7 = globe.computePositionFromPoint(vec413);
        position8 = globe.computePositionFromPoint(vec414);
        this.paths[2].setPositions(Arrays.asList(position7, position8));
        double d3 = d / 4.0;
        Vec4 vec415 = globe.computeSurfaceNormalAtPoint(vec412);
        Vec4 vec416 = vec49.cross3(vec415).normalize3().multiply3(d);
        Vec4 vec417 = vec412.subtract3(vec416);
        Vec4 vec418 = vec412.add3(vec416);
        vec415 = globe.computeSurfaceNormalAtPoint(vec414);
        vec416 = vec413.subtract3(vec414).cross3(vec415).normalize3().multiply3(d3);
        Vec4 vec419 = vec418.add3(vec416);
        Vec4 vec420 = vec418.subtract3(vec416);
        Vec4 vec421 = vec418.subtract3(vec417).normalize3().multiply3(d3).add3(vec417);
        Vec4 vec422 = vec421.add3(vec416);
        Vec4 vec423 = vec421.subtract3(vec416);
        Position position9 = globe.computePositionFromPoint(vec419);
        Position position10 = globe.computePositionFromPoint(vec420);
        Position position11 = globe.computePositionFromPoint(vec418);
        Position position12 = globe.computePositionFromPoint(vec417);
        Position position13 = globe.computePositionFromPoint(vec422);
        Position position14 = globe.computePositionFromPoint(vec423);
        this.paths[3].setPositions(Arrays.asList(position9, position10, position11, position12, position13, position12, position14));
    }
}

