/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Curtain
extends AbstractAirspace {
    protected List<LatLon> locations = new ArrayList<LatLon>();
    protected String pathType = "gov.nasa.worldwind.avkey.GreatCircle";
    protected double splitThreshold = 2000.0;
    protected boolean applyPositionAltitude = false;

    public Curtain(Iterable<? extends LatLon> iterable) {
        this.addLocations(iterable);
        this.makeDefaultDetailLevels();
    }

    public Curtain(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public Curtain() {
        this.makeDefaultDetailLevels();
    }

    protected void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("SplitThreshold", 1000.0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("SplitThreshold", 2000.0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("SplitThreshold", 10000.0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("SplitThreshold", 100000.0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("SplitThreshold", 1000000.0);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public Iterable<LatLon> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        this.locations.clear();
        this.addLocations(iterable);
    }

    protected void addLocations(Iterable<? extends LatLon> iterable) {
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                if (latLon == null) continue;
                this.locations.add(latLon);
            }
        }
        this.setExtentOutOfDate();
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String string) {
        if (string == null) {
            String string2 = "nullValue.PathTypeIsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.pathType = string;
        this.setExtentOutOfDate();
    }

    public boolean isApplyPositionAltitude() {
        return this.applyPositionAltitude;
    }

    public void setApplyPositionAltitude(boolean bl) {
        this.applyPositionAltitude = bl;
    }

    @Override
    public Position getReferencePosition() {
        return this.computeReferencePosition(this.locations, this.getAltitudes());
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        this.makeTessellatedLocations(globe, arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        ArrayList<Vec4> arrayList2 = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, arrayList, arrayList2);
        return arrayList2;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        int n = this.locations.size();
        LatLon[] latLonArray = new LatLon[n];
        for (int i = 0; i < n; ++i) {
            LatLon latLon = this.locations.get(i);
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLon).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLon).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(Arrays.asList(latLonArray));
    }

    protected double getSplitThreshold() {
        return this.splitThreshold;
    }

    protected void setSplitThreshold(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "splitThreshold=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.splitThreshold = d;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        Extent extent = this.getExtent(drawContext);
        return extent != null ? extent.getCenter() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        int n = this.locations.size();
        LatLon[] latLonArray = new LatLon[n];
        this.locations.toArray(latLonArray);
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        String string4 = this.getPathType();
        double d = this.splitThreshold;
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("SplitThreshold");
            if (object != null && object instanceof Double) {
                d = (Double)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL();
        int[] nArray = new int[1];
        try {
            object.glGetIntegerv(2898, nArray, 0);
            drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
            if ("Airspace.DrawStyleFill".equals(string)) {
                object.glLightModeli(2898, 1);
                this.drawCurtainFill(drawContext, n, latLonArray, string4, d, dArray, blArray, (Vec4)object2);
            } else if ("Airspace.DrawStyleOutline".equals(string)) {
                this.drawCurtainOutline(drawContext, n, latLonArray, string4, d, dArray, blArray, (Vec4)object2);
            }
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
            object.glLightModeli(2898, nArray[0]);
        }
    }

    protected CurtainGeometry getCurtainGeometry(DrawContext drawContext, int n, LatLon[] latLonArray, String string, double d, double[] dArray, boolean[] blArray, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "Curtain", latLonArray, string, dArray[0], dArray[1], blArray[0], blArray[1], d, vec4);
        CurtainGeometry curtainGeometry = (CurtainGeometry)this.getGeometryCache().getObject(cacheKey);
        if (curtainGeometry == null || this.isExpired(drawContext, curtainGeometry.getVertexGeometry())) {
            if (curtainGeometry == null) {
                curtainGeometry = new CurtainGeometry();
            }
            this.makeCurtainGeometry(drawContext, n, latLonArray, string, d, dArray, blArray, vec4, curtainGeometry);
            this.updateExpiryCriteria(drawContext, curtainGeometry.getVertexGeometry());
            this.getGeometryCache().add(cacheKey, curtainGeometry);
        }
        return curtainGeometry;
    }

    protected void drawCurtainFill(DrawContext drawContext, int n, LatLon[] latLonArray, String string, double d, double[] dArray, boolean[] blArray, Vec4 vec4) {
        CurtainGeometry curtainGeometry = this.getCurtainGeometry(drawContext, n, latLonArray, string, d, dArray, blArray, vec4);
        this.getRenderer().drawGeometry(drawContext, curtainGeometry.getFillIndexGeometry(), curtainGeometry.getVertexGeometry());
    }

    protected void drawCurtainOutline(DrawContext drawContext, int n, LatLon[] latLonArray, String string, double d, double[] dArray, boolean[] blArray, Vec4 vec4) {
        CurtainGeometry curtainGeometry = this.getCurtainGeometry(drawContext, n, latLonArray, string, d, dArray, blArray, vec4);
        this.getRenderer().drawGeometry(drawContext, curtainGeometry.getOutlineIndexGeometry(), curtainGeometry.getVertexGeometry());
    }

    protected void makeCurtainGeometry(DrawContext drawContext, int n, LatLon[] latLonArray, String string, double d, double[] dArray, boolean[] blArray, Vec4 vec4, CurtainGeometry curtainGeometry) {
        int n2 = n - 1;
        int[] nArray = new int[3];
        SectionRenderInfo[] sectionRenderInfoArray = new SectionRenderInfo[n2];
        this.makeSectionInfo(drawContext, n, latLonArray, string, d, sectionRenderInfoArray, nArray);
        int n3 = this.getSectionFillDrawMode();
        int n4 = this.getSectionOutlineDrawMode();
        int[] nArray2 = new int[nArray[0]];
        int[] nArray3 = new int[nArray[1]];
        float[] fArray = new float[3 * nArray[2]];
        float[] fArray2 = new float[3 * nArray[2]];
        for (int i = 0; i < n2; ++i) {
            this.makeSectionFillIndices(sectionRenderInfoArray[i].pillars, sectionRenderInfoArray[i].firstVertex, sectionRenderInfoArray[i].firstFillIndex, nArray2);
            this.makeSectionOutlineIndices(sectionRenderInfoArray[i].pillars, sectionRenderInfoArray[i].firstVertex, sectionRenderInfoArray[i].firstOutlineIndex, nArray3);
            this.makeSectionVertices(drawContext, sectionRenderInfoArray[i].begin, sectionRenderInfoArray[i].end, sectionRenderInfoArray[i].pathType, dArray, blArray, sectionRenderInfoArray[i].pillars, sectionRenderInfoArray[i].firstVertex, fArray, vec4);
            this.getGeometryBuilder().makeIndexedTriangleStripNormals(sectionRenderInfoArray[i].firstFillIndex, sectionRenderInfoArray[i].fillIndexCount, nArray2, sectionRenderInfoArray[i].firstVertex, sectionRenderInfoArray[i].vertexCount, fArray, fArray2);
        }
        curtainGeometry.getFillIndexGeometry().setElementData(n3, nArray[0], nArray2);
        curtainGeometry.getOutlineIndexGeometry().setElementData(n4, nArray[1], nArray3);
        curtainGeometry.getVertexGeometry().setVertexData(nArray[2], fArray);
        curtainGeometry.getVertexGeometry().setNormalData(nArray[2], fArray2);
    }

    protected void makeSectionInfo(DrawContext drawContext, int n, LatLon[] latLonArray, String string, double d, SectionRenderInfo[] sectionRenderInfoArray, int[] nArray) {
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            sectionRenderInfoArray[i] = new SectionRenderInfo(latLonArray[i], latLonArray[i + 1], string);
            sectionRenderInfoArray[i].pillars = this.getSectionPillarCount(drawContext, sectionRenderInfoArray[i].begin, sectionRenderInfoArray[i].end, sectionRenderInfoArray[i].pathType, d);
            sectionRenderInfoArray[i].firstFillIndex = nArray[0];
            sectionRenderInfoArray[i].firstOutlineIndex = nArray[1];
            sectionRenderInfoArray[i].firstVertex = nArray[2];
            sectionRenderInfoArray[i].fillIndexCount = this.getSectionFillIndexCount(sectionRenderInfoArray[i].pillars);
            sectionRenderInfoArray[i].outlineIndexCount = this.getSectionOutlineIndexCount(sectionRenderInfoArray[i].pillars);
            sectionRenderInfoArray[i].vertexCount = this.getSectionVertexCount(sectionRenderInfoArray[i].pillars);
            nArray[0] = nArray[0] + sectionRenderInfoArray[i].fillIndexCount;
            nArray[1] = nArray[1] + sectionRenderInfoArray[i].outlineIndexCount;
            nArray[2] = nArray[2] + sectionRenderInfoArray[i].vertexCount;
        }
    }

    protected int getSectionPillarCount(DrawContext drawContext, LatLon latLon, LatLon latLon2, String string, double d) {
        Globe globe = drawContext.getGlobe();
        double d2 = "gov.nasa.worldwind.avkey.RhumbLine".equalsIgnoreCase(string) || "gov.nasa.worldwind.avkey.Loxodrome".equalsIgnoreCase(string) ? LatLon.rhumbDistance((LatLon)latLon, (LatLon)latLon2).radians : LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon2).radians;
        double d3 = d2 * globe.getRadius();
        int n = (int)Math.ceil(d3 / d) - 1;
        n = Math.max(1, n);
        return n;
    }

    protected int getSectionFillDrawMode() {
        return 5;
    }

    protected int getSectionOutlineDrawMode() {
        return 1;
    }

    protected int getSectionFillIndexCount(int n) {
        return 2 * (n + 1);
    }

    protected int getSectionOutlineIndexCount(int n) {
        return 4 * (n + 1);
    }

    protected int getSectionVertexCount(int n) {
        return 2 * (n + 1);
    }

    protected void makeSectionFillIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = n3;
        for (int i = 0; i <= n; ++i) {
            int n5 = n2 + 2 * i;
            nArray[n4++] = n5 + 1;
            nArray[n4++] = n5;
        }
    }

    protected void makeSectionOutlineIndices(int n, int n2, int n3, int[] nArray) {
        int n4 = n3;
        int n5 = n2;
        nArray[n4++] = n5 + 1;
        nArray[n4++] = n5;
        for (int i = 0; i < n; ++i) {
            n5 = n2 + 2 * i;
            nArray[n4++] = n5;
            nArray[n4++] = n5 + 2;
            nArray[n4++] = n5 + 1;
            nArray[n4++] = n5 + 3;
        }
        n5 = n2 + 2 * n;
        nArray[n4++] = n5 + 1;
        nArray[n4] = n5;
    }

    protected void makeSectionVertices(DrawContext drawContext, LatLon latLon, LatLon latLon2, String string, double[] dArray, boolean[] blArray, int n, int n2, float[] fArray, Vec4 vec4) {
        double d;
        double d2;
        Globe globe = drawContext.getGlobe();
        if ("gov.nasa.worldwind.avkey.RhumbLine".equalsIgnoreCase(string) || "gov.nasa.worldwind.avkey.Loxodrome".equalsIgnoreCase(string)) {
            d2 = LatLon.rhumbDistance((LatLon)latLon, (LatLon)latLon2).radians;
            d = LatLon.rhumbAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
        } else {
            d2 = LatLon.greatCircleDistance((LatLon)latLon, (LatLon)latLon2).radians;
            d = LatLon.greatCircleAzimuth((LatLon)latLon, (LatLon)latLon2).radians;
        }
        double d3 = d2 / (double)n;
        double d4 = 0.0;
        Double d5 = null;
        if (this.isApplyPositionAltitude() && latLon instanceof Position && latLon2 instanceof Position) {
            d4 = ((Position)latLon).getAltitude();
            d5 = (((Position)latLon2).getAltitude() - d4) / (double)n;
        }
        for (int i = 0; i <= n; ++i) {
            double d6 = (double)i * d3;
            LatLon latLon3 = "gov.nasa.worldwind.avkey.RhumbLine".equalsIgnoreCase(string) || "gov.nasa.worldwind.avkey.Loxodrome".equalsIgnoreCase(string) ? LatLon.rhumbEndPosition(latLon, d, d6) : LatLon.greatCircleEndPosition(latLon, d, d6);
            for (int j = 0; j < 2; ++j) {
                double d7;
                int n3 = j + 2 * i;
                n3 = 3 * (n2 + n3);
                double d8 = d7 = d5 != null && j == 1 ? d4 + (double)i * d5 : dArray[j];
                if (blArray[j]) {
                    d7 += this.computeElevationAt(drawContext, latLon3.getLatitude(), latLon3.getLongitude());
                }
                Vec4 vec42 = globe.computePointFromPosition(latLon3.getLatitude(), latLon3.getLongitude(), d7);
                fArray[n3] = (float)(vec42.x - vec4.x);
                fArray[n3 + 1] = (float)(vec42.y - vec4.y);
                fArray[n3 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    protected void makeTessellatedLocations(Globe globe, List<LatLon> list) {
        if (this.getLocations() == null) {
            return;
        }
        Iterator<LatLon> iterator = this.getLocations().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        LatLon latLon = iterator.next();
        list.add(latLon);
        while (iterator.hasNext()) {
            LatLon latLon2 = iterator.next();
            this.makeSegment(globe, latLon, latLon2, list);
            latLon = latLon2;
        }
    }

    protected void makeSegment(Globe globe, LatLon latLon, LatLon latLon2, List<LatLon> list) {
        Angle angle;
        Angle angle2;
        boolean bl;
        boolean bl2 = bl = "gov.nasa.worldwind.avkey.RhumbLine".equalsIgnoreCase(this.getPathType()) || "gov.nasa.worldwind.avkey.Loxodrome".equalsIgnoreCase(this.getPathType());
        if (bl) {
            angle2 = LatLon.rhumbAzimuth(latLon, latLon2);
            angle = LatLon.rhumbDistance(latLon, latLon2);
        } else {
            angle2 = LatLon.greatCircleAzimuth(latLon, latLon2);
            angle = LatLon.greatCircleDistance(latLon, latLon2);
        }
        double d = angle.radians * globe.getRadius();
        if (d <= this.getSplitThreshold()) {
            list.add(latLon2);
            return;
        }
        int n = (int)Math.ceil(d / this.getSplitThreshold());
        double d2 = angle.radians / (double)n;
        double d3 = 0.0;
        while (d3 < angle.radians) {
            if ((d3 += d2) >= angle.radians) {
                list.add(latLon2);
                break;
            }
            LatLon latLon3 = bl ? LatLon.rhumbEndPosition(latLon, angle2, Angle.fromRadians(d3)) : LatLon.greatCircleEndPosition(latLon, angle2, Angle.fromRadians(d3));
            list.add(latLon3);
        }
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        if (this.locations != null) {
            restorableSupport.addStateValueAsLatLonList(stateObject, "locations", this.locations);
        }
        restorableSupport.addStateValueAsString(stateObject, "pathType", this.getPathType());
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        super.doRestoreState(restorableSupport, stateObject);
        List<LatLon> list = restorableSupport.getStateValueAsLatLonList(stateObject, "locations");
        if (list != null) {
            this.setLocations(list);
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "pathType")) != null) {
            this.setPathType(string);
        }
    }

    protected static class SectionRenderInfo {
        LatLon begin;
        LatLon end;
        String pathType;
        int pillars;
        int firstVertex;
        int vertexCount;
        int firstFillIndex;
        int fillIndexCount;
        int firstOutlineIndex;
        int outlineIndexCount;

        private SectionRenderInfo(LatLon latLon, LatLon latLon2, String string) {
            this.begin = latLon;
            this.end = latLon2;
            this.pathType = string;
        }
    }

    protected static class CurtainGeometry
    implements Cacheable {
        private Geometry fillIndexGeometry = new Geometry();
        private Geometry outlineIndexGeometry = new Geometry();
        private Geometry vertexGeometry = new Geometry();

        public Geometry getFillIndexGeometry() {
            return this.fillIndexGeometry;
        }

        public Geometry getOutlineIndexGeometry() {
            return this.outlineIndexGeometry;
        }

        public Geometry getVertexGeometry() {
            return this.vertexGeometry;
        }

        @Override
        public long getSizeInBytes() {
            long l = 0L;
            l += this.fillIndexGeometry != null ? this.fillIndexGeometry.getSizeInBytes() : 0L;
            l += this.outlineIndexGeometry != null ? this.outlineIndexGeometry.getSizeInBytes() : 0L;
            return l += this.vertexGeometry != null ? this.vertexGeometry.getSizeInBytes() : 0L;
        }
    }
}

