/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.CompoundVecBuffer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SurfaceTileDrawContext;
import gov.nasa.worldwind.util.VecBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;

public class SurfacePolylines
extends AbstractSurfaceShape {
    protected List<Sector> sectors;
    protected CompoundVecBuffer buffer;
    protected boolean needsOutlineTessellation = true;
    protected boolean crossesDateLine = false;
    protected Object outlineDisplayListCacheKey = new Object();

    public SurfacePolylines(CompoundVecBuffer compoundVecBuffer) {
        if (compoundVecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buffer = compoundVecBuffer;
    }

    public SurfacePolylines(Sector sector, CompoundVecBuffer compoundVecBuffer) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (compoundVecBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sectors = Arrays.asList(sector);
        this.buffer = compoundVecBuffer;
    }

    public CompoundVecBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public List<Sector> getSectors(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.sectors == null) {
            this.sectors = this.computeSectors(drawContext);
        }
        return this.sectors;
    }

    @Override
    public Iterable<? extends LatLon> getLocations(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getLocations();
    }

    @Override
    protected List<List<LatLon>> createGeometry(Globe globe, SurfaceTileDrawContext surfaceTileDrawContext) {
        return null;
    }

    public Iterable<? extends LatLon> getLocations() {
        return this.buffer.getLocations();
    }

    public void setLocations(Iterable<? extends LatLon> iterable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Position getReferencePosition() {
        Iterator<? extends LatLon> iterator = this.getLocations().iterator();
        if (iterator.hasNext()) {
            return new Position(iterator.next(), 0.0);
        }
        return null;
    }

    @Override
    protected boolean canContainPole() {
        return false;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        for (int i = 0; i < this.buffer.size(); ++i) {
            VecBuffer vecBuffer = this.buffer.subBuffer(i);
            for (int j = 0; j < vecBuffer.getSize(); ++j) {
                LatLon latLon = vecBuffer.getLocation(j);
                Angle angle = LatLon.greatCircleAzimuth(position, latLon);
                Angle angle2 = LatLon.greatCircleDistance(position, latLon);
                vecBuffer.putLocation(j, LatLon.greatCircleEndPosition((LatLon)position2, angle, angle2));
            }
        }
        this.onGeometryChanged();
    }

    protected void onGeometryChanged() {
        this.sectors = null;
        this.needsOutlineTessellation = true;
        super.onShapeChanged();
    }

    @Override
    protected void determineActiveGeometry(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
    }

    @Override
    protected void drawInterior(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void drawOutline(DrawContext drawContext, SurfaceTileDrawContext surfaceTileDrawContext) {
        if (this.buffer.size() == 0) {
            return;
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return;
        }
        int n = (int)Math.signum(surfaceTileDrawContext.getSector().getCentroid().getLongitude().degrees);
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.outlineDisplayListCacheKey);
        if (nArray == null || this.needsOutlineTessellation) {
            nArray = this.tessellateOutline(drawContext, position);
        }
        if (nArray == null) {
            return;
        }
        GL gL = drawContext.getGL();
        this.applyOutlineState(drawContext, this.getActiveAttributes());
        gL.glCallList(nArray[0]);
        if (this.crossesDateLine) {
            gL.glPushMatrix();
            try {
                gL.glTranslated(360 * n, 0.0, 0.0);
                gL.glCallList(nArray[0]);
            }
            finally {
                gL.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] tessellateOutline(DrawContext drawContext, LatLon latLon) {
        int n;
        GL gL = drawContext.getGL();
        this.crossesDateLine = false;
        int[] nArray = new int[]{drawContext.getGL().glGenLists(1), 1};
        gL.glNewList(nArray[0], 4864);
        try {
            for (n = 0; n < this.buffer.size(); ++n) {
                VecBuffer vecBuffer = this.buffer.subBuffer(n);
                if (!this.tessellatePart(gL, vecBuffer, latLon)) continue;
                this.crossesDateLine = true;
            }
        }
        finally {
            gL.glEndList();
        }
        this.needsOutlineTessellation = false;
        n = this.buffer.size() * 3 * 4;
        drawContext.getGpuResourceCache().put(this.outlineDisplayListCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.DisplayList", n);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tessellatePart(GL gL, VecBuffer vecBuffer, LatLon latLon) {
        Iterable<double[]> iterable = vecBuffer.getCoords(3);
        boolean bl = false;
        gL.glBegin(3);
        try {
            int n = 0;
            double d = 0.0;
            for (double[] dArray : iterable) {
                if (Math.abs(d - dArray[0]) > 180.0) {
                    n += (int)Math.signum(d);
                    bl = true;
                }
                d = dArray[0];
                double d2 = dArray[0] - latLon.getLongitude().degrees;
                double d3 = dArray[1] - latLon.getLatitude().degrees;
                gL.glVertex3f((float)(d2 += (double)(n * 360)), (float)d3, 0.0f);
            }
        }
        finally {
            gL.glEnd();
        }
        return bl;
    }
}

