/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.GLUTessellatorSupport;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWBufferUtil;
import gov.nasa.worldwind.util.WWMath;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Polygon
extends AbstractShape {
    protected static HashMap<Integer, IntBuffer> edgeIndexBuffers = new HashMap();
    protected static final int VBO_THRESHOLD = Configuration.getIntegerValue("gov.nasa.worldwind.avkey.VBOThreshold", 30);
    protected List<List<? extends Position>> boundaries = new ArrayList<List<? extends Position>>();
    protected int numPositions;
    protected Object imageSource;
    protected WWTexture texture;
    protected Double rotation;
    protected FloatBuffer textureCoordsBuffer;
    protected Terrain previousIntersectionTerrain;
    protected Object previousIntersectionGlobeStateKey;
    protected ShapeData previousIntersectionShapeData;

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    protected ShapeData getCurrent() {
        return (ShapeData)this.getCurrentData();
    }

    public Polygon() {
        this.boundaries.add(new ArrayList());
    }

    public Polygon(Iterable<? extends Position> iterable) {
        this();
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(iterable);
    }

    public Polygon(Position.PositionList positionList) {
        this();
        if (positionList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setOuterBoundary(positionList.list);
    }

    @Override
    protected void initialize() {
    }

    @Override
    protected void reset() {
        for (List<? extends Position> list : this.boundaries) {
            if (list == null || list.size() < 3 || WWMath.computeWindingOrderOfLocations(list) == "gov.nasa.worldwind.avkey.CounterClockWise") continue;
            Collections.reverse(list);
        }
        this.numPositions = this.countPositions();
        this.previousIntersectionShapeData = null;
        this.previousIntersectionTerrain = null;
        this.previousIntersectionGlobeStateKey = null;
        super.reset();
    }

    protected int countPositions() {
        int n = 0;
        for (List<? extends Position> list : this.boundaries) {
            n += list.size();
        }
        return n;
    }

    public Iterable<? extends LatLon> getOuterBoundary() {
        return this.outerBoundary();
    }

    protected List<? extends Position> outerBoundary() {
        return this.boundaries.get(0);
    }

    protected boolean isOuterBoundaryValid() {
        return this.boundaries.size() > 0 && this.boundaries.get(0).size() > 2;
    }

    public void setOuterBoundary(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.set(0, this.fillBoundary(iterable));
        this.reset();
    }

    protected List<? extends Position> fillBoundary(Iterable<? extends Position> iterable) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (Position position : iterable) {
            if (position == null) continue;
            arrayList.add(position);
        }
        if (arrayList.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (arrayList.size() > 0 && !((Position)arrayList.get(0)).equals(arrayList.get(arrayList.size() - 1))) {
            arrayList.add((Position)arrayList.get(0));
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public void addInnerBoundary(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.boundaries.add(this.fillBoundary(iterable));
        this.reset();
    }

    public List<List<? extends Position>> getBoundaries() {
        return this.boundaries;
    }

    public Object getTextureImageSource() {
        return this.imageSource;
    }

    protected WWTexture getTexture() {
        return this.texture;
    }

    public float[] getTextureCoords() {
        if (this.textureCoordsBuffer == null) {
            return null;
        }
        float[] fArray = new float[this.textureCoordsBuffer.limit()];
        this.textureCoordsBuffer.get(fArray, 0, fArray.length);
        return fArray;
    }

    public void setTextureImageSource(Object object, float[] fArray, int n) {
        if (object == null) {
            this.texture = null;
            this.textureCoordsBuffer = null;
            return;
        }
        if (fArray == null) {
            String string = Logging.getMessage("generic.ListIsEmpty");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n < 3 || fArray.length < 2 * n) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.texture = this.makeTexture(this.imageSource);
        boolean bl = fArray[0] != fArray[n - 2] || fArray[1] != fArray[n - 1];
        int n2 = 2 * (n + (bl ? 1 : 0));
        if (this.textureCoordsBuffer == null || this.textureCoordsBuffer.capacity() < n2) {
            this.textureCoordsBuffer = BufferUtil.newFloatBuffer(n2);
        } else {
            this.textureCoordsBuffer.limit(this.textureCoordsBuffer.capacity());
            this.textureCoordsBuffer.rewind();
        }
        for (int i = 0; i < 2 * n; ++i) {
            this.textureCoordsBuffer.put(fArray[i]);
        }
        if (bl) {
            this.textureCoordsBuffer.put(this.textureCoordsBuffer.get(0));
            this.textureCoordsBuffer.put(this.textureCoordsBuffer.get(1));
        }
    }

    @Override
    public Position getReferencePosition() {
        if (this.referencePosition != null) {
            return this.referencePosition;
        }
        if (this.outerBoundary().size() > 0) {
            this.referencePosition = this.outerBoundary().get(0);
        }
        return this.referencePosition;
    }

    public Double getRotation() {
        return this.rotation;
    }

    public void setRotation(Double d) {
        this.rotation = d;
        this.reset();
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        Extent extent = super.getExtent(globe, d);
        if (extent != null) {
            return extent;
        }
        return super.computeExtentFromPositions(globe, d, this.getOuterBoundary());
    }

    protected Extent computeExtent(BoundaryInfo boundaryInfo, Vec4 vec4) {
        if (boundaryInfo == null || boundaryInfo.vertices == null) {
            return null;
        }
        Box box = Box.computeBoundingBox(Arrays.asList(boundaryInfo.vertices));
        return box != null ? box.translate(vec4) : null;
    }

    @Override
    public Sector getSector() {
        if (this.sector == null && this.isOuterBoundaryValid()) {
            this.sector = Sector.boundingSector(this.getOuterBoundary());
        }
        return this.sector;
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        return this.getTexture() != null && this.textureCoordsBuffer != null;
    }

    @Override
    protected boolean shouldUseVBOs(DrawContext drawContext) {
        return this.numPositions > VBO_THRESHOLD && super.shouldUseVBOs(drawContext);
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        if (this.getCurrent().coordBuffer == null) {
            return true;
        }
        if (drawContext.getVerticalExaggeration() != this.getCurrent().getVerticalExaggeration()) {
            return true;
        }
        if (this.mustApplyLighting(drawContext, null) && this.getCurrent().normalBuffer == null) {
            return true;
        }
        if (this.getAltitudeMode() == 0 && this.getCurrent().getGlobeStateKey() != null && this.getCurrent().getGlobeStateKey().equals(drawContext.getGlobe().getGlobeStateKey(drawContext))) {
            return false;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    public void render(DrawContext drawContext) {
        if (!this.isOuterBoundaryValid()) {
            return;
        }
        super.render(drawContext);
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        if (drawContext.getSurfaceGeometry() == null || !this.isOuterBoundaryValid()) {
            return false;
        }
        this.getCurrent().setRotationMatrix(this.getRotation() != null ? this.computeRotationMatrix(drawContext.getGlobe()) : null);
        this.createMinimalGeometry(drawContext, this.getCurrent());
        if (this.getCurrent().getExtent() == null || drawContext.isSmall(this.getExtent(), 1)) {
            return false;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        this.createFullGeometry(drawContext, drawContext.getTerrain(), this.getCurrent(), true);
        return true;
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        return this.getCurrent().coordBuffer != null && this.isOuterBoundaryValid();
    }

    @Override
    protected OGLStackHandler beginDrawing(DrawContext drawContext, int n) {
        OGLStackHandler oGLStackHandler = super.beginDrawing(drawContext, n);
        if (!drawContext.isPickingMode()) {
            oGLStackHandler.pushTextureIdentity(drawContext.getGL());
        }
        return oGLStackHandler;
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
        if (this.shouldUseVBOs(drawContext)) {
            int[] nArray = this.getVboIds(drawContext);
            if (nArray != null) {
                this.doDrawOutlineVBO(drawContext, nArray, this.getCurrent());
            } else {
                this.doDrawOutlineVA(drawContext, this.getCurrent());
            }
        } else {
            this.doDrawOutlineVA(drawContext, this.getCurrent());
        }
    }

    protected void doDrawOutlineVA(DrawContext drawContext, ShapeData shapeData) {
        GL gL = drawContext.getGL();
        gL.glVertexPointer(3, 5126, 0, shapeData.coordBuffer.rewind());
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL.glNormalPointer(5126, 0, shapeData.normalBuffer.rewind());
        }
        int n = 0;
        for (BoundaryInfo boundaryInfo : shapeData) {
            gL.glDrawArrays(3, n, boundaryInfo.vertices.length);
            n += boundaryInfo.vertices.length;
        }
    }

    protected void doDrawOutlineVBO(DrawContext drawContext, int[] nArray, ShapeData shapeData) {
        GL gL = drawContext.getGL();
        gL.glBindBuffer(34962, nArray[0]);
        gL.glVertexPointer(3, 5126, 0, 0L);
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL.glNormalPointer(5126, 0, 4 * shapeData.normalBufferPosition);
        }
        int n = 0;
        for (BoundaryInfo boundaryInfo : shapeData) {
            gL.glDrawArrays(3, n, boundaryInfo.vertices.length);
            n += boundaryInfo.vertices.length;
        }
        gL.glBindBuffer(34962, 0);
    }

    @Override
    protected void doDrawInterior(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (!drawContext.isPickingMode() && this.mustApplyTexture(drawContext) && this.getTexture().bind(drawContext)) {
            this.getTexture().applyInternalTransform(drawContext);
            gL.glTexCoordPointer(2, 5126, 0, this.textureCoordsBuffer.rewind());
            drawContext.getGL().glEnable(3553);
            gL.glEnableClientState(32888);
        } else {
            drawContext.getGL().glDisable(3553);
            gL.glDisableClientState(32888);
        }
        if (this.shouldUseVBOs(drawContext)) {
            int[] nArray = this.getVboIds(drawContext);
            if (nArray != null) {
                this.doDrawInteriorVBO(drawContext, nArray, this.getCurrent());
            } else {
                this.doDrawInteriorVA(drawContext, this.getCurrent());
            }
        } else {
            this.doDrawInteriorVA(drawContext, this.getCurrent());
        }
    }

    protected void doDrawInteriorVA(DrawContext drawContext, ShapeData shapeData) {
        GL gL = drawContext.getGL();
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL.glNormalPointer(5126, 0, shapeData.normalBuffer.rewind());
        }
        FloatBuffer floatBuffer = shapeData.coordBuffer;
        gL.glVertexPointer(3, 5126, 0, floatBuffer.rewind());
        IntBuffer intBuffer = shapeData.interiorIndicesBuffer;
        gL.glDrawElements(4, intBuffer.limit(), 5125, intBuffer);
    }

    protected void doDrawInteriorVBO(DrawContext drawContext, int[] nArray, ShapeData shapeData) {
        GL gL = drawContext.getGL();
        gL.glBindBuffer(34962, nArray[0]);
        gL.glBindBuffer(34963, nArray[1]);
        gL.glVertexPointer(3, 5126, 0, 0L);
        if (!drawContext.isPickingMode() && this.mustApplyLighting(drawContext, null)) {
            gL.glNormalPointer(5126, 0, 4 * shapeData.normalBufferPosition);
        }
        gL.glDrawElements(4, shapeData.interiorIndicesBuffer.limit(), 5125, 0L);
        gL.glBindBuffer(34962, 0);
        gL.glBindBuffer(34963, 0);
    }

    protected Matrix computeRotationMatrix(Globe globe) {
        if (this.getRotation() == null) {
            return null;
        }
        Sector sector = this.getSector();
        if (sector == null) {
            return null;
        }
        Vec4[] vec4Array = sector.computeCornerPoints(globe, 1.0);
        Vec4 vec4 = sector.computeCenterPoint(globe, 1.0);
        Matrix matrix = Matrix.fromTranslation(vec4.multiply3(-1.0));
        Matrix matrix2 = Matrix.fromTranslation(vec4);
        Vec4 vec42 = vec4Array[2].subtract3(vec4Array[0]).cross3(vec4Array[3].subtract3(vec4Array[1])).normalize3();
        Matrix matrix3 = Matrix.fromAxisAngle(Angle.fromDegrees(this.getRotation()), vec42);
        return matrix2.multiply(matrix3).multiply(matrix);
    }

    protected void createMinimalGeometry(DrawContext drawContext, ShapeData shapeData) {
        Matrix matrix = shapeData.getRotationMatrix();
        Vec4 vec4 = this.computeReferencePoint(drawContext.getTerrain(), matrix);
        if (vec4 == null) {
            return;
        }
        shapeData.setReferencePoint(vec4);
        this.computeBoundaryVertices(drawContext.getTerrain(), shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint(), matrix);
        if (shapeData.getExtent() == null || this.getAltitudeMode() != 0) {
            shapeData.setExtent(this.computeExtent(shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint()));
        }
        shapeData.setEyeDistance(this.computeEyeDistance(drawContext, shapeData));
        shapeData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        shapeData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
    }

    protected double computeEyeDistance(DrawContext drawContext, ShapeData shapeData) {
        double d = Double.MAX_VALUE;
        Vec4 vec4 = drawContext.getView().getEyePoint();
        for (Vec4 vec42 : shapeData.getOuterBoundaryInfo().vertices) {
            double d2 = vec42.add3(shapeData.getReferencePoint()).distanceTo3(vec4);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    protected Vec4 computeReferencePoint(Terrain terrain, Matrix matrix) {
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        Vec4 vec4 = terrain.getSurfacePoint(position.getLatitude(), position.getLongitude(), 0.0);
        if (vec4 == null) {
            return null;
        }
        return matrix != null ? vec4.transformBy4(matrix) : vec4;
    }

    protected void createFullGeometry(DrawContext drawContext, Terrain terrain, ShapeData shapeData, boolean bl) {
        this.createVertices(terrain, shapeData, bl);
        this.createGeometry(drawContext, shapeData);
        if (this.mustApplyLighting(drawContext, null)) {
            this.createNormals(shapeData);
        } else {
            shapeData.normalBuffer = null;
        }
    }

    protected void createVertices(Terrain terrain, ShapeData shapeData, boolean bl) {
        for (BoundaryInfo boundaryInfo : shapeData) {
            if (boundaryInfo == shapeData.getOuterBoundaryInfo() && bl) continue;
            this.computeBoundaryVertices(terrain, boundaryInfo, shapeData.getReferencePoint(), shapeData.getRotationMatrix());
        }
    }

    protected void computeBoundaryVertices(Terrain terrain, BoundaryInfo boundaryInfo, Vec4 vec4, Matrix matrix) {
        int n = boundaryInfo.positions.size();
        Vec4[] vec4Array = new Vec4[n];
        for (int i = 0; i < n; ++i) {
            vec4Array[i] = matrix == null ? this.computePoint(terrain, boundaryInfo.positions.get(i)).subtract3(vec4) : this.computePoint(terrain, boundaryInfo.positions.get(i)).transformBy4(matrix).subtract3(vec4);
        }
        boundaryInfo.vertices = vec4Array;
    }

    protected void createGeometry(DrawContext drawContext, ShapeData shapeData) {
        int n = this.numPositions * (this.mustApplyLighting(drawContext, null) ? 6 : 3);
        if (shapeData.coordBuffer != null && shapeData.coordBuffer.capacity() >= n) {
            shapeData.coordBuffer.clear();
        } else {
            shapeData.coordBuffer = BufferUtil.newFloatBuffer(n);
        }
        shapeData.normalBufferPosition = this.numPositions * 3;
        for (BoundaryInfo boundaryInfo : shapeData) {
            boundaryInfo.vertexBuffer = WWBufferUtil.copyArrayToBuffer(boundaryInfo.vertices, shapeData.coordBuffer.slice());
            shapeData.coordBuffer.position(shapeData.coordBuffer.position() + boundaryInfo.vertexBuffer.limit());
        }
        if (shapeData.cb == null && !shapeData.tessellationError) {
            this.createTessllationGeometry(drawContext, shapeData);
        }
        if (shapeData.refillIndexBuffer) {
            this.generateInteriorIndices(shapeData);
        }
    }

    protected void createNormals(ShapeData shapeData) {
        shapeData.coordBuffer.position(shapeData.normalBufferPosition);
        shapeData.normalBuffer = shapeData.coordBuffer.slice();
        for (BoundaryInfo boundaryInfo : shapeData) {
            this.computeBoundaryNormals(boundaryInfo, shapeData.normalBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillVBO(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        ShapeData shapeData = this.getCurrent();
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(shapeData.getVboCacheKey());
        if (nArray == null) {
            int n = shapeData.coordBuffer.limit() * 4;
            nArray = new int[2];
            gL.glGenBuffers(nArray.length, nArray, 0);
            drawContext.getGpuResourceCache().put(shapeData.getVboCacheKey(), nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n += shapeData.interiorIndicesBuffer.limit() * 4);
            shapeData.refillIndexVBO = true;
        }
        if (shapeData.refillIndexVBO) {
            try {
                IntBuffer intBuffer = shapeData.interiorIndicesBuffer;
                gL.glBindBuffer(34963, nArray[1]);
                gL.glBufferData(34963, intBuffer.limit() * 4, intBuffer.rewind(), 35048);
                shapeData.refillIndexVBO = false;
            }
            finally {
                gL.glBindBuffer(34963, 0);
            }
        }
        try {
            FloatBuffer floatBuffer = this.getCurrent().coordBuffer;
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, floatBuffer.limit() * 4, floatBuffer.rewind(), 35044);
        }
        finally {
            gL.glBindBuffer(34962, 0);
        }
    }

    protected FloatBuffer computeBoundaryNormals(BoundaryInfo boundaryInfo, FloatBuffer floatBuffer) {
        int n = boundaryInfo.positions.size();
        Vec4[] vec4Array = boundaryInfo.vertices;
        Vec4 vec4 = vec4Array[1].subtract3(vec4Array[0]);
        Vec4 vec42 = vec4Array[n - 2].subtract3(vec4Array[0]);
        double d = vec4.y * vec42.z - vec4.z * vec42.y;
        double d2 = vec4.z * vec42.x - vec4.x * vec42.z;
        double d3 = vec4.x * vec42.y - vec4.y * vec42.x;
        for (int i = 1; i < n - 1; ++i) {
            vec4 = vec4Array[i + 1].subtract3(vec4Array[i]);
            vec42 = vec4Array[i - 1].subtract3(vec4Array[i]);
            d += vec4.y * vec42.z - vec4.z * vec42.y;
            d2 += vec4.z * vec42.x - vec4.x * vec42.z;
            d3 += vec4.x * vec42.y - vec4.y * vec42.x;
        }
        double d4 = Math.sqrt((d /= (double)(n - 1)) * d + (d2 /= (double)(n - 1)) * d2 + (d3 /= (double)(n - 1)) * d3);
        for (int i = 0; i < n; ++i) {
            floatBuffer.put((float)(d / d4)).put((float)(d2 / d4)).put((float)(d3 / d4));
        }
        return floatBuffer;
    }

    protected void createTessllationGeometry(DrawContext drawContext, ShapeData shapeData) {
        block3: {
            try {
                Vec4 vec4 = this.computePolygonNormal(drawContext, shapeData);
                if (vec4 == null) {
                    String string = Logging.getMessage("Geom.ShapeNormalVectorNotComputable", this);
                    Logging.logger().log(Level.SEVERE, string);
                    shapeData.tessellationError = true;
                    return;
                }
                this.tessellatePolygon(shapeData, vec4.normalize3());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                String string = Logging.getMessage("generic.ExceptionWhileTessellating", this);
                Logging.logger().log(Level.SEVERE, string, outOfMemoryError);
                shapeData.tessellationError = true;
                if (drawContext == null) break block3;
                drawContext.addRenderingException(new WWRuntimeException(string, outOfMemoryError));
            }
        }
    }

    protected Vec4 computePolygonNormal(DrawContext drawContext, ShapeData shapeData) {
        shapeData.coordBuffer.rewind();
        FloatBuffer floatBuffer = shapeData.coordBuffer.slice();
        floatBuffer.limit(this.numPositions * 3);
        Vec4 vec4 = WWMath.computeBufferNormal(floatBuffer, 0);
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computeSurfaceNormalAtLocation(this.getReferencePosition().getLatitude(), this.getReferencePosition().getLongitude());
        }
        return vec4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tessellatePolygon(ShapeData shapeData, Vec4 vec4) {
        GLU gLU = new GLU();
        GLUTessellatorSupport gLUTessellatorSupport = new GLUTessellatorSupport();
        shapeData.cb = new GLUTessellatorSupport.CollectIndexListsCallback();
        gLUTessellatorSupport.beginTessellation(gLU, shapeData.cb, vec4);
        try {
            double[] dArray = new double[3];
            gLU.gluTessBeginPolygon(gLUTessellatorSupport.getGLUtessellator(), null);
            int n = 0;
            for (BoundaryInfo boundaryInfo : shapeData) {
                gLU.gluTessBeginContour(gLUTessellatorSupport.getGLUtessellator());
                FloatBuffer floatBuffer = boundaryInfo.vertexBuffer;
                for (int i = 0; i < boundaryInfo.positions.size(); ++i) {
                    dArray[0] = floatBuffer.get(i * 3);
                    dArray[1] = floatBuffer.get(i * 3 + 1);
                    dArray[2] = floatBuffer.get(i * 3 + 2);
                    gLU.gluTessVertex(gLUTessellatorSupport.getGLUtessellator(), dArray, 0, n++);
                }
                gLU.gluTessEndContour(gLUTessellatorSupport.getGLUtessellator());
            }
            gLU.gluTessEndPolygon(gLUTessellatorSupport.getGLUtessellator());
        }
        finally {
            gLUTessellatorSupport.endTessellation(gLU);
        }
    }

    protected void generateInteriorIndices(ShapeData shapeData) {
        GLUTessellatorSupport.CollectIndexListsCallback collectIndexListsCallback = shapeData.cb;
        int n = this.countTriangleVertices(collectIndexListsCallback.getPrims(), collectIndexListsCallback.getPrimTypes());
        if (shapeData.interiorIndicesBuffer == null || shapeData.interiorIndicesBuffer.capacity() < n) {
            shapeData.interiorIndicesBuffer = BufferUtil.newIntBuffer(n);
        } else {
            shapeData.interiorIndicesBuffer.clear();
        }
        block5: for (int i = 0; i < collectIndexListsCallback.getPrims().size(); ++i) {
            switch (collectIndexListsCallback.getPrimTypes().get(i)) {
                case 4: {
                    Triangle.expandTriangles(collectIndexListsCallback.getPrims().get(i), shapeData.interiorIndicesBuffer);
                    continue block5;
                }
                case 6: {
                    Triangle.expandTriangleFan(collectIndexListsCallback.getPrims().get(i), shapeData.interiorIndicesBuffer);
                    continue block5;
                }
                case 5: {
                    Triangle.expandTriangleStrip(collectIndexListsCallback.getPrims().get(i), shapeData.interiorIndicesBuffer);
                }
            }
        }
        shapeData.interiorIndicesBuffer.flip();
        shapeData.refillIndexBuffer = false;
        shapeData.refillIndexVBO = true;
    }

    protected boolean isSameAsPreviousTerrain(Terrain terrain) {
        if (terrain == null || this.previousIntersectionTerrain == null || terrain != this.previousIntersectionTerrain) {
            return false;
        }
        if (terrain.getVerticalExaggeration() != this.previousIntersectionTerrain.getVerticalExaggeration()) {
            return false;
        }
        return this.previousIntersectionGlobeStateKey != null && terrain.getGlobe().getGlobeStateKey().equals(this.previousIntersectionGlobeStateKey);
    }

    public void clearIntersectionGeometry() {
        this.previousIntersectionGlobeStateKey = null;
        this.previousIntersectionShapeData = null;
        this.previousIntersectionTerrain = null;
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        ShapeData shapeData;
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        if (!this.isOuterBoundaryValid()) {
            return null;
        }
        ShapeData shapeData2 = shapeData = this.isSameAsPreviousTerrain(terrain) ? this.previousIntersectionShapeData : null;
        if (shapeData == null) {
            shapeData = this.createIntersectionGeometry(terrain);
            if (shapeData == null) {
                return null;
            }
            this.previousIntersectionShapeData = shapeData;
            this.previousIntersectionTerrain = terrain;
            this.previousIntersectionGlobeStateKey = terrain.getGlobe().getGlobeStateKey();
        }
        if (shapeData.getExtent() != null && shapeData.getExtent().intersect(line) == null) {
            return null;
        }
        Line line2 = new Line(line.getOrigin().subtract3(shapeData.getReferencePoint()), line.getDirection());
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        this.intersect(line2, shapeData, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        for (Intersection intersection : arrayList) {
            Vec4 vec4 = intersection.getIntersectionPoint().add3(shapeData.getReferencePoint());
            intersection.setIntersectionPoint(vec4);
            Position position2 = terrain.getGlobe().computePositionFromPoint(vec4);
            Vec4 vec42 = terrain.getSurfacePoint(position2.getLatitude(), position2.getLongitude(), 0.0);
            double d = Math.sqrt(vec4.dotSelf3()) - Math.sqrt(vec42.dotSelf3());
            intersection.setIntersectionPosition(new Position(position2, d));
            intersection.setObject(this);
        }
        return arrayList;
    }

    protected ShapeData createIntersectionGeometry(Terrain terrain) {
        ShapeData shapeData = new ShapeData(null, this);
        Matrix matrix = this.getRotation() != null ? this.computeRotationMatrix(terrain.getGlobe()) : null;
        shapeData.setReferencePoint(this.computeReferencePoint(terrain, matrix));
        if (shapeData.getReferencePoint() == null) {
            return null;
        }
        this.createVertices(terrain, shapeData, false);
        this.createGeometry(null, shapeData);
        shapeData.setExtent(this.computeExtent(shapeData.getOuterBoundaryInfo(), shapeData.getReferencePoint()));
        return shapeData;
    }

    protected void intersect(Line line, ShapeData shapeData, List<Intersection> list) throws InterruptedException {
        if (shapeData.cb.getPrims() == null) {
            return;
        }
        IntBuffer intBuffer = shapeData.interiorIndicesBuffer;
        intBuffer.rewind();
        List<Intersection> list2 = Triangle.intersectTriangleTypes(line, shapeData.coordBuffer, intBuffer, 4);
        if (list2 != null && list2.size() > 0) {
            list.addAll(list2);
        }
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isOuterBoundaryValid()) {
            return;
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        ArrayList<List<? extends Position>> arrayList = new ArrayList<List<? extends Position>>(this.boundaries.size());
        for (List<? extends Position> list : this.boundaries) {
            List<Position> list2;
            if (list == null || list.size() == 0 || (list2 = Position.computeShiftedPositions(position2, position, list)) == null) continue;
            arrayList.add(list2);
        }
        this.boundaries = arrayList;
        this.setReferencePosition(position);
        this.reset();
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("Polygon");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters("0");
        xMLStreamWriter.writeEndElement();
        String string = KMLExportUtil.kmlAltitudeMode(this.getAltitudeMode());
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        this.writeKMLBoundaries(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    protected void writeKMLBoundaries(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        Iterable<? extends LatLon> iterable = this.getOuterBoundary();
        if (iterable != null) {
            xMLStreamWriter.writeStartElement("outerBoundaryIs");
            this.exportBoundaryAsLinearRing(xMLStreamWriter, iterable);
            xMLStreamWriter.writeEndElement();
        }
        for (int i = 1; i < this.boundaries.size(); ++i) {
            xMLStreamWriter.writeStartElement("innerBoundaryIs");
            this.exportBoundaryAsLinearRing(xMLStreamWriter, (Iterable<? extends LatLon>)this.boundaries.get(i));
            xMLStreamWriter.writeEndElement();
        }
    }

    protected void exportBoundaryAsLinearRing(XMLStreamWriter xMLStreamWriter, Iterable<? extends LatLon> iterable) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("LinearRing");
        xMLStreamWriter.writeStartElement("coordinates");
        for (LatLon latLon : iterable) {
            if (latLon instanceof Position) {
                xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f,%f ", latLon.getLongitude().getDegrees(), latLon.getLatitude().getDegrees(), ((Position)latLon).getAltitude()));
                continue;
            }
            xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f ", latLon.getLongitude().getDegrees(), latLon.getLatitude().getDegrees()));
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    protected static class BoundaryInfo {
        protected List<? extends Position> positions;
        protected Vec4[] vertices;
        protected FloatBuffer vertexBuffer;

        public BoundaryInfo(List<? extends Position> list) {
            this.positions = list;
        }
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData
    implements Iterable<BoundaryInfo> {
        protected List<BoundaryInfo> boundaries = new ArrayList<BoundaryInfo>();
        protected Matrix rotationMatrix;
        protected FloatBuffer coordBuffer;
        protected FloatBuffer normalBuffer;
        protected int normalBufferPosition;
        protected GLUTessellatorSupport.CollectIndexListsCallback cb;
        protected IntBuffer interiorIndicesBuffer;
        protected boolean tessellationError = false;
        protected boolean refillIndexBuffer = true;
        protected boolean refillIndexVBO = true;

        public ShapeData(DrawContext drawContext, Polygon polygon) {
            super(drawContext, polygon.minExpiryTime, polygon.maxExpiryTime);
            if (polygon.boundaries.size() < 1) {
                this.boundaries.add(new BoundaryInfo(new ArrayList()));
                return;
            }
            for (List<? extends Position> list : polygon.boundaries) {
                this.boundaries.add(new BoundaryInfo(list));
            }
        }

        protected BoundaryInfo getOuterBoundaryInfo() {
            return this.boundaries.get(0);
        }

        @Override
        public Iterator<BoundaryInfo> iterator() {
            return this.boundaries.iterator();
        }

        public Matrix getRotationMatrix() {
            return this.rotationMatrix;
        }

        public void setRotationMatrix(Matrix matrix) {
            this.rotationMatrix = matrix;
        }
    }
}

