/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class LazilyLoadedTexture
extends AVListImpl
implements WWTexture {
    protected Object imageSource;
    protected boolean useMipMaps;
    protected boolean useAnisotropy = true;
    protected Integer width;
    protected Integer height;
    protected TextureCoords texCoords;
    protected volatile TextureData textureData;
    protected boolean textureInitializationFailed = false;
    protected boolean hasMipmapData = false;
    protected FileStore fileStore = WorldWind.getDataFileStore();
    protected final Object fileLock = new Object();
    protected PropertyChangeListener listener;

    public LazilyLoadedTexture(Object object) {
        this(object, true);
    }

    public LazilyLoadedTexture(Object object, boolean bl) {
        this.initialize(object, bl, null);
    }

    protected void initialize(Object object, boolean bl, PropertyChangeListener propertyChangeListener) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageSource = object;
        this.useMipMaps = bl;
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public Object getImageSource() {
        return this.imageSource;
    }

    protected boolean isBufferedImageSource() {
        return this.getImageSource() instanceof BufferedImage;
    }

    public int getWidth() {
        return this.width != null ? this.width : -1;
    }

    public int getHeight() {
        return this.height != null ? this.height : -1;
    }

    @Override
    public int getWidth(DrawContext drawContext) {
        return this.getWidth();
    }

    @Override
    public int getHeight(DrawContext drawContext) {
        return this.getHeight();
    }

    public boolean isUseMipMaps() {
        return this.useMipMaps;
    }

    @Override
    public TextureCoords getTexCoords() {
        return this.texCoords;
    }

    @Override
    public boolean isTextureCurrent(DrawContext drawContext) {
        return this.getTexture(drawContext) != null;
    }

    public boolean isUseAnisotropy() {
        return this.useAnisotropy;
    }

    public void setUseAnisotropy(boolean bl) {
        this.useAnisotropy = bl;
    }

    @Override
    public boolean isTextureInitializationFailed() {
        return this.textureInitializationFailed;
    }

    protected Texture getTexture(DrawContext drawContext) {
        if (this.getImageSource() == null) {
            return null;
        }
        Texture texture = drawContext.getTextureCache().getTexture(this.getImageSource());
        if (this.width == null && texture != null) {
            this.width = texture.getWidth();
            this.height = texture.getHeight();
            this.texCoords = texture.getImageTexCoords();
        }
        return texture;
    }

    protected TextureData getTextureData() {
        return this.textureData;
    }

    protected void setTextureData(TextureData textureData) {
        this.textureData = textureData;
        if (textureData != null && textureData.getMipmapData() != null) {
            this.hasMipmapData = true;
        }
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        if (this.isTextureInitializationFailed()) {
            return false;
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTexture(drawContext);
        if (texture == null) {
            texture = this.requestTexture(drawContext);
        }
        if (texture != null) {
            texture.bind();
            return true;
        }
        return false;
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTexture(drawContext);
        if (texture == null) {
            texture = this.requestTexture(drawContext);
        }
        if (texture == null) {
            return;
        }
        if (texture.getMustFlipVertically()) {
            GL gL = GLContext.getCurrent().getGL();
            gL.glMatrixMode(5890);
            gL.glLoadIdentity();
            gL.glScaled(1.0, -1.0, 1.0);
            gL.glTranslated(0.0, -1.0, 0.0);
        }
    }

    protected Texture requestTexture(DrawContext drawContext) {
        if (this.isBufferedImageSource()) {
            return this.makeBufferedImageTexture(drawContext);
        }
        if (this.getTextureData() != null && this.getTexture(drawContext) == null) {
            return this.makeTextureFromTextureData(drawContext);
        }
        if (WorldWind.getTaskService().isFull()) {
            return null;
        }
        Runnable runnable = this.createRequestTask();
        if (WorldWind.getTaskService().contains(runnable)) {
            return null;
        }
        this.listener = drawContext.getCurrentLayer() != null ? drawContext.getCurrentLayer() : drawContext.getLayers();
        WorldWind.getTaskService().addTask(runnable);
        return null;
    }

    protected Runnable createRequestTask() {
        return new RequestTask(this);
    }

    protected Texture makeBufferedImageTexture(DrawContext drawContext) {
        if (this.getImageSource() == null || !(this.getImageSource() instanceof BufferedImage)) {
            String string = Logging.getMessage("generic.NotABufferedImage");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            TextureData textureData = TextureIO.newTextureData((BufferedImage)this.getImageSource(), this.isUseMipMaps());
            if (textureData == null) {
                return null;
            }
            this.setTextureData(textureData);
            return this.makeTextureFromTextureData(drawContext);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
            Logging.logger().log(Level.SEVERE, string, exception);
            this.textureInitializationFailed = true;
            return null;
        }
    }

    protected Texture makeTextureFromTextureData(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.getTextureData() == null) {
            String string = Logging.getMessage("nullValue.TextureDataIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            Texture texture = TextureIO.newTexture(this.getTextureData());
            if (texture == null) {
                this.textureInitializationFailed = true;
                return null;
            }
            this.width = texture.getWidth();
            this.height = texture.getHeight();
            this.texCoords = texture.getImageTexCoords();
            this.setTextureParameters(drawContext, texture);
            drawContext.getTextureCache().put(this.getImageSource(), texture);
            this.setTextureData(null);
            return texture;
        }
        catch (Exception exception) {
            String string = this.isBufferedImageSource() ? "BufferedImage" : this.getImageSource().toString();
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToCreateTexture", string);
            Logging.logger().log(Level.SEVERE, string2, exception);
            return null;
        }
    }

    protected void setTextureParameters(DrawContext drawContext, Texture texture) {
        boolean bl = this.useMipMaps && (this.getTextureData().getMipmapData() != null || texture.isUsingAutoMipmapGeneration());
        GL gL = drawContext.getGL();
        gL.glTexParameteri(3553, 10241, bl ? 9987 : 9729);
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
        if (this.isUseAnisotropy() && bl) {
            double d = drawContext.getGLRuntimeCapabilities().getMaxTextureAnisotropy();
            if (drawContext.getGLRuntimeCapabilities().isUseAnisotropicTextureFilter() && d >= 2.0) {
                gL.glTexParameterf(3553, 34046, (float)d);
            }
        }
    }

    protected void notifyTextureLoaded() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "gov.nasa.worldwind.avkey.Texture", null, this));
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadTextureData(URL uRL) {
        Object object = this.fileLock;
        synchronized (object) {
            TextureData textureData = this.readImage(uRL);
            if (textureData != null) {
                this.setTextureData(textureData);
            }
        }
        return this.getTextureData() != null;
    }

    protected TextureData readImage(URL uRL) {
        try {
            return TextureIO.newTextureData(uRL, this.isUseMipMaps(), null);
        }
        catch (Exception exception) {
            String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", this.getImageSource());
            Logging.logger().log(Level.SEVERE, string, exception);
            this.textureInitializationFailed = true;
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LazilyLoadedTexture lazilyLoadedTexture = (LazilyLoadedTexture)object;
        return !(this.imageSource != null ? !this.imageSource.equals(lazilyLoadedTexture.imageSource) : lazilyLoadedTexture.imageSource != null);
    }

    public int hashCode() {
        return this.imageSource != null ? this.imageSource.hashCode() : 0;
    }

    protected static class RequestTask
    implements Runnable {
        protected final LazilyLoadedTexture wwTexture;

        protected RequestTask(LazilyLoadedTexture lazilyLoadedTexture) {
            if (lazilyLoadedTexture == null) {
                String string = Logging.getMessage("nullValue.TextureIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.wwTexture = lazilyLoadedTexture;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            URL uRL = this.wwTexture.fileStore.requestFile(this.wwTexture.getImageSource().toString());
            if (uRL != null && this.wwTexture.loadTextureData(uRL)) {
                this.wwTexture.notifyTextureLoaded();
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.wwTexture == null ? requestTask.wwTexture != null : !this.wwTexture.equals(requestTask.wwTexture));
        }

        public int hashCode() {
            return this.wwTexture != null ? this.wwTexture.hashCode() : 0;
        }

        public String toString() {
            return this.wwTexture.getImageSource().toString();
        }
    }
}

