/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wfs;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.ogc.ows.OWSCapabilitiesBase;
import gov.nasa.worldwind.ogc.wfs.WFSFeatureType;
import gov.nasa.worldwind.ogc.wfs.WFSFeatureTypeListParser;
import gov.nasa.worldwind.ogc.wfs.WFSParserContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WFSCapabilities
extends OWSCapabilitiesBase {
    protected List<WFSFeatureType> featureTypes = new ArrayList<WFSFeatureType>();
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;

    public WFSCapabilities() {
        super("http://www.opengis.net/wfs/2.0");
    }

    public WFSCapabilities(Object object) {
        super("http://www.opengis.net/wfs/2.0");
        if (object == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.eventReader = this.createReader(object);
        if (this.eventReader == null) {
            throw new WWRuntimeException(Logging.getMessage("XML.UnableToOpenDocument", object));
        }
        this.initializeParser();
    }

    protected void initializeParser() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        return new WFSParserContext(xMLEventReader, this.getNamespaceURI());
    }

    protected XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public WFSCapabilities parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.getParserContext();
        if (xMLEventParserContext == null) {
            return null;
        }
        QName qName = new QName(this.getNamespaceURI(), "WFS_Capabilities");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEventParserContext.isStartElement(xMLEvent, qName)) {
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof WFSFeatureTypeListParser) {
            this.addAllFeatureTypes((WFSFeatureTypeListParser)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addAllFeatureTypes(Iterable<WFSFeatureType> iterable) {
        for (WFSFeatureType wFSFeatureType : iterable) {
            this.featureTypes.add(wFSFeatureType);
        }
    }

    public List<WFSFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }
}

