/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSBasicIdentification;
import gov.nasa.worldwind.ogc.ows.OWSBoundingBox;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSIdentification
extends OWSBasicIdentification {
    protected QName OUTPUT_FORMAT;
    protected QName AVAILABLE_CRS;
    protected List<OWSBoundingBox> boundingBoxes = new ArrayList<OWSBoundingBox>();
    protected Set<String> outputFormats = new HashSet<String>();
    protected Set<String> availableCRS = new HashSet<String>();

    public OWSIdentification(String string) {
        super(string);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.OUTPUT_FORMAT = new QName(this.getNamespaceURI(), "OutputFormat");
        this.AVAILABLE_CRS = new QName(this.getNamespaceURI(), "AvailableCRS");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.OUTPUT_FORMAT)) {
            this.addOutputFormat((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.AVAILABLE_CRS)) {
            this.addAvailableCRS((String)object);
        } else if (object instanceof OWSBoundingBox) {
            this.addBoundingBox((OWSBoundingBox)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addBoundingBox(OWSBoundingBox oWSBoundingBox) {
        this.boundingBoxes.add(oWSBoundingBox);
    }

    protected void addOutputFormat(String string) {
        this.outputFormats.add(string);
    }

    protected void addAvailableCRS(String string) {
        this.availableCRS.add(string);
    }

    public List<OWSBoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public Set<String> getOutputFormats() {
        return this.outputFormats;
    }

    public Set<String> getAvailableCRS() {
        return this.availableCRS;
    }
}

