/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.ogc.ows.OWSException;
import gov.nasa.worldwind.ogc.ows.OWSParserContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.WWXML;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;

public class OWSExceptionReport
extends AbstractXMLEventParser {
    protected List<OWSException> exceptions = new ArrayList<OWSException>();
    protected XMLEventReader eventReader;
    protected XMLEventParserContext parserContext;

    public OWSExceptionReport() {
        super("http://www.opengis.net/ows/1.1");
    }

    public OWSExceptionReport(Object object) {
        super("http://www.opengis.net/ows/1.1");
        if (object == null) {
            String string = Logging.getMessage("nullValue.DocumentSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.eventReader = this.createReader(object);
        if (this.eventReader == null) {
            throw new WWRuntimeException(Logging.getMessage("XML.UnableToOpenDocument", object));
        }
        this.initializeParser();
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public void setVersion(String string) {
        this.setField("version", (Object)string);
    }

    public List<OWSException> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<OWSException> list) {
        this.exceptions = list;
    }

    public void addException(OWSException oWSException) {
        if (this.getExceptions() != null && oWSException != null) {
            this.getExceptions().add(oWSException);
        }
    }

    protected void initializeParser() {
        this.parserContext = this.createParserContext(this.eventReader);
    }

    protected XMLEventReader createReader(Object object) {
        return WWXML.openEventReader(object);
    }

    protected XMLEventParserContext createParserContext(XMLEventReader xMLEventReader) {
        return new OWSParserContext(xMLEventReader, this.getNamespaceURI());
    }

    protected XMLEventParserContext getParserContext() {
        return this.parserContext;
    }

    public OWSExceptionReport parse(Object ... objectArray) throws XMLStreamException {
        XMLEventParserContext xMLEventParserContext = this.getParserContext();
        if (xMLEventParserContext == null) {
            return null;
        }
        QName qName = new QName(this.getNamespaceURI(), "ExceptionReport");
        XMLEvent xMLEvent = xMLEventParserContext.nextEvent();
        while (xMLEventParserContext.hasNext()) {
            if (xMLEvent != null && xMLEventParserContext.isStartElement(xMLEvent, qName)) {
                super.parse(xMLEventParserContext, xMLEvent, objectArray);
                return this;
            }
            xMLEvent = xMLEventParserContext.nextEvent();
        }
        return null;
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (object instanceof OWSException) {
            this.addException((OWSException)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    public void export(Object object) throws XMLStreamException {
        XMLStreamWriter xMLStreamWriter;
        if (object == null) {
            String string = Logging.getMessage("nullValue.OutputIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
        } else {
            xMLStreamWriter = WWXML.openStreamWriter(object);
            bl = true;
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject", object);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.setDefaultNamespace(this.getNamespaceURI());
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement("ExceptionReport");
        xMLStreamWriter.writeDefaultNamespace(this.getNamespaceURI());
        if (!WWUtil.isEmpty(this.getVersion())) {
            xMLStreamWriter.writeAttribute("version", this.getVersion());
        }
        if (this.getExceptions() != null) {
            for (OWSException oWSException : this.getExceptions()) {
                try {
                    if (oWSException == null) continue;
                    oWSException.export(xMLStreamWriter);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.WARNING, Logging.getMessage("Export.UnableToExportObject", oWSException), exception);
                }
            }
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

