/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSKeywords;
import gov.nasa.worldwind.ogc.ows.OWSLanguageString;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSDescription
extends AbstractXMLEventParser {
    protected QName TITLE;
    protected QName ABSTRACT;
    protected List<OWSLanguageString> titles = new ArrayList<OWSLanguageString>();
    protected List<OWSLanguageString> abstracts = new ArrayList<OWSLanguageString>();
    protected List<OWSKeywords> keywordLists = new ArrayList<OWSKeywords>();

    public OWSDescription(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.TITLE = new QName(this.getNamespaceURI(), "Title");
        this.ABSTRACT = new QName(this.getNamespaceURI(), "Abstract");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.TITLE)) {
            this.addTitle((OWSLanguageString)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ABSTRACT)) {
            this.addAbstract((OWSLanguageString)object);
        } else if (object instanceof OWSKeywords) {
            this.addKeywordList((OWSKeywords)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addTitle(OWSLanguageString oWSLanguageString) {
        this.titles.add(oWSLanguageString);
    }

    protected void addAbstract(OWSLanguageString oWSLanguageString) {
        this.abstracts.add(oWSLanguageString);
    }

    protected void addKeywordList(OWSKeywords oWSKeywords) {
        this.keywordLists.add(oWSKeywords);
    }

    public List<OWSLanguageString> getTitles() {
        return this.titles;
    }

    public List<OWSLanguageString> getAbstracts() {
        return this.abstracts;
    }

    public List<OWSKeywords> getKeywordLists() {
        return this.keywordLists;
    }
}

