/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLIcon;
import gov.nasa.worldwind.ogc.kml.KMLLatLonBox;
import gov.nasa.worldwind.ogc.kml.gx.GXLatLongQuad;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class KMLSurfaceImageImpl
extends SurfaceImage
implements KMLRenderable {
    protected KMLGroundOverlay parent;
    protected boolean attributesResolved;
    protected boolean textureResolved;
    protected long iconRetrievalTime;
    protected boolean mustApplyRotation;

    public KMLSurfaceImageImpl(KMLTraversalContext kMLTraversalContext, KMLGroundOverlay kMLGroundOverlay) {
        Serializable serializable;
        Object object;
        this.parent = kMLGroundOverlay;
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLGroundOverlay == null) {
            String string = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        KMLLatLonBox kMLLatLonBox = kMLGroundOverlay.getLatLonBox();
        if (kMLLatLonBox != null) {
            object = KMLUtil.createSectorFromLatLonBox(kMLLatLonBox);
            this.initializeGeometry((Iterable<? extends LatLon>)object);
            serializable = kMLLatLonBox.getRotation();
            if (serializable != null) {
                this.mustApplyRotation = true;
            }
        } else {
            object = kMLGroundOverlay.getLatLonQuad();
            if (object != null && ((GXLatLongQuad)object).getCoordinates() != null) {
                this.initializeGeometry(((GXLatLongQuad)object).getCoordinates().list);
            }
        }
        object = kMLGroundOverlay.getColor();
        if (!WWUtil.isEmpty(object)) {
            serializable = WWUtil.decodeColorABGR((String)object);
            int n = ((Color)serializable).getAlpha();
            this.setOpacity((double)n / 255.0);
        }
        this.setPickEnabled(false);
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        boolean bl;
        if (this.mustResolveHref()) {
            String string = this.resolveHref();
            this.parent.getRoot().evictIfExpired(string, this.iconRetrievalTime);
            this.setImageSource((Object)string, this.getCorners());
            this.iconRetrievalTime = System.currentTimeMillis();
            this.textureResolved = false;
        }
        boolean bl2 = bl = !this.textureResolved && this.sourceTexture != null && this.sourceTexture.isTextureCurrent(drawContext);
        if (bl) {
            String string = this.resolveHref();
            long l = this.parent.getRoot().getExpiration(string);
            this.parent.getIcon().setExpirationTime(l);
            this.textureResolved = true;
        }
        if (this.mustApplyRotation) {
            this.applyRotation(drawContext);
            this.mustApplyRotation = false;
        }
        super.preRender(drawContext);
    }

    protected boolean mustResolveHref() {
        KMLIcon kMLIcon = this.parent.getIcon();
        if (kMLIcon == null || kMLIcon.getHref() == null) {
            return false;
        }
        return this.getImageSource() == null || kMLIcon.getUpdateTime() > this.iconRetrievalTime;
    }

    protected String resolveHref() {
        String string = this.parent.getIcon().getHref();
        String string2 = null;
        try {
            string2 = this.parent.getRoot().getSupportFilePath(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2 != null ? string2 : string;
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        super.render(drawContext);
    }

    protected void applyRotation(DrawContext drawContext) {
        Double d;
        KMLLatLonBox kMLLatLonBox = this.parent.getLatLonBox();
        if (kMLLatLonBox != null && (d = kMLLatLonBox.getRotation()) != null) {
            List<LatLon> list = this.computeRotatedCorners(drawContext, this.getSector(), Angle.fromDegrees(d));
            this.setCorners(list);
        }
    }

    protected List<LatLon> computeRotatedCorners(DrawContext drawContext, Sector sector, Angle angle) {
        LatLon[] latLonArray = sector.getCorners();
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(latLonArray.length);
        Globe globe = drawContext.getGlobe();
        Vec4[] vec4Array = sector.computeCornerPoints(globe, 1.0);
        Vec4 vec4 = vec4Array[2].subtract3(vec4Array[0]).cross3(vec4Array[3].subtract3(vec4Array[1])).normalize3();
        Matrix matrix = Matrix.fromAxisAngle(angle, vec4);
        Vec4 vec42 = sector.computeCenterPoint(globe, 1.0);
        for (Vec4 vec43 : vec4Array) {
            vec43 = vec43.subtract3(vec42).transformBy3(matrix).add3(vec42);
            Position position = globe.computePositionFromPoint(vec43);
            arrayList.add(position);
        }
        return arrayList;
    }
}

