/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.ogc.kml.KMLAbstractObject;
import gov.nasa.worldwind.ogc.kml.KMLAbstractOverlay;
import gov.nasa.worldwind.ogc.kml.KMLVec2;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLScreenImageImpl;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class KMLScreenOverlay
extends KMLAbstractOverlay {
    protected KMLRenderable renderable;

    public KMLScreenOverlay(String string) {
        super(string);
    }

    public KMLVec2 getOverlayXY() {
        return (KMLVec2)this.getField("overlayXY");
    }

    public KMLVec2 getScreenXY() {
        return (KMLVec2)this.getField("screenXY");
    }

    public KMLVec2 getRotationXY() {
        return (KMLVec2)this.getField("rotationXY");
    }

    public KMLVec2 getSize() {
        return (KMLVec2)this.getField("size");
    }

    public Double getRotation() {
        return (Double)this.getField("rotation");
    }

    @Override
    protected void doPreRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        KMLRenderable kMLRenderable;
        if (this.getRenderable() == null) {
            this.initializeRenderable(kMLTraversalContext);
        }
        if ((kMLRenderable = this.getRenderable()) != null) {
            kMLRenderable.preRender(kMLTraversalContext, drawContext);
        }
    }

    @Override
    protected void doRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        KMLRenderable kMLRenderable = this.getRenderable();
        if (kMLRenderable != null) {
            kMLRenderable.render(kMLTraversalContext, drawContext);
        }
        this.renderBalloon(kMLTraversalContext, drawContext);
    }

    protected void initializeRenderable(KMLTraversalContext kMLTraversalContext) {
        this.renderable = new KMLScreenImageImpl(kMLTraversalContext, this);
    }

    public KMLRenderable getRenderable() {
        return this.renderable;
    }

    @Override
    public void applyChange(KMLAbstractObject kMLAbstractObject) {
        if (!(kMLAbstractObject instanceof KMLScreenOverlay)) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        this.renderable = null;
        super.applyChange(kMLAbstractObject);
    }

    @Override
    public void onChange(Message message) {
        if ("KMLAbstractObject.LinkChanged".equals(message.getName())) {
            this.renderable = null;
        }
        super.onChange(message);
    }
}

