/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;

public class Triangle {
    private static final double EPSILON = 1.0E-7;
    private final Vec4 a;
    private final Vec4 b;
    private final Vec4 c;

    public Triangle(Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.a = vec4;
        this.b = vec42;
        this.c = vec43;
    }

    public Vec4 getA() {
        return this.a;
    }

    public Vec4 getB() {
        return this.b;
    }

    public Vec4 getC() {
        return this.c;
    }

    public boolean contains(Vec4 vec4) {
        if (vec4 == null) {
            return false;
        }
        Vec4 vec42 = this.c.subtract3(this.a);
        Vec4 vec43 = this.b.subtract3(this.a);
        Vec4 vec44 = vec4.subtract3(this.a);
        double d = vec42.dotSelf3();
        double d2 = vec42.dot3(vec43);
        double d3 = vec42.dot3(vec44);
        double d4 = vec43.dotSelf3();
        double d5 = vec43.dot3(vec44);
        double d6 = d * d4 - d2 * d2;
        double d7 = 1.0 / d6;
        double d8 = (d4 * d3 - d2 * d5) * d7;
        double d9 = (d * d5 - d2 * d3) * d7;
        return d8 >= 0.0 && d9 >= 0.0 && d8 + d9 <= 1.0;
    }

    public Vec4 intersect(Line line) {
        Intersection intersection = Triangle.intersect(line, this.a, this.b, this.c);
        return intersection != null ? intersection.getIntersectionPoint() : null;
    }

    public static Intersection intersect(Line line, Vec4 vec4, Vec4 vec42, Vec4 vec43) {
        return Triangle.intersect(line, vec4.x, vec4.y, vec4.z, vec42.x, vec42.y, vec42.z, vec43.x, vec43.y, vec43.z);
    }

    public static Intersection intersect(Line line, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = line.getOrigin();
        Vec4 vec42 = line.getDirection();
        double d10 = d4 - d;
        double d11 = d9 - d3;
        double d12 = d8 - d2;
        double d13 = vec42.y * d11 - vec42.z * d12;
        double d14 = d5 - d2;
        double d15 = d7 - d;
        double d16 = vec42.z * d15 - vec42.x * d11;
        double d17 = d6 - d3;
        double d18 = vec42.x * d12 - vec42.y * d15;
        double d19 = d10 * d13 + d14 * d16 + d17 * d18;
        if (d19 > -1.0E-7 && d19 < 1.0E-7) {
            return null;
        }
        double d20 = 1.0 / d19;
        double d21 = vec4.x - d;
        double d22 = vec4.y - d2;
        double d23 = vec4.z - d3;
        double d24 = d20 * (d21 * d13 + d22 * d16 + d23 * d18);
        if (d24 < 0.0 || d24 > 1.0) {
            return null;
        }
        double d25 = d22 * d17 - d23 * d14;
        double d26 = d23 * d10 - d21 * d17;
        double d27 = d21 * d14 - d22 * d10;
        double d28 = d20 * (vec42.x * d25 + vec42.y * d26 + vec42.z * d27);
        if (d28 < 0.0 || d24 + d28 > 1.0) {
            return null;
        }
        double d29 = d20 * (d15 * d25 + d12 * d26 + d11 * d27);
        if (d29 < 0.0) {
            return null;
        }
        return new Intersection(line.getPointAt(d29), d29, false);
    }

    public static List<Intersection> intersectTriStrip(Line line, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        for (int i = intBuffer.position(); i < intBuffer.limit() - 2; ++i) {
            int n = intBuffer.get(i) * 3;
            int n2 = intBuffer.get(i + 1) * 3;
            int n3 = intBuffer.get(i + 2) * 3;
            Intersection intersection = Triangle.intersect(line, floatBuffer.get(n), floatBuffer.get(n + 1), floatBuffer.get(n + 2), floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2), floatBuffer.get(n3), floatBuffer.get(n3 + 1), floatBuffer.get(n3 + 2));
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriStrip(Line line, Vec4[] vec4Array, IntBuffer intBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        for (int i = intBuffer.position(); i < intBuffer.limit() - 1; ++i) {
            int n;
            int n2;
            int n3 = intBuffer.get(i) * 3;
            Intersection intersection = Triangle.intersect(line, vec4Array[n3], vec4Array[n2 = intBuffer.get(i + 1) * 3], vec4Array[n = intBuffer.get(i + 2) * 3]);
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriFan(Line line, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        int n = intBuffer.get();
        float f = floatBuffer.get(n * 3);
        float f2 = floatBuffer.get(n * 3 + 1);
        float f3 = floatBuffer.get(n * 3 + 2);
        for (int i = intBuffer.position(); i < intBuffer.limit() - 1; ++i) {
            int n2 = intBuffer.get(i) * 3;
            int n3 = intBuffer.get(i + 1) * 3;
            Intersection intersection = Triangle.intersect(line, f, f2, f3, floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2), floatBuffer.get(n3), floatBuffer.get(n3 + 1), floatBuffer.get(n3 + 2));
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriFan(Line line, Vec4[] vec4Array, IntBuffer intBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4Array == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        Vec4 vec4 = vec4Array[0];
        for (int i = intBuffer.position() + 1; i < intBuffer.limit() - 1; ++i) {
            Vec4 vec42;
            Vec4 vec43 = vec4Array[intBuffer.get(i)];
            Intersection intersection = Triangle.intersect(line, vec4, vec43, vec42 = vec4Array[intBuffer.get(i + 1)]);
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriangles(Line line, FloatBuffer floatBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        floatBuffer.rewind();
        while (floatBuffer.limit() - floatBuffer.position() >= 9) {
            Intersection intersection = Triangle.intersect(line, floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get(), floatBuffer.get());
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriangles(Line line, FloatBuffer floatBuffer, IntBuffer intBuffer) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Intersection> arrayList = null;
        for (int i = intBuffer.position(); i < intBuffer.limit(); i += 3) {
            int n = intBuffer.get(i) * 3;
            int n2 = intBuffer.get(i + 1) * 3;
            int n3 = intBuffer.get(i + 2) * 3;
            Intersection intersection = Triangle.intersect(line, floatBuffer.get(n), floatBuffer.get(n + 1), floatBuffer.get(n + 2), floatBuffer.get(n2), floatBuffer.get(n2 + 1), floatBuffer.get(n2 + 2), floatBuffer.get(n3), floatBuffer.get(n3 + 1), floatBuffer.get(n3 + 2));
            if (intersection == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Intersection>();
            }
            arrayList.add(intersection);
        }
        return arrayList;
    }

    public static List<Intersection> intersectTriangleTypes(Line line, FloatBuffer floatBuffer, IntBuffer intBuffer, int n) {
        if (n == 4) {
            return Triangle.intersectTriangles(line, floatBuffer, intBuffer);
        }
        if (n == 5) {
            return Triangle.intersectTriStrip(line, floatBuffer, intBuffer);
        }
        if (n == 6) {
            return Triangle.intersectTriFan(line, floatBuffer, intBuffer);
        }
        return null;
    }

    public static void expandTriangles(List<Integer> list, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || floatBuffer2 == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() / 3;
        if (n * 3 * 3 > floatBuffer2.limit() - floatBuffer2.position()) {
            String string = Logging.getMessage("generic.BufferSize", floatBuffer2.limit() - floatBuffer2.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < list.size(); i += 3) {
            int n2 = list.get(i) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
            n2 = list.get(i + 1) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
            n2 = list.get(i + 2) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
        }
    }

    public static void expandTriangleFan(List<Integer> list, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || floatBuffer2 == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() - 2;
        if (n * 3 * 3 > floatBuffer2.limit() - floatBuffer2.position()) {
            String string = Logging.getMessage("generic.BufferSize", floatBuffer2.limit() - floatBuffer2.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = list.get(0) * 3;
        float f = floatBuffer.get(n2);
        float f2 = floatBuffer.get(n2 + 1);
        float f3 = floatBuffer.get(n2 + 2);
        for (int i = 1; i < list.size() - 1; ++i) {
            floatBuffer2.put(f).put(f2).put(f3);
            n2 = list.get(i) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
            n2 = list.get(i + 1) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
        }
    }

    public static void expandTriangleStrip(List<Integer> list, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (floatBuffer == null || floatBuffer2 == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() - 2;
        if (n * 3 * 3 > floatBuffer2.limit() - floatBuffer2.position()) {
            String string = Logging.getMessage("generic.BufferSize", floatBuffer2.limit() - floatBuffer2.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 2; i < list.size(); ++i) {
            int n2 = list.get(i - 2) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
            n2 = list.get(i % 2 == 0 ? i : i - 1) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
            n2 = list.get(i % 2 == 0 ? i - 1 : i) * 3;
            floatBuffer2.put(floatBuffer.get(n2)).put(floatBuffer.get(n2 + 1)).put(floatBuffer.get(n2 + 2));
        }
    }

    public static void expandTriangles(List<Integer> list, IntBuffer intBuffer) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() / 3;
        if (n * 3 > intBuffer.limit() - intBuffer.position()) {
            String string = Logging.getMessage("generic.BufferSize", intBuffer.limit() - intBuffer.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < list.size(); ++i) {
            intBuffer.put(list.get(i));
        }
    }

    public static void expandTriangleFan(List<Integer> list, IntBuffer intBuffer) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() - 2;
        if (n * 3 > intBuffer.limit() - intBuffer.position()) {
            String string = Logging.getMessage("generic.BufferSize", intBuffer.limit() - intBuffer.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = list.get(0);
        for (int i = 1; i < list.size() - 1; ++i) {
            intBuffer.put(n2);
            intBuffer.put(list.get(i));
            intBuffer.put(list.get(i + 1));
        }
    }

    public static void expandTriangleStrip(List<Integer> list, IntBuffer intBuffer) {
        if (list == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (intBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = list.size() - 2;
        if (n * 3 > intBuffer.limit() - intBuffer.position()) {
            String string = Logging.getMessage("generic.BufferSize", intBuffer.limit() - intBuffer.position());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 2; i < list.size(); ++i) {
            intBuffer.put(list.get(i - 2));
            intBuffer.put(list.get(i % 2 == 0 ? i - 1 : i));
            intBuffer.put(list.get(i % 2 == 0 ? i : i - 1));
        }
    }

    public static int intersectTriangles(Vec4[] vec4Array, Vec4[] vec4Array2, Vec4[] vec4Array3) {
        double d = vec4Array[1].x - vec4Array[0].x;
        double d2 = vec4Array[1].y - vec4Array[0].y;
        double d3 = vec4Array[1].z - vec4Array[0].z;
        double d4 = vec4Array[2].x - vec4Array[0].x;
        double d5 = vec4Array[2].y - vec4Array[0].y;
        double d6 = vec4Array[2].z - vec4Array[0].z;
        Vec4 vec4 = new Vec4(d2 * d6 - d3 * d5, d3 * d4 - d * d6, d * d5 - d2 * d4);
        double d7 = -vec4.dot3(vec4Array[0]);
        double d8 = vec4.dot3(vec4Array2[0]) + d7;
        double d9 = vec4.dot3(vec4Array2[1]) + d7;
        double d10 = vec4.dot3(vec4Array2[2]) + d7;
        if (Math.abs(d8) < 1.0E-7) {
            d8 = 0.0;
        }
        if (Math.abs(d9) < 1.0E-7) {
            d9 = 0.0;
        }
        if (Math.abs(d10) < 1.0E-7) {
            d10 = 0.0;
        }
        double d11 = d8 * d9;
        double d12 = d8 * d10;
        if (d11 > 0.0 && d12 > 0.0) {
            return -1;
        }
        d = vec4Array2[1].x - vec4Array2[0].x;
        d2 = vec4Array2[1].y - vec4Array2[0].y;
        d3 = vec4Array2[1].z - vec4Array2[0].z;
        d4 = vec4Array2[2].x - vec4Array2[0].x;
        d5 = vec4Array2[2].y - vec4Array2[0].y;
        d6 = vec4Array2[2].z - vec4Array2[0].z;
        Vec4 vec42 = new Vec4(d2 * d6 - d3 * d5, d3 * d4 - d * d6, d * d5 - d2 * d4);
        double d13 = -vec42.dot3(vec4Array2[0]);
        double d14 = vec42.dot3(vec4Array[0]) + d13;
        double d15 = vec42.dot3(vec4Array[1]) + d13;
        double d16 = vec42.dot3(vec4Array[2]) + d13;
        if (Math.abs(d14) < 1.0E-7) {
            d14 = 0.0;
        }
        if (Math.abs(d15) < 1.0E-7) {
            d15 = 0.0;
        }
        if (Math.abs(d16) < 1.0E-7) {
            d16 = 0.0;
        }
        double d17 = d14 * d15;
        double d18 = d14 * d16;
        if (d17 > 0.0 && d18 > 0.0) {
            return -1;
        }
        Vec4 vec43 = vec4.cross3(vec42);
        double d19 = Math.abs(vec43.x);
        int n = 0;
        double d20 = Math.abs(vec43.y);
        double d21 = Math.abs(vec43.z);
        if (d20 > d19) {
            d19 = d20;
            n = 1;
        }
        if (d21 > d19) {
            n = 2;
        }
        double d22 = vec4Array[0].x;
        double d23 = vec4Array[1].x;
        double d24 = vec4Array[2].x;
        double d25 = vec4Array2[0].x;
        double d26 = vec4Array2[1].x;
        double d27 = vec4Array2[2].x;
        if (n == 1) {
            d22 = vec4Array[0].y;
            d23 = vec4Array[1].y;
            d24 = vec4Array[2].y;
            d25 = vec4Array2[0].y;
            d26 = vec4Array2[1].y;
            d27 = vec4Array2[2].y;
        } else if (n == 2) {
            d22 = vec4Array[0].z;
            d23 = vec4Array[1].z;
            d24 = vec4Array[2].z;
            d25 = vec4Array2[0].z;
            d26 = vec4Array2[1].z;
            d27 = vec4Array2[2].z;
        }
        TriangleIntersection triangleIntersection = Triangle.compute_intervals_isectline(vec4Array, d22, d23, d24, d14, d15, d16, d17, d18);
        if (triangleIntersection == null) {
            return Triangle.coplanarTriangles(vec4, vec4Array, vec4Array2) ? 0 : -1;
        }
        boolean bl = false;
        if (triangleIntersection.s0 > triangleIntersection.s1) {
            double d28 = triangleIntersection.s0;
            triangleIntersection.s0 = triangleIntersection.s1;
            triangleIntersection.s1 = d28;
            bl = true;
        }
        TriangleIntersection triangleIntersection2 = Triangle.compute_intervals_isectline(vec4Array2, d25, d26, d27, d8, d9, d10, d11, d12);
        boolean bl2 = false;
        if (triangleIntersection2.s0 > triangleIntersection2.s1) {
            double d29 = triangleIntersection2.s0;
            triangleIntersection2.s0 = triangleIntersection2.s1;
            triangleIntersection2.s1 = d29;
            bl2 = true;
        }
        if (triangleIntersection.s1 < triangleIntersection2.s0 || triangleIntersection2.s1 < triangleIntersection.s0) {
            return -1;
        }
        if (triangleIntersection2.s0 < triangleIntersection.s0) {
            vec4Array3[0] = !bl ? triangleIntersection.p0 : triangleIntersection.p1;
            vec4Array3[1] = triangleIntersection2.s1 < triangleIntersection.s1 ? (!bl2 ? triangleIntersection2.p1 : triangleIntersection2.p0) : (!bl ? triangleIntersection.p1 : triangleIntersection.p0);
        } else {
            vec4Array3[0] = !bl2 ? triangleIntersection2.p0 : triangleIntersection2.p1;
            vec4Array3[1] = triangleIntersection2.s1 > triangleIntersection.s1 ? (!bl ? triangleIntersection.p1 : triangleIntersection.p0) : (!bl2 ? triangleIntersection2.p1 : triangleIntersection2.p0);
        }
        return 1;
    }

    protected static TriangleIntersection compute_intervals_isectline(Vec4[] vec4Array, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (d7 > 0.0) {
            return Triangle.intersect(vec4Array[2], vec4Array[0], vec4Array[1], d3, d, d2, d6, d4, d5);
        }
        if (d8 > 0.0) {
            return Triangle.intersect(vec4Array[1], vec4Array[0], vec4Array[2], d2, d, d3, d5, d4, d6);
        }
        if (d5 * d6 > 0.0 || d4 != 0.0) {
            return Triangle.intersect(vec4Array[0], vec4Array[1], vec4Array[2], d, d2, d3, d4, d5, d6);
        }
        if (d5 != 0.0) {
            return Triangle.intersect(vec4Array[1], vec4Array[0], vec4Array[2], d2, d, d3, d5, d4, d6);
        }
        if (d6 != 0.0) {
            return Triangle.intersect(vec4Array[2], vec4Array[0], vec4Array[1], d3, d, d2, d6, d4, d5);
        }
        return null;
    }

    protected static TriangleIntersection intersect(Vec4 vec4, Vec4 vec42, Vec4 vec43, double d, double d2, double d3, double d4, double d5, double d6) {
        TriangleIntersection triangleIntersection = new TriangleIntersection();
        double d7 = d4 / (d4 - d5);
        triangleIntersection.s0 = d + (d2 - d) * d7;
        Vec4 vec44 = vec42.subtract3(vec4);
        vec44 = vec44.multiply3(d7);
        triangleIntersection.p0 = vec44.add3(vec4);
        d7 = d4 / (d4 - d6);
        triangleIntersection.s1 = d + (d3 - d) * d7;
        vec44 = vec43.subtract3(vec4);
        vec44 = vec44.multiply3(d7);
        triangleIntersection.p1 = vec44.add3(vec4);
        return triangleIntersection;
    }

    protected static boolean coplanarTriangles(Vec4 vec4, Vec4[] vec4Array, Vec4[] vec4Array2) {
        int n;
        int n2;
        double[] dArray = new double[]{Math.abs(vec4.x), Math.abs(vec4.y), Math.abs(vec4.z)};
        double[] dArray2 = dArray;
        if (dArray2[0] > dArray2[1]) {
            if (dArray2[0] > dArray2[2]) {
                n2 = 1;
                n = 2;
            } else {
                n2 = 0;
                n = 1;
            }
        } else if (dArray2[2] > dArray2[1]) {
            n2 = 0;
            n = 1;
        } else {
            n2 = 0;
            n = 2;
        }
        double[] dArray3 = new double[]{vec4Array[0].x, vec4Array[0].y, vec4Array[0].z};
        double[] dArray4 = new double[]{vec4Array[1].x, vec4Array[1].y, vec4Array[1].z};
        double[] dArray5 = new double[]{vec4Array[2].x, vec4Array[2].y, vec4Array[2].z};
        double[] dArray6 = new double[]{vec4Array2[0].x, vec4Array2[0].y, vec4Array2[0].z};
        double[] dArray7 = new double[]{vec4Array2[1].x, vec4Array2[1].y, vec4Array2[1].z};
        double[] dArray8 = new double[]{vec4Array2[2].x, vec4Array2[2].y, vec4Array2[2].z};
        boolean bl = Triangle.triangleEdgeTest(dArray3, dArray4, dArray6, dArray7, dArray8, n2, n);
        if (bl) {
            return true;
        }
        bl = Triangle.triangleEdgeTest(dArray4, dArray5, dArray6, dArray7, dArray8, n2, n);
        if (bl) {
            return true;
        }
        bl = Triangle.triangleEdgeTest(dArray5, dArray3, dArray6, dArray7, dArray8, n2, n);
        if (bl) {
            return true;
        }
        bl = Triangle.pointInTri(dArray3, dArray6, dArray7, dArray8, n2, n);
        if (bl) {
            return true;
        }
        return Triangle.pointInTri(dArray6, dArray3, dArray4, dArray5, n2, n);
    }

    protected static boolean triangleEdgeTest(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n, int n2) {
        double d = dArray2[n] - dArray[n];
        double d2 = dArray2[n2] - dArray[n2];
        boolean bl = Triangle.edgeEdgeTest(dArray, dArray3, dArray4, n, n2, d, d2);
        if (bl) {
            return true;
        }
        bl = Triangle.edgeEdgeTest(dArray, dArray4, dArray5, n, n2, d, d2);
        if (bl) {
            return true;
        }
        return Triangle.edgeEdgeTest(dArray, dArray5, dArray3, n, n2, d, d2);
    }

    protected static boolean edgeEdgeTest(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2, double d, double d2) {
        double d3 = dArray2[n] - dArray3[n];
        double d4 = dArray2[n2] - dArray3[n2];
        double d5 = dArray[n] - dArray2[n];
        double d6 = dArray[n2] - dArray2[n2];
        double d7 = d2 * d3 - d * d4;
        double d8 = d4 * d5 - d3 * d6;
        if (d7 > 0.0 && d8 >= 0.0 && d8 <= d7 || d7 < 0.0 && d8 <= 0.0 && d8 >= d7) {
            double d9 = d * d6 - d2 * d5;
            if (d7 > 0.0 ? d9 >= 0.0 && d9 <= d7 : d9 <= 0.0 && d9 >= d7) {
                return true;
            }
        }
        return false;
    }

    protected static boolean pointInTri(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, int n2) {
        double d = dArray3[n2] - dArray2[n2];
        double d2 = -(dArray3[n] - dArray2[n]);
        double d3 = -d * dArray2[n] - d2 * dArray2[n2];
        double d4 = d * dArray[n] + d2 * dArray[n2] + d3;
        d = dArray4[n2] - dArray3[n2];
        d2 = -(dArray4[n] - dArray3[n]);
        d3 = -d * dArray3[n] - d2 * dArray3[n2];
        double d5 = d * dArray[n] + d2 * dArray[n2] + d3;
        d = dArray2[n2] - dArray4[n2];
        d2 = -(dArray2[n] - dArray4[n]);
        d3 = -d * dArray4[n] - d2 * dArray4[n2];
        double d6 = d * dArray[n] + d2 * dArray[n2] + d3;
        return d4 * d5 > 0.0 && d4 * d6 > 0.0;
    }

    public String toString() {
        return "Triangle (" + this.a + ", " + this.b + ", " + this.c + ")";
    }

    protected static class TriangleIntersection {
        public Vec4 p0;
        public Vec4 p1;
        public double s0;
        public double s1;

        protected TriangleIntersection() {
        }
    }
}

