/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.json;

import gov.nasa.worldwind.formats.json.JSONEvent;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class BasicJSONEvent
implements JSONEvent {
    protected final JsonToken token;
    protected final String fieldName;
    protected final Object scalarValue;

    public BasicJSONEvent(JsonParser jsonParser, JsonToken jsonToken, String string) throws IOException {
        if (jsonParser == null) {
            String string2 = Logging.getMessage("nullValue.ParserIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (jsonToken == null) {
            String string3 = Logging.getMessage("nullValue.TokenIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.token = jsonToken;
        this.fieldName = string;
        if (this.token.isScalarValue()) {
            if (this.token == JsonToken.VALUE_NULL) {
                this.scalarValue = null;
            } else if (this.token == JsonToken.VALUE_STRING) {
                this.scalarValue = jsonParser.getText();
            } else if (this.token == JsonToken.VALUE_NUMBER_INT) {
                this.scalarValue = jsonParser.getIntValue();
            } else if (this.token == JsonToken.VALUE_NUMBER_FLOAT) {
                this.scalarValue = jsonParser.getDoubleValue();
            } else if (this.token == JsonToken.VALUE_TRUE || jsonToken == JsonToken.VALUE_FALSE) {
                this.scalarValue = jsonParser.getBooleanValue();
            } else if (this.token == JsonToken.VALUE_EMBEDDED_OBJECT) {
                this.scalarValue = jsonParser.getEmbeddedObject();
            } else {
                Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", new Object[]{this.token}));
                this.scalarValue = null;
            }
        } else {
            this.scalarValue = null;
        }
    }

    @Override
    public boolean isStartObject() {
        return this.token == JsonToken.START_OBJECT;
    }

    @Override
    public boolean isEndObject() {
        return this.token == JsonToken.END_OBJECT;
    }

    @Override
    public boolean isStartArray() {
        return this.token == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isEndArray() {
        return this.token == JsonToken.END_ARRAY;
    }

    @Override
    public boolean isFieldName() {
        return this.token == JsonToken.FIELD_NAME;
    }

    @Override
    public boolean isScalarValue() {
        return this.token.isScalarValue();
    }

    @Override
    public boolean isNumericValue() {
        return this.token == JsonToken.VALUE_NUMBER_INT || this.token == JsonToken.VALUE_NUMBER_FLOAT;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object asScalarValue() {
        return this.scalarValue;
    }

    @Override
    public double asNumericValue() {
        return ((Number)this.scalarValue).doubleValue();
    }

    public String toString() {
        return this.token.asString();
    }
}

