/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dted;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;

public class DTED {
    protected static final int REC_HEADER_SIZE = 8;
    protected static final int REC_CHKSUM_SIZE = 4;
    protected static final int DTED_UHL_SIZE = 80;
    protected static final int DTED_DSI_SIZE = 648;
    protected static final int DTED_ACC_SIZE = 2700;
    protected static final long DTED_UHL_OFFSET = 0L;
    protected static final long DTED_DSI_OFFSET = 80L;
    protected static final long DTED_ACC_OFFSET = 728L;
    protected static final long DTED_DATA_OFFSET = 3428L;
    protected static final int DTED_NODATA_VALUE = -32767;

    protected DTED() {
    }

    protected static RandomAccessFile open(File file) throws IOException, IllegalArgumentException {
        if (null == file) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (!file.canRead()) {
            String string = Logging.getMessage("generic.FileNoReadPermission", file.getAbsolutePath());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        return new RandomAccessFile(file, "r");
    }

    protected static void close(RandomAccessFile randomAccessFile) {
        if (null != randomAccessFile) {
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                Logging.logger().finest(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AVList readMetadata(File file) throws IOException {
        AVListImpl aVListImpl = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = DTED.open(file);
            FileChannel fileChannel = randomAccessFile.getChannel();
            aVListImpl = new AVListImpl();
            DTED.readUHL(fileChannel, 0L, aVListImpl);
            DTED.readDSI(fileChannel, 80L, aVListImpl);
            DTED.readACC(fileChannel, 728L, aVListImpl);
        }
        finally {
            DTED.close(randomAccessFile);
        }
        return aVListImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRaster read(File file) throws IOException {
        DataRaster dataRaster = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = DTED.open(file);
            FileChannel fileChannel = randomAccessFile.getChannel();
            AVListImpl aVListImpl = new AVListImpl();
            DTED.readUHL(fileChannel, 0L, aVListImpl);
            DTED.readDSI(fileChannel, 80L, aVListImpl);
            DTED.readACC(fileChannel, 728L, aVListImpl);
            dataRaster = DTED.readElevations(fileChannel, 3428L, aVListImpl);
        }
        finally {
            DTED.close(randomAccessFile);
        }
        return dataRaster;
    }

    protected static DataRaster readElevations(FileChannel fileChannel, long l, AVList aVList) throws IOException {
        if (null == fileChannel) {
            return null;
        }
        ByteBufferRaster byteBufferRaster = (ByteBufferRaster)ByteBufferRaster.createGeoreferencedRaster(aVList);
        fileChannel.position(l);
        int n = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Width");
        int n2 = (Integer)aVList.getValue("gov.nasa.worldwind.avkey.Height");
        int n3 = 8 + n2 * 16 / 8 + 4;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double d3 = -32767.0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3).order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < n; ++i) {
            short s;
            int n4;
            fileChannel.read(byteBuffer);
            byteBuffer.flip();
            int n5 = 0;
            for (int j = 0; j < n3 - 4; ++j) {
                n5 += 0xFF & byteBuffer.get(j);
            }
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            for (n4 = 0; n4 < n2; ++n4) {
                double d4 = shortBuffer.get(n4 + 4);
                if (d4 != d3) {
                    d = d4 < d ? d4 : d;
                    d2 = d4 > d2 ? d4 : d2;
                }
                int n6 = n2 - n4 - 1;
                byteBufferRaster.setDoubleAtPosition(n6, i, d4);
            }
            n4 = shortBuffer.get(n2 + 4);
            int n7 = (0xFFFF & n4) << 16 | 0xFFFF & (s = shortBuffer.get(n2 + 4 + 1));
            if (n7 == n5) continue;
            String string = Logging.getMessage("DTED.DataRecordChecksumError", n7, n5);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        byteBufferRaster.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d);
        byteBufferRaster.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d2);
        return byteBufferRaster;
    }

    protected static Angle readAngle(String string) throws IOException {
        if (null == string) {
            String string2 = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        int n = stringBuffer.length();
        switch (n) {
            case 7: {
                stringBuffer.insert(2, " ").insert(5, " ").insert(8, " ");
                return Angle.fromDMS(stringBuffer.toString());
            }
            case 8: {
                stringBuffer.insert(3, " ").insert(6, " ").insert(9, " ");
                return Angle.fromDMS(stringBuffer.toString());
            }
            case 9: {
                stringBuffer.insert(2, " ").insert(5, " ").insert(10, " ");
                stringBuffer.delete(8, 10);
                return Angle.fromDMS(stringBuffer.toString());
            }
            case 10: {
                stringBuffer.insert(3, " ").insert(6, " ").insert(11, " ");
                stringBuffer.delete(9, 11);
                return Angle.fromDMS(stringBuffer.toString());
            }
        }
        return null;
    }

    protected static Integer readLevel(String string) {
        if (null == string) {
            return null;
        }
        if (!(string = string.trim()).startsWith("DTED") || string.length() != 5) {
            return null;
        }
        return string.charAt(4) - 48;
    }

    protected static String readClassLevel(String string) {
        if (null != string) {
            if ("U".equalsIgnoreCase(string = string.trim())) {
                return "gov.nasa.worldwind.avkey.ClassLevel.Unclassified";
            }
            if ("R".equalsIgnoreCase(string)) {
                return "gov.nasa.worldwind.avkey.ClassLevel.Restricted";
            }
            if ("C".equalsIgnoreCase(string)) {
                return "gov.nasa.worldwind.avkey.ClassLevel.Confidential";
            }
            if ("S".equalsIgnoreCase(string)) {
                return "gov.nasa.worldwind.avkey.ClassLevel.Secret";
            }
        }
        return null;
    }

    protected static void readACC(FileChannel fileChannel, long l, AVList aVList) throws IOException {
        if (null == fileChannel) {
            return;
        }
        fileChannel.position(l);
        byte[] byArray = new byte[2700];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        String string = new String(byArray, 0, 3);
        if (!"ACC".equalsIgnoreCase(string)) {
            String string2 = Logging.getMessage("DTED.UnexpectedRecordId", string, "ACC");
            String string3 = Logging.getMessage("DTED.BadFileFormat", string2);
            Logging.logger().severe(string3);
            throw new IOException(string3);
        }
    }

    protected static void readUHL(FileChannel fileChannel, long l, AVList aVList) throws IOException {
        if (null == fileChannel) {
            return;
        }
        fileChannel.position(l);
        byte[] byArray = new byte[80];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        String string = new String(byArray, 0, 3);
        if (!"UHL".equalsIgnoreCase(string)) {
            String string2 = Logging.getMessage("DTED.UnexpectedRecordId", string, "UHL");
            String string3 = Logging.getMessage("DTED.BadFileFormat", string2);
            Logging.logger().severe(string3);
            throw new IOException(string3);
        }
        aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.BigEndian");
        aVList.setValue("gov.nasa.worldwind.avkey.CoordinateSystem", "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic");
        aVList.setValue("gov.nasa.worldwind.avkey.Projection.EPSG.Code", 4326);
        aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
        aVList.setValue("gov.nasa.worldwind.avkey.ElevationUnit", "gov.nasa.worldwind.avkey.Unit.Meter");
        aVList.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", -32767.0);
        aVList.setValue("gov.nasa.worldwind.avkey.RasterPixel", "gov.nasa.worldwind.avkey.RasterPixelIsPoint");
        int n = Integer.valueOf(new String(byArray, 47, 4));
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        int n2 = Integer.valueOf(new String(byArray, 51, 4));
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        double d = 1.0 / (double)(n - 1);
        aVList.setValue("gov.nasa.worldwind.avkey.PixelWidth", d);
        double d2 = 1.0 / (double)(n2 - 1);
        aVList.setValue("gov.nasa.worldwind.avkey.PixelHeight", d2);
        Angle angle = DTED.readAngle(new String(byArray, 4, 8));
        Angle angle2 = DTED.readAngle(new String(byArray, 12, 8));
        Sector sector = Sector.fromDegrees(angle2.degrees - d2 / 2.0, angle2.degrees + 1.0 + d2 / 2.0, angle.degrees - d / 2.0, angle.degrees + 1.0 + d / 2.0);
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        LatLon latLon = LatLon.fromDegrees(sector.getMaxLatitude().degrees, sector.getMinLongitude().degrees);
        aVList.setValue("gov.nasa.worldwind.avkey.Origin", latLon);
        String string4 = DTED.readClassLevel(new String(byArray, 32, 3));
        if (null != string4) {
            aVList.setValue("gov.nasa.worldwind.avkey.ClassLevel", string4);
        }
    }

    protected static void readDSI(FileChannel fileChannel, long l, AVList aVList) throws IOException {
        Object object;
        if (null == fileChannel) {
            return;
        }
        fileChannel.position(l);
        fileChannel.position(l);
        byte[] byArray = new byte[648];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN);
        fileChannel.read(byteBuffer);
        byteBuffer.flip();
        String string = new String(byArray, 0, 3);
        if (!"DSI".equalsIgnoreCase(string)) {
            String string2 = Logging.getMessage("DTED.UnexpectedRecordId", string, "DSI");
            String string3 = Logging.getMessage("DTED.BadFileFormat", string2);
            Logging.logger().severe(string3);
            throw new IOException(string3);
        }
        if (!aVList.hasKey("gov.nasa.worldwind.avkey.ClassLevel") && null != (object = DTED.readClassLevel(new String(byArray, 3, 1)))) {
            aVList.setValue("gov.nasa.worldwind.avkey.ClassLevel", object);
        }
        if (null != (object = DTED.readLevel(new String(byArray, 59, 5)))) {
            aVList.setValue("gov.nasa.worldwind.avkey.DTED.Level", object);
        }
    }
}

