/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.AlphaBlockDXT3;
import gov.nasa.worldwind.formats.dds.BasicColorBlockExtractor;
import gov.nasa.worldwind.formats.dds.BlockDXT1;
import gov.nasa.worldwind.formats.dds.BlockDXT3;
import gov.nasa.worldwind.formats.dds.BlockDXT3Compressor;
import gov.nasa.worldwind.formats.dds.ColorBlock4x4;
import gov.nasa.worldwind.formats.dds.ColorBlockExtractor;
import gov.nasa.worldwind.formats.dds.DDSConstants;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.formats.dds.DXTCompressor;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public class DXT3Compressor
implements DXTCompressor {
    @Override
    public int getDXTFormat() {
        return DDSConstants.D3DFMT_DXT3;
    }

    @Override
    public int getCompressedSize(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = Math.max(bufferedImage.getWidth(), 4);
        int n2 = Math.max(bufferedImage.getHeight(), 4);
        return n * n2;
    }

    @Override
    public void compressImage(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes, ByteBuffer byteBuffer) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ColorBlock4x4 colorBlock4x4 = new ColorBlock4x4();
        ColorBlockExtractor colorBlockExtractor = this.getColorBlockExtractor(bufferedImage);
        BlockDXT3 blockDXT3 = new BlockDXT3();
        BlockDXT3Compressor blockDXT3Compressor = new BlockDXT3Compressor();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                colorBlockExtractor.extractColorBlock4x4(dXTCompressionAttributes, j, i, colorBlock4x4);
                blockDXT3Compressor.compressBlockDXT3(colorBlock4x4, dXTCompressionAttributes, blockDXT3);
                AlphaBlockDXT3 alphaBlockDXT3 = blockDXT3.getAlphaBlock();
                byteBuffer.putLong(alphaBlockDXT3.alphaValueMask);
                BlockDXT1 blockDXT1 = blockDXT3.getColorBlock();
                byteBuffer.putShort((short)blockDXT1.color0);
                byteBuffer.putShort((short)blockDXT1.color1);
                byteBuffer.putInt((int)blockDXT1.colorIndexMask);
            }
        }
    }

    protected ColorBlockExtractor getColorBlockExtractor(BufferedImage bufferedImage) {
        return new BasicColorBlockExtractor(bufferedImage);
    }
}

