/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.database;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.database.DatabaseConnectionPool;
import gov.nasa.worldwind.database.DatabaseConnectionPoolFactory;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.sql.SQLException;
import org.w3c.dom.Element;

public class BasicDatabaseConnectionPoolFactory
implements DatabaseConnectionPoolFactory {
    @Override
    public DatabaseConnectionPool create(AVList aVList) throws IllegalArgumentException, SQLException {
        return this.doCreate(aVList);
    }

    @Override
    public DatabaseConnectionPool create(Element element) throws IllegalArgumentException, SQLException {
        return this.doCreate(element);
    }

    protected DatabaseConnectionPool doCreate(AVList aVList) throws IllegalArgumentException, SQLException {
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.Database.ConnectionPoolClassName", "gov.nasa.worldwind.database.BasicDatabaseConnectionPool");
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Database.ConnectionPoolClassName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object object = WorldWind.createComponent(string);
        if (null != object && object instanceof DatabaseConnectionPool) {
            DatabaseConnectionPool databaseConnectionPool = (DatabaseConnectionPool)object;
            databaseConnectionPool.initialize(aVList);
            return databaseConnectionPool;
        }
        String string3 = Logging.getMessage("generic.CannotCreateObject", string);
        Logging.logger().severe(string3);
        throw new IllegalArgumentException(string3);
    }

    protected DatabaseConnectionPool doCreate(Element element) throws IllegalArgumentException, SQLException {
        String string = Logging.getMessage("generic.FeatureNotImplemented", "BasicDatabaseConnectionPoolFactory::create(Element element);");
        Logging.logger().severe(string);
        throw new SQLException(string);
    }
}

