/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.image.BufferedImage;

public class MipMappedBufferedImageRaster
extends BufferedImageRaster {
    protected BufferedImageRaster[] levelRasters;

    public MipMappedBufferedImageRaster(Sector sector, BufferedImage bufferedImage) {
        super(sector, bufferedImage);
        int n = ImageUtil.getMaxMipmapLevel(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage[] bufferedImageArray = ImageUtil.buildMipmaps(bufferedImage, 3, n);
        this.levelRasters = new BufferedImageRaster[1 + n];
        for (int i = 0; i <= n; ++i) {
            this.levelRasters[i] = new BufferedImageRaster(sector, bufferedImageArray[i]);
        }
    }

    public MipMappedBufferedImageRaster(Sector sector, BufferedImage[] bufferedImageArray) {
        super(sector, null != bufferedImageArray && bufferedImageArray.length > 0 ? bufferedImageArray[0] : null);
        if (null == sector) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == bufferedImageArray || bufferedImageArray.length == 0) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levelRasters = new BufferedImageRaster[bufferedImageArray.length];
        for (int i = 0; i < bufferedImageArray.length; ++i) {
            this.levelRasters[i] = new BufferedImageRaster(sector, bufferedImageArray[i]);
        }
    }

    @Override
    public long getSizeInBytes() {
        long l = 0L;
        for (BufferedImageRaster bufferedImageRaster : this.levelRasters) {
            l += bufferedImageRaster.getSizeInBytes();
        }
        return l;
    }

    @Override
    public void dispose() {
        for (BufferedImageRaster bufferedImageRaster : this.levelRasters) {
            bufferedImageRaster.dispose();
        }
    }

    @Override
    protected void doDrawOnTo(BufferedImageRaster bufferedImageRaster) {
        if (!this.getSector().intersects(bufferedImageRaster.getSector())) {
            return;
        }
        BufferedImageRaster bufferedImageRaster2 = this.chooseRasterForCanvas(bufferedImageRaster);
        bufferedImageRaster2.doDrawOnTo(bufferedImageRaster);
    }

    protected BufferedImageRaster chooseRasterForCanvas(BufferedImageRaster bufferedImageRaster) {
        int n = this.computeMipmapLevel(this.getWidth(), this.getHeight(), this.getSector(), bufferedImageRaster.getWidth(), bufferedImageRaster.getHeight(), bufferedImageRaster.getSector());
        int n2 = this.levelRasters.length - 1;
        n = WWMath.clamp(n, 0, n2);
        return this.levelRasters[n];
    }

    protected int computeMipmapLevel(int n, int n2, Sector sector, int n3, int n4, Sector sector2) {
        double d = (double)n2 / (double)n4 * (sector2.getDeltaLatDegrees() / sector.getDeltaLatDegrees());
        double d2 = (double)n / (double)n3 * (sector2.getDeltaLonDegrees() / sector.getDeltaLonDegrees());
        double d3 = Math.max(d2, d);
        if (d3 < 1.0) {
            return 0;
        }
        return (int)WWMath.logBase2(d3);
    }
}

