/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.animation;

import gov.nasa.worldwind.animation.PositionAnimator;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.PropertyAccessor;

public class MoveToPositionAnimator
extends PositionAnimator {
    protected double positionMinEpsilon = 1.0E-9;
    protected double smoothing = 0.9;
    protected boolean useSmoothing = true;

    public MoveToPositionAnimator(Position position, Position position2, double d, PropertyAccessor.PositionAccessor positionAccessor) {
        super(null, position, position2, positionAccessor);
        this.interpolator = null;
        this.smoothing = d;
    }

    @Override
    public void next() {
        if (this.hasNext()) {
            this.set(1.0 - this.smoothing);
        }
    }

    @Override
    public Position nextPosition(double d) {
        boolean bl;
        Position position = this.end;
        Position position2 = this.propertyAccessor.getPosition();
        double d2 = LatLon.greatCircleDistance((LatLon)position, (LatLon)position2).degrees;
        double d3 = Math.abs(position.getElevation() - position2.getElevation());
        boolean bl2 = bl = Math.max(d2, d3) < this.positionMinEpsilon;
        if (!bl) {
            d = 1.0 - this.smoothing;
            position = new Position(Angle.mix(d, position2.getLatitude(), this.end.getLatitude()), Angle.mix(d, position2.getLongitude(), this.end.getLongitude()), (1.0 - d) * position2.getElevation() + d * this.end.getElevation());
        }
        if (bl) {
            this.stop();
            return null;
        }
        return position;
    }
}

