/*
 * Decompiled with CFR 0.152.
 */
package earthproj;

import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.Polyline;
import java.awt.Color;
import java.util.ArrayList;

public class TrajectoryObjects {
    private Polyline polyline;
    private Path path;
    private final ArrayList<Position> pos = new ArrayList();
    private boolean usePath;
    private boolean usePolyline;
    private WorldWindowGLCanvas wwd;
    private final RenderableLayer layer = new RenderableLayer();
    private int ict = 0;
    private int tct = 0;
    private double Amp;
    private double rangeFact;
    private double latRate;
    private double lonRate;
    private double resDial;
    private int numPoints;
    private boolean trajRun = true;
    private double lat;
    private double lon;
    private double alt;
    private double latPrev;
    private double lonPrev;
    private double altPrev;

    public boolean propagateTrajectory() {
        if (this.tct > this.numPoints || this.alt < 0.0) {
            this.trajRun = false;
            return this.trajRun;
        }
        this.pos.add(this.ict, Position.fromDegrees(this.latPrev, this.lonPrev, this.altPrev));
        ++this.ict;
        this.lat += this.latRate;
        this.lon += this.lonRate;
        this.alt = this.Amp * Math.sin(this.rangeFact * Math.toRadians(this.tct));
        this.pos.add(this.ict, Position.fromDegrees(this.lat, this.lon, this.alt));
        if (this.usePolyline) {
            this.polyline.setPositions(this.pos);
        } else if (this.usePath) {
            this.path.setPositions(this.pos);
        }
        this.wwd.redrawNow();
        this.latPrev = this.lat;
        this.lonPrev = this.lon;
        this.altPrev = this.alt;
        --this.ict;
        ++this.tct;
        return this.trajRun;
    }

    public double[] getGEOCoord() {
        double[] trajData = new double[]{this.lat, this.lon, this.alt};
        return trajData;
    }

    public void setTrajResolution(double resDial) {
        this.resDial = resDial;
    }

    public void setTrajTypeOne() {
        this.Amp = 900000.0;
        this.rangeFact = 1.0 / this.resDial * 2.0 * 3.0 * 0.14;
        this.latRate = 1.0 / this.resDial * 2.0 * 0.15;
        this.lonRate = 1.0 / this.resDial * 2.0 * 0.3;
        this.numPoints = (int)(180.0 / this.rangeFact * this.resDial);
    }

    public void setTrajTypeTwo() {
        this.Amp = 900000.0;
        this.rangeFact = 1.0 / this.resDial * 2.0 * 3.0 * 0.14;
        this.latRate = 1.0 / this.resDial * 0.5 * 0.15;
        this.lonRate = 1.0 / this.resDial * 1.2 * 0.3;
        this.numPoints = (int)(180.0 / this.rangeFact * this.resDial);
    }

    public void setPathObject(Color color, double lineWidth) {
        this.path = new Path();
        this.usePath = true;
        BasicShapeAttributes attrs = new BasicShapeAttributes();
        attrs.setEnableLighting(true);
        attrs.setOutlineMaterial(new Material(color));
        attrs.setInteriorMaterial(new Material(color));
        attrs.setEnableAntialiasing(true);
        attrs.setOutlineWidth(lineWidth);
        attrs.setInteriorOpacity(1.0);
        attrs.setOutlineOpacity(1.0);
        this.path.setAttributes(attrs);
        this.path.setDrawVerticals(false);
        this.path.setVisible(true);
    }

    public void setPolylineObject(Color color, double lineWidth) {
        this.polyline = new Polyline();
        this.usePolyline = true;
        this.polyline.setColor(color);
        this.polyline.setLineWidth(lineWidth);
        this.polyline.setPathType(1);
        this.polyline.setFollowTerrain(false);
    }

    public void setGeoInit(double lat, double lon, double alt) {
        this.lat = lat;
        this.lon = lon;
        this.alt = alt;
        this.latPrev = lat;
        this.lonPrev = lon;
        this.altPrev = alt;
    }

    public void loadWorldWindModel(WorldWindowGLCanvas wwd) {
        this.wwd = wwd;
        if (this.usePolyline && this.polyline != null) {
            this.layer.addRenderable(this.polyline);
        } else if (this.usePath && this.path != null) {
            this.layer.addRenderable(this.path);
        }
        this.wwd.getModel().getLayers().add(this.layer);
    }
}

