/*
 * Decompiled with CFR 0.152.
 */
package earthproj;

import earthproj.BuildJPanel;
import earthproj.CustomOrbitView;
import earthproj.RadarObjects;
import earthproj.ScenarioSettings;
import earthproj.TrajectoryObjects;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.LatLonGraticuleLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.view.orbit.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public final class EarthView {
    private final JInternalFrame ew;
    private final JPanel mainPanel;
    private final JPanel subPanel1;
    private final BuildJPanel bp1;
    private final BuildJPanel bp2;
    private final WorldWindowGLCanvas wwd;
    private final ScenarioSettings ss;
    private TrajectoryObjects[] to;
    private RadarObjects[] ro;
    private final double initViewElevation;
    private final double initViewLat;
    private final double initViewLon;

    public EarthView(ScenarioSettings ss) {
        this.ss = ss;
        double[] vect = ss.getViewSettings();
        this.initViewLat = vect[0];
        this.initViewLon = vect[1];
        this.initViewElevation = vect[2];
        JFrame mainFSimFrame = new JFrame("Earth View");
        mainFSimFrame.setSize(1640, 950);
        mainFSimFrame.setResizable(true);
        mainFSimFrame.setMaximumSize(new Dimension(1640, 950));
        mainFSimFrame.setDefaultCloseOperation(3);
        mainFSimFrame.setVisible(true);
        JDesktopPane FSimdesktop = new JDesktopPane();
        FSimdesktop.setBackground(new Color(230, 230, 230));
        FSimdesktop.setVisible(true);
        mainFSimFrame.add(FSimdesktop);
        this.ew = new JInternalFrame("Earth View");
        this.ew.setResizable(true);
        this.ew.setSize(1150, 875);
        this.ew.setMaximumSize(new Dimension(1150, 875));
        this.ew.setLocation(220, 10);
        int[] fl = new int[]{1, 3, 3};
        int[] dim = new int[]{1150, 835};
        int[] col = new int[]{160, 160, 160};
        this.bp1 = new BuildJPanel(fl, dim, col, false, false);
        this.mainPanel = this.bp1.getJPanel();
        this.ew.add(this.mainPanel);
        int[] fl2 = new int[]{1, 3, 3};
        int[] dim2 = new int[]{1130, 835};
        int[] col2 = new int[]{192, 192, 192};
        this.bp2 = new BuildJPanel(fl2, dim2, col2, true, true);
        this.subPanel1 = this.bp2.getJPanel();
        this.mainPanel.add(this.subPanel1);
        this.wwd = new WorldWindowGLCanvas();
        Model m = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
        if (ss.getClipDistanceStatus()) {
            CustomOrbitView cov = new CustomOrbitView();
            double[] clipDistances = ss.getClipDistances();
            cov.setClipDistValues(clipDistances[0], clipDistances[1]);
            this.wwd.setModelAndView(m, cov);
        } else {
            this.wwd.setModel(m);
        }
        if (this.initViewElevation > 0.0) {
            OrbitView orbitView = (OrbitView)this.wwd.getView();
            Position pos = orbitView.getCenterPosition();
            System.out.println("Orbit View Position:");
            System.out.println(pos.elevation + ", " + pos.latitude + ", " + pos.longitude);
            pos = Position.fromDegrees(this.initViewLat, this.initViewLon, this.initViewElevation);
            orbitView.setCenterPosition(pos);
        }
        this.subPanel1.add(this.wwd);
        this.ew.setVisible(true);
        FSimdesktop.add((Component)this.ew, JLayeredPane.MODAL_LAYER);
    }

    public void trajSim() {
        int i;
        this.to = this.ss.getTrajectoryObjects();
        int numTrajObj = this.to.length;
        boolean[] trajRun = new boolean[numTrajObj];
        for (i = 0; i < numTrajObj; ++i) {
            this.to[i].loadWorldWindModel(this.wwd);
            trajRun[i] = true;
        }
        this.ro = this.ss.getRadarModels();
        int numRadObj = this.ro.length;
        for (i = 0; i < numTrajObj; ++i) {
            this.ro[i].loadWorldWindModel(this.wwd);
        }
        int timeDelay = this.ss.getTimeDelay();
        while (this.checkIfAnyTrue(trajRun)) {
            for (i = 0; i < numTrajObj; ++i) {
                if (!trajRun[i]) continue;
                trajRun[i] = this.to[i].propagateTrajectory();
            }
            for (i = 0; i < numRadObj; ++i) {
                this.ro[i].activateRadarTracking();
            }
            try {
                Thread.sleep(timeDelay);
            }
            catch (Exception err) {
                System.out.println("Time delay error: " + err + "\n");
            }
        }
        System.out.println("Simulation complete - exiting ...");
    }

    public boolean checkIfAnyTrue(boolean[] queue) {
        boolean anyTrue = false;
        for (int i = 0; i < queue.length; ++i) {
            if (!queue[i]) continue;
            anyTrue = true;
            break;
        }
        return anyTrue;
    }

    public void configureEarthLayers() {
        Layer lStars = null;
        Layer lAtmos = null;
        Object lMSV = null;
        Layer worldMapLayer = this.wwd.getModel().getLayers().getLayerByName("World Map");
        this.wwd.getModel().getLayers().remove(worldMapLayer);
        Layer compassLayer = this.wwd.getModel().getLayers().getLayerByName("Compass");
        this.wwd.getModel().getLayers().remove(compassLayer);
        if (this.ss.getUTMGridOption()) {
            Layer graticuleLayer = null;
            try {
                graticuleLayer = (Layer)LatLonGraticuleLayer.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                System.out.println("Can't get a graticule layer " + e);
            }
            if (graticuleLayer != null) {
                graticuleLayer.setEnabled(true);
            }
            this.wwd.getModel().getLayers().add(graticuleLayer);
        }
        if (this.ss.getATMLayerOption()) {
            lAtmos = this.wwd.getModel().getLayers().getLayerByName("Atmosphere");
            if (lAtmos.isEnabled()) {
                System.out.println("Atmosphere Layer is already Active");
            } else {
                System.out.println("Atmosphere Layer is NOT Active - activating now.");
                lAtmos.setEnabled(true);
            }
        } else if (this.wwd.getModel().getLayers().getLayerByName("Atmosphere") != null) {
            System.out.println("Removing Atmosphere layer ...");
            lAtmos = this.wwd.getModel().getLayers().getLayerByName("Atmosphere");
            this.wwd.getModel().getLayers().remove(lAtmos);
        } else {
            System.out.println("Atmosphere Layer not present - no need to remove.");
        }
        if (this.ss.getStarsLayerOption()) {
            lStars = this.wwd.getModel().getLayers().getLayerByName("Stars");
            if (lStars.isEnabled()) {
                System.out.println("Stars Layer is already Active");
            } else {
                System.out.println("Stars Layer is NOT Active - activating now.");
                lStars.setEnabled(true);
            }
        } else if (this.wwd.getModel().getLayers().getLayerByName("Stars") != null) {
            System.out.println("Removing Stars layer ...");
            lStars = this.wwd.getModel().getLayers().getLayerByName("Stars");
            this.wwd.getModel().getLayers().remove(lStars);
        } else {
            System.out.println("Star Layer not present - no need to remove.");
        }
        System.out.println("\n\nThe following layers are present in the Earth model:\n");
        this.wwd.getModel().getLayers().forEach(layer -> {
            System.out.print(layer.getName() + ", ");
            System.out.println("Class = " + layer.getClass().toString());
        });
    }
}

