/*
 * Decompiled with CFR 0.152.
 */
package earthproj;

import earthproj.EarthView;
import earthproj.RadarObjects;
import earthproj.ScenarioSettings;
import earthproj.TrajectoryObjects;
import java.awt.Color;

public class EarthProj {
    public static void main(String[] args) {
        TrajectoryObjects aircraft_1 = new TrajectoryObjects();
        TrajectoryObjects aircraft_2 = new TrajectoryObjects();
        TrajectoryObjects[] to = new TrajectoryObjects[2];
        RadarObjects ro_1 = new RadarObjects();
        RadarObjects ro_2 = new RadarObjects();
        RadarObjects[] ro = new RadarObjects[2];
        int timeDelay = 0;
        double resDial = 1.0;
        boolean showUTMGrid = false;
        boolean showAtmosphere = false;
        boolean showStars = false;
        boolean clipDistanceStatus = true;
        double nearClipDistanceVal = 1000000.0;
        double farClipDistanceVal = 1.0E9;
        double latView = 38.0;
        double lonView = -86.0;
        double altView = 3000000.0;
        double lonAC_1 = -50.143936;
        double latAC_1 = -11.779236;
        double altAC_1 = 0.0;
        Color colorTraj_1 = Color.RED;
        double lineWidthTraj_1 = 3.0;
        int trajType_1 = 1;
        double lonAC_2 = -60.143936;
        double latAC_2 = -11.779236;
        double altAC_2 = 0.0;
        Color colorTraj_2 = Color.GREEN;
        double lineWidthTraj_2 = 3.0;
        int trajType_2 = 2;
        double lonRadar_1 = -40.21;
        double latRadar_1 = -5.5;
        double altRadar_1 = 0.0;
        double lonRadar_2 = 8.0;
        double latRadar_2 = 24.0;
        double altRadar_2 = 0.0;
        aircraft_1.setPathObject(colorTraj_1, lineWidthTraj_1);
        aircraft_2.setPolylineObject(colorTraj_2, lineWidthTraj_2);
        aircraft_1.setTrajResolution(resDial);
        aircraft_2.setTrajResolution(resDial);
        aircraft_1.setGeoInit(latAC_1, lonAC_1, altAC_1);
        aircraft_2.setGeoInit(latAC_2, lonAC_2, altAC_2);
        if (trajType_1 == 1) {
            aircraft_1.setTrajTypeOne();
        } else if (trajType_1 == 2) {
            aircraft_1.setTrajTypeTwo();
        }
        if (trajType_2 == 1) {
            aircraft_2.setTrajTypeOne();
        } else if (trajType_2 == 2) {
            aircraft_2.setTrajTypeTwo();
        }
        to[0] = aircraft_1;
        to[1] = aircraft_2;
        ro_1.loadTrajectoryObject(aircraft_2);
        ro_1.setBaseCoord(latRadar_1, lonRadar_1, altRadar_1);
        ro_2.loadTrajectoryObject(aircraft_1);
        ro_2.setBaseCoord(latRadar_2, lonRadar_2, altRadar_2);
        ro[0] = ro_1;
        ro[1] = ro_2;
        ScenarioSettings ss = new ScenarioSettings();
        double[] vect = new double[]{latView, lonView, altView};
        ss.setViewSettings(vect);
        ss.setUTMGridOption(showUTMGrid);
        ss.setATMLayerOption(showAtmosphere);
        ss.setStarsLayerOption(showStars);
        ss.setTimeDelay(timeDelay);
        if (clipDistanceStatus) {
            ss.setClipDistances(clipDistanceStatus);
            ss.setClipDistances(nearClipDistanceVal, farClipDistanceVal);
        }
        ss.loadTrajectoryObjects(to);
        ss.loadRadarModels(ro);
        EarthView ev = new EarthView(ss);
        ev.configureEarthLayers();
        ev.trajSim();
    }
}

