/*
 * Decompiled with CFR 0.152.
 */
package earthproj;

import earthproj.RadarObjects;
import earthproj.TrajectoryObjects;

public class ScenarioSettings {
    private TrajectoryObjects[] to;
    private RadarObjects[] ro;
    private boolean UTMGridStatus = false;
    private boolean ATMLayerStatus = true;
    private boolean StarsLayerStatus = false;
    private boolean MSVEarthAerialStatus = true;
    private double initViewElevation;
    private double initViewLat;
    private double initViewLon;
    private boolean setClipDistances = false;
    private double nearClipDistanceVal = 0.0;
    private double farClipDistanceVal = 0.0;
    private int timeDelay = 100;

    public double[] getClipDistances() {
        double[] clipDistances = new double[]{this.nearClipDistanceVal, this.farClipDistanceVal};
        return clipDistances;
    }

    public RadarObjects[] getRadarModels() {
        return this.ro;
    }

    public TrajectoryObjects[] getTrajectoryObjects() {
        return this.to;
    }

    public boolean getClipDistanceStatus() {
        return this.setClipDistances;
    }

    public int getTimeDelay() {
        return this.timeDelay;
    }

    public boolean getUTMGridOption() {
        return this.UTMGridStatus;
    }

    public boolean getATMLayerOption() {
        return this.ATMLayerStatus;
    }

    public boolean getStarsLayerOption() {
        return this.StarsLayerStatus;
    }

    public boolean getMSVEarthAerialOption() {
        return this.MSVEarthAerialStatus;
    }

    public double[] getViewSettings() {
        double[] vect = new double[]{this.initViewLat, this.initViewLon, this.initViewElevation};
        return vect;
    }

    public void loadRadarModels(RadarObjects[] ro) {
        this.ro = ro;
    }

    public void loadTrajectoryObjects(TrajectoryObjects[] to) {
        this.to = to;
    }

    public void setClipDistances(double nearClipDistanceVal, double farClipDistanceVal) {
        this.nearClipDistanceVal = nearClipDistanceVal;
        this.farClipDistanceVal = farClipDistanceVal;
    }

    public void setClipDistances(boolean setClipDistances) {
        this.setClipDistances = setClipDistances;
    }

    public void setTimeDelay(int timeDelay) {
        this.timeDelay = timeDelay;
    }

    public void setUTMGridOption(boolean UTMGridStatus) {
        this.UTMGridStatus = UTMGridStatus;
    }

    public void setATMLayerOption(boolean ATMLayerStatus) {
        this.ATMLayerStatus = ATMLayerStatus;
    }

    public void setStarsLayerOption(boolean StarsLayerStatus) {
        this.StarsLayerStatus = StarsLayerStatus;
    }

    public void setMSVEarthAerialOption(boolean MSVEarthAerialStatus) {
        this.MSVEarthAerialStatus = MSVEarthAerialStatus;
    }

    public void setViewSettings(double[] vect) {
        this.initViewLat = vect[0];
        this.initViewLon = vect[1];
        this.initViewElevation = vect[2];
    }
}

