/*
 * Decompiled with CFR 0.152.
 */
package earthproj;

import earthproj.TrajectoryObjects;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Polyline;
import java.awt.Color;
import java.util.ArrayList;

public class RadarObjects {
    private TrajectoryObjects to;
    private final Polyline polyline = new Polyline();
    private final ArrayList<Position> pos;
    private double latTarg;
    private double lonTarg;
    private double altTarg;
    private double latBase;
    private double lonBase;
    private double altBase;
    private WorldWindowGLCanvas wwd;
    private final RenderableLayer layer;
    private double[] targData;
    private Vec4 pointOne;
    private Vec4 pointTwo;
    private final double rangeLimit;
    private final double angleLimit;

    public RadarObjects() {
        this.polyline.setColor(Color.YELLOW);
        this.polyline.setLineWidth(1.0);
        this.polyline.setPathType(1);
        this.polyline.setFollowTerrain(false);
        this.polyline.setNumSubsegments(1);
        this.pos = new ArrayList();
        this.layer = new RenderableLayer();
        this.targData = new double[3];
        this.rangeLimit = 2.0E7;
        this.angleLimit = 90.0;
    }

    public void activateRadarTracking() {
        this.targData = this.to.getGEOCoord();
        this.latTarg = this.targData[0];
        this.lonTarg = this.targData[1];
        this.altTarg = this.targData[2];
        this.pointTwo = this.wwd.getModel().getGlobe().computePointFromPosition(Position.fromDegrees(this.latTarg, this.lonTarg, this.altTarg));
        Vec4 rangeVec = this.pointTwo.subtract3(this.pointOne);
        double rangeMag = rangeVec.getLength3();
        Angle rangeAngle = this.pointOne.angleBetween3(rangeVec);
        if (rangeMag < this.rangeLimit && rangeAngle.getDegrees() < this.angleLimit) {
            this.pos.add(0, Position.fromDegrees(this.latBase, this.lonBase, this.altBase));
            this.pos.add(1, Position.fromDegrees(this.latTarg, this.lonTarg, this.altTarg));
            this.polyline.setPositions(this.pos);
            this.wwd.redrawNow();
            this.pos.clear();
        } else {
            this.pos.clear();
            this.polyline.setPositions(this.pos);
            this.wwd.redrawNow();
        }
    }

    public void setBaseCoord(double lat, double lon, double alt) {
        this.lonBase = lon;
        this.latBase = lat;
        this.altBase = alt;
    }

    public void loadWorldWindModel(WorldWindowGLCanvas wwd) {
        this.wwd = wwd;
        this.layer.addRenderable(this.polyline);
        this.wwd.getModel().getLayers().add(this.layer);
        this.pointOne = wwd.getModel().getGlobe().computePointFromPosition(Position.fromDegrees(this.latBase, this.lonBase, this.altBase));
    }

    public void loadTrajectoryObject(TrajectoryObjects to) {
        this.to = to;
    }
}

