/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import com.sun.opengl.util.texture.Texture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import java.awt.Color;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class OGLRenderToTextureSupport {
    protected boolean isFramebufferObjectEnabled = true;
    protected Texture colorTarget;
    protected Rectangle drawRegion;
    protected OGLStackHandler stackHandler = new OGLStackHandler();
    protected int framebufferObject;

    public boolean isEnableFramebufferObject() {
        return this.isFramebufferObjectEnabled;
    }

    public void setEnableFramebufferObject(boolean bl) {
        this.isFramebufferObjectEnabled = bl;
    }

    public Texture getColorTarget() {
        return this.colorTarget;
    }

    public void setColorTarget(DrawContext drawContext, Texture texture) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.colorTarget == texture) {
            return;
        }
        if (this.colorTarget != null) {
            this.flushColor(drawContext);
        }
        if (this.useFramebufferObject(drawContext)) {
            this.bindFramebufferColorAttachment(drawContext, texture);
        }
        this.colorTarget = texture;
    }

    public void clear(DrawContext drawContext, Color color) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.colorTarget == null) {
            return;
        }
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        fArray[0] = fArray[0] * fArray[3];
        fArray[1] = fArray[1] * fArray[3];
        fArray[2] = fArray[2] * fArray[3];
        GL gL = drawContext.getGL();
        gL.glClearColor(fArray[0], fArray[1], fArray[2], fArray[3]);
        gL.glClear(16384);
    }

    public void flush(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.flushColor(drawContext);
    }

    public void beginRendering(DrawContext drawContext, int n, int n2, int n3, int n4) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = drawContext.getGL();
        this.drawRegion = new Rectangle(n, n2, n3, n4);
        this.stackHandler.pushAttrib(gL, 547072);
        this.stackHandler.pushTextureIdentity(gL);
        this.stackHandler.pushProjectionIdentity(gL);
        gL.glOrtho(n, n + n3, n2, n2 + n4, -1.0, 1.0);
        this.stackHandler.pushModelviewIdentity(gL);
        gL.glDisable(2929);
        gL.glDepthMask(false);
        gL.glEnable(3089);
        gL.glScissor(n, n2, n3, n4);
        gL.glViewport(n, n2, n3, n4);
        if (this.useFramebufferObject(drawContext)) {
            this.beginFramebufferObjectRendering(drawContext);
        }
    }

    public void endRendering(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.flush(drawContext);
        if (this.useFramebufferObject(drawContext)) {
            if (this.colorTarget != null) {
                this.bindFramebufferColorAttachment(drawContext, null);
            }
            this.endFramebufferObjectRendering(drawContext);
        }
        this.stackHandler.pop(drawContext.getGL());
        this.drawRegion = null;
        this.colorTarget = null;
    }

    protected void flushColor(DrawContext drawContext) {
        if (this.useFramebufferObject(drawContext)) {
            if (this.colorTarget != null && this.colorTarget.isUsingAutoMipmapGeneration()) {
                this.updateMipmaps(drawContext, this.colorTarget);
            }
        } else if (this.colorTarget != null) {
            this.copyScreenPixelsToTexture(drawContext, this.drawRegion.x, this.drawRegion.y, this.drawRegion.width, this.drawRegion.height, this.colorTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyScreenPixelsToTexture(DrawContext drawContext, int n, int n2, int n3, int n4, Texture texture) {
        int n5 = n3;
        int n6 = n4;
        if (n >= texture.getWidth() || n2 >= texture.getHeight()) {
            return;
        }
        if (n5 > texture.getWidth()) {
            n5 = texture.getWidth();
        }
        if (n6 > texture.getHeight()) {
            n6 = texture.getHeight();
        }
        GL gL = drawContext.getGL();
        try {
            texture.enable();
            texture.bind();
            gL.glCopyTexSubImage2D(texture.getTarget(), 0, n, n2, n, n2, n5, n6);
        }
        finally {
            texture.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMipmaps(DrawContext drawContext, Texture texture) {
        GL gL = drawContext.getGL();
        try {
            texture.enable();
            texture.bind();
            gL.glGenerateMipmapEXT(texture.getTarget());
        }
        finally {
            texture.disable();
        }
    }

    protected boolean useFramebufferObject(DrawContext drawContext) {
        return this.isEnableFramebufferObject() && drawContext.getGLRuntimeCapabilities().isUseFramebufferObject();
    }

    protected void beginFramebufferObjectRendering(DrawContext drawContext) {
        int[] nArray = new int[1];
        GL gL = drawContext.getGL();
        gL.glGenFramebuffersEXT(1, nArray, 0);
        gL.glBindFramebufferEXT(36160, nArray[0]);
        this.framebufferObject = nArray[0];
        if (this.framebufferObject == 0) {
            throw new IllegalStateException("Frame Buffer Object not created.");
        }
    }

    protected void endFramebufferObjectRendering(DrawContext drawContext) {
        int[] nArray = new int[]{this.framebufferObject};
        GL gL = drawContext.getGL();
        gL.glBindFramebufferEXT(36160, 0);
        gL.glDeleteFramebuffersEXT(1, nArray, 0);
        this.framebufferObject = 0;
    }

    protected void bindFramebufferColorAttachment(DrawContext drawContext, Texture texture) {
        GL gL = drawContext.getGL();
        if (texture != null) {
            gL.glFramebufferTexture2DEXT(36160, 36064, 3553, texture.getTextureObject(), 0);
            this.checkFramebufferStatus(drawContext);
        } else {
            gL.glFramebufferTexture2DEXT(36160, 36064, 3553, 0, 0);
        }
    }

    protected void checkFramebufferStatus(DrawContext drawContext) {
        int n = drawContext.getGL().glCheckFramebufferStatusEXT(36160);
        switch (n) {
            case 36053: {
                break;
            }
            case 36061: {
                throw new IllegalStateException(OGLRenderToTextureSupport.getFramebufferStatusString(n));
            }
            default: {
                throw new IllegalStateException(OGLRenderToTextureSupport.getFramebufferStatusString(n));
            }
        }
    }

    protected static String getFramebufferStatusString(int n) {
        switch (n) {
            case 36053: {
                return Logging.getMessage("OGL.FramebufferComplete");
            }
            case 36054: {
                return Logging.getMessage("OGL.FramebufferIncompleteAttachment");
            }
            case 36057: {
                return Logging.getMessage("OGL.FramebufferIncompleteDimensions");
            }
            case 36059: {
                return Logging.getMessage("OGL.FramebufferIncompleteDrawBuffer");
            }
            case 36056: {
                return Logging.getMessage("OGL.FramebufferIncompleteDuplicateAttachment");
            }
            case 36058: {
                return Logging.getMessage("OGL.FramebufferIncompleteFormats");
            }
            case 36265: {
                return Logging.getMessage("OGL.FramebufferIncompleteLayerCount");
            }
            case 36264: {
                return Logging.getMessage("OGL.FramebufferIncompleteLayerTargets");
            }
            case 36055: {
                return Logging.getMessage("OGL.FramebufferIncompleteMissingAttachment");
            }
            case 36182: {
                return Logging.getMessage("OGL.FramebufferIncompleteMultisample");
            }
            case 36060: {
                return Logging.getMessage("OGL.FramebufferIncompleteReadBuffer");
            }
            case 36061: {
                return Logging.getMessage("OGL.FramebufferUnsupported");
            }
        }
        return null;
    }
}

