/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.WWMath;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class BoundedHashMap<K, V>
extends LinkedHashMap<K, V> {
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int capacity;

    public BoundedHashMap(int n, boolean bl) {
        super(BoundedHashMap.getInitialCapacity(n, 0.75f), 0.75f, bl);
        this.capacity = n;
    }

    public BoundedHashMap(int n) {
        this(n, false);
    }

    public BoundedHashMap() {
        this(16);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int n) {
        this.capacity = n;
        this.removeOverCapacityEntries();
    }

    protected static int getInitialCapacity(int n, float f) {
        return WWMath.powerOfTwoCeiling((int)Math.ceil((float)n / f));
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
        return this.size() > this.getCapacity();
    }

    protected void removeOverCapacityEntries() {
        int n = this.size() - this.getCapacity();
        if (n <= 0) {
            return;
        }
        Iterator iterator = this.entrySet().iterator();
        for (int i = 0; i < n && iterator.hasNext(); ++i) {
            iterator.next();
            iterator.remove();
        }
    }
}

